/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.skin.rose.Rose;

public class HtmlColorAndStyle {
    private static final Rose rose = new Rose();
    private final HtmlColor color;
    private final LinkStyle style;

    public String toString() {
        return this.color + " " + (Object)((Object)this.style);
    }

    public static Rainbow fromColor(HtmlColor color) {
        if (color == null) {
            return Rainbow.none();
        }
        return Rainbow.build(new HtmlColorAndStyle(color));
    }

    public static Rainbow build(ISkinParam skinParam) {
        return HtmlColorAndStyle.fromColor(rose.getHtmlColor(skinParam, ColorParam.activityArrow));
    }

    private HtmlColorAndStyle(HtmlColor color) {
        this(color, LinkStyle.NORMAL);
    }

    public HtmlColorAndStyle(HtmlColor color, LinkStyle style) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.color = color;
        this.style = style;
    }

    public HtmlColor getColor() {
        return this.color;
    }

    public LinkStyle getStyle() {
        return this.style;
    }

    public static HtmlColorAndStyle build(ISkinParam skinParam, String definition) {
        HtmlColor color = HtmlColorAndStyle.build((ISkinParam)skinParam).getColors().get((int)0).color;
        LinkStyle style = LinkStyle.NORMAL;
        IHtmlColorSet set = skinParam.getIHtmlColorSet();
        for (String s : definition.split(",")) {
            LinkStyle tmpStyle = LinkStyle.fromString(s);
            if (tmpStyle != LinkStyle.NORMAL) {
                style = tmpStyle;
                continue;
            }
            HtmlColor tmpColor = set.getColorIfValid(s);
            if (tmpColor == null) continue;
            color = tmpColor;
        }
        return new HtmlColorAndStyle(color, style);
    }
}

