/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.EnumSet;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.ugraphic.UFont;

public enum FontStyle {
    PLAIN,
    ITALIC,
    BOLD,
    UNDERLINE,
    STRIKE,
    WAVE,
    BACKCOLOR;


    public UFont mutateFont(UFont font) {
        if (this == ITALIC) {
            return font.deriveStyle(font.getStyle() | 2);
        }
        if (this == BOLD) {
            return font.deriveStyle(font.getStyle() | 1);
        }
        return font;
    }

    public String getActivationPattern() {
        if (this == ITALIC) {
            return "\\<[iI]\\>";
        }
        if (this == BOLD) {
            return "\\<[bB]\\>";
        }
        if (this == UNDERLINE) {
            return "\\<[uU](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == WAVE) {
            return "\\<[wW](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == BACKCOLOR) {
            return "\\<[bB][aA][cC][kK](?::(#?\\w+(?:[-\\\\|/]#?\\w+)?))?\\>";
        }
        if (this == STRIKE) {
            return "\\<(?:s|S|strike|STRIKE|del|DEL)(?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        return null;
    }

    public boolean canHaveExtendedColor() {
        if (this == UNDERLINE) {
            return true;
        }
        if (this == WAVE) {
            return true;
        }
        if (this == BACKCOLOR) {
            return true;
        }
        return this == STRIKE;
    }

    public String getCreoleSyntax() {
        if (this == ITALIC) {
            return "//";
        }
        if (this == BOLD) {
            return "\\*\\*";
        }
        if (this == UNDERLINE) {
            return "__";
        }
        if (this == WAVE) {
            return "~~";
        }
        if (this == STRIKE) {
            return "--";
        }
        throw new UnsupportedOperationException();
    }

    public HtmlColor getExtendedColor(String s) {
        Matcher2 m = MyPattern.cmpile(this.getActivationPattern()).matcher(s);
        if (!m.find() || m.groupCount() != 1) {
            return null;
        }
        String color = m.group(1);
        if (HtmlColorSet.getInstance().getColorIfValid(color) != null) {
            return HtmlColorSet.getInstance().getColorIfValid(color);
        }
        return null;
    }

    public String getDeactivationPattern() {
        if (this == ITALIC) {
            return "\\</[iI]\\>";
        }
        if (this == BOLD) {
            return "\\</[bB]\\>";
        }
        if (this == UNDERLINE) {
            return "\\</[uU]\\>";
        }
        if (this == WAVE) {
            return "\\</[wW]\\>";
        }
        if (this == BACKCOLOR) {
            return "\\</[bB][aA][cC][kK]\\>";
        }
        if (this == STRIKE) {
            return "\\</(?:s|S|strike|STRIKE|del|DEL)\\>";
        }
        return null;
    }

    public static FontStyle getStyle(String line) {
        for (FontStyle style : EnumSet.allOf(FontStyle.class)) {
            if (style == PLAIN || !line.matches(style.getActivationPattern()) && !line.matches(style.getDeactivationPattern())) continue;
            return style;
        }
        throw new IllegalArgumentException(line);
    }
}

