/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockBordered;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.webp.Portrait;
import net.sourceforge.plantuml.webp.Portraits;

public class DateEventUtils {
    public static TextBlock addEvent(TextBlock textBlock, HtmlColor color) {
        try {
            String today = new SimpleDateFormat("MM-dd", Locale.US).format(new Date());
            if ("11-05".equals(today)) {
                List<String> asList = Arrays.asList("<u>November 5th, 1955", "Doc Brown's discovery of the Flux Capacitor, that makes time-travel possible.");
                return TextBlockUtils.mergeTB(textBlock, DateEventUtils.getComment(asList, color), HorizontalAlignment.LEFT);
            }
            if ("08-29".equals(today)) {
                List<String> asList = Arrays.asList("<u>August 29th, 1997", "Skynet becomes self-aware at 02:14 AM Eastern Time.");
                return TextBlockUtils.mergeTB(textBlock, DateEventUtils.getComment(asList, color), HorizontalAlignment.LEFT);
            }
            if ("06-29".equals(today)) {
                List<String> asList = Arrays.asList("<u>June 29th, 1975", "\"It was the first time in history that anyone had typed", "a character on a keyboard and seen it show up on their", "own computer's screen right in front of them.\"", "\t\t\t\t\t\t\t\t\t\t<i>Steve Wozniak");
                return TextBlockUtils.mergeTB(textBlock, DateEventUtils.getComment(asList, color), HorizontalAlignment.LEFT);
            }
            if ("01-07".equals(today) || "01-08".equals(today) && DateEventUtils.getDayOfWeek() == 2) {
                return DateEventUtils.addCharlie(textBlock);
            }
            if ("11-13".equals(today) || "11-14".equals(today) && DateEventUtils.getDayOfWeek() == 2) {
                return DateEventUtils.addMemorial(textBlock, color);
            }
        }
        catch (Throwable t) {
            Log.debug("Error " + t);
        }
        return textBlock;
    }

    private static synchronized int getDayOfWeek() {
        return Calendar.getInstance().get(7);
    }

    private static TextBlock addMemorial(TextBlock textBlock, HtmlColor color) {
        Portrait portrait = Portraits.getOne();
        if (portrait == null) {
            return textBlock;
        }
        final BufferedImage im = portrait.getBufferedImage();
        if (im == null) {
            return textBlock;
        }
        String name = portrait.getName();
        String quote = portrait.getQuote();
        String age = "" + portrait.getAge() + " years old";
        UFont font12 = new UFont("SansSerif", 1, 12);
        TextBlock comment = Display.create(name, age, quote).create(new FontConfiguration(font12, color, HtmlColorUtils.BLUE, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        comment = TextBlockUtils.withMinWidth(TextBlockUtils.withMargin(comment, 4.0, 4.0), 800.0, HorizontalAlignment.LEFT);
        TextBlock bottom0 = DateEventUtils.getComment(Arrays.asList("A thought for those who died in Paris the 13th November 2015."), color);
        AbstractTextBlock bottom1 = new AbstractTextBlock(){
            private double margin = 10.0;

            @Override
            public void drawU(UGraphic ug) {
                ug = ug.apply(new UTranslate(0.0, this.margin));
                ug.draw(new UImage(im));
                if (ug instanceof LimitFinder) {
                    return;
                }
                Portraits.nextOne();
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(im.getWidth(), this.margin + (double)im.getHeight());
            }
        };
        TextBlock bottom = TextBlockUtils.mergeTB(bottom0, TextBlockUtils.mergeLR(bottom1, comment, VerticalAlignment.CENTER), HorizontalAlignment.LEFT);
        TextBlock mergeTB = TextBlockUtils.mergeTB(textBlock, bottom, HorizontalAlignment.LEFT);
        return DateEventUtils.addMajesty(mergeTB, color);
    }

    public static TextBlock addMajesty(TextBlock block2, HtmlColor color) {
        UFont font12 = new UFont("SansSerif", 1, 12);
        String arabic1 = "<size:16>\u0625\u0646 \u0627\u0644\u0625\u0631\u0647\u0627\u0628\u064a\u064a\u0646 \u0628\u0627\u0633\u0645 \u0627\u0644\u0625\u0633\u0644\u0627\u0645 \u0644\u064a\u0633\u0648\u0627 \u0645\u0633\u0644\u0645\u064a\u0646\u060c \u0648\u0644\u0627 \u064a\u0631\u0628\u0637\u0647\u0645 \u0628\u0627\u0644\u0625\u0633\u0644\u0627\u0645 \u0625\u0644\u0627 \u0627\u0644\u062f\u0648\u0627\u0641\u0639 \u0627\u0644\u062a\u064a \u064a\u0631\u0643\u0628\u0648\u0646 \u0639\u0644\u064a\u0647\u0627 \u0644\u062a\u0628\u0631\u064a\u0631 \u062c\u0631\u0627\u0626\u0645\u0647\u0645 \u0648\u062d\u0645\u0627\u0642\u0627\u062a\u0647\u0645.";
        String arabic2 = "<size:16>\u0641\u0647\u0645 \u0642\u0648\u0645 \u0636\u0627\u0644\u0648\u0646\u060c \u0645\u0635\u064a\u0631\u0647\u0645 \u062c\u0647\u0646\u0645 \u062e\u0627\u0644\u062f\u064a\u0646 \u0641\u064a\u0647\u0627 \u0623\u0628\u062f\u0627.";
        String english1 = "<size:10>Those who engage in terrorism, in the name of Islam, are not Muslims.";
        String english2 = "<size:10>Their only link to Islam is the pretexts they use to justify their crimes and their folly.";
        String english3 = "<size:10>They have strayed from the right path, and their fate is to dwell forever in hell.";
        TextBlock arabic = Display.create(" ", "<size:16>\u0625\u0646 \u0627\u0644\u0625\u0631\u0647\u0627\u0628\u064a\u064a\u0646 \u0628\u0627\u0633\u0645 \u0627\u0644\u0625\u0633\u0644\u0627\u0645 \u0644\u064a\u0633\u0648\u0627 \u0645\u0633\u0644\u0645\u064a\u0646\u060c \u0648\u0644\u0627 \u064a\u0631\u0628\u0637\u0647\u0645 \u0628\u0627\u0644\u0625\u0633\u0644\u0627\u0645 \u0625\u0644\u0627 \u0627\u0644\u062f\u0648\u0627\u0641\u0639 \u0627\u0644\u062a\u064a \u064a\u0631\u0643\u0628\u0648\u0646 \u0639\u0644\u064a\u0647\u0627 \u0644\u062a\u0628\u0631\u064a\u0631 \u062c\u0631\u0627\u0626\u0645\u0647\u0645 \u0648\u062d\u0645\u0627\u0642\u0627\u062a\u0647\u0645.", "<size:16>\u0641\u0647\u0645 \u0642\u0648\u0645 \u0636\u0627\u0644\u0648\u0646\u060c \u0645\u0635\u064a\u0631\u0647\u0645 \u062c\u0647\u0646\u0645 \u062e\u0627\u0644\u062f\u064a\u0646 \u0641\u064a\u0647\u0627 \u0623\u0628\u062f\u0627.", "<size:16>\u0635\u0627\u062d\u0628 \u0627\u0644\u062c\u0644\u0627\u0644\u0629 \u0627\u0644\u0645\u0644\u0643 \u0645\u062d\u0645\u062f \u0627\u0644\u0633\u0627\u062f\u0633 \u0623\u0645\u064a\u0631 \u0627\u0644\u0645\u0624\u0645\u0646\u064a\u0646 \u0646\u0635\u0631\u0647 \u0627\u0644\u0644\u0647").create(new FontConfiguration(font12, color, HtmlColorUtils.BLUE, true), HorizontalAlignment.RIGHT, new SpriteContainerEmpty());
        TextBlock english = Display.create("<size:10>Those who engage in terrorism, in the name of Islam, are not Muslims.", "<size:10>Their only link to Islam is the pretexts they use to justify their crimes and their folly.", "<size:10>They have strayed from the right path, and their fate is to dwell forever in hell.", "<size:10>-- His Majesty the King Mohammed the Sixth, Commander of the Faithful").create(new FontConfiguration(font12, color, HtmlColorUtils.BLUE, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        return TextBlockUtils.mergeTB(block2, TextBlockUtils.mergeTB(arabic, english, HorizontalAlignment.LEFT), HorizontalAlignment.LEFT);
    }

    private static TextBlock addCharlie(TextBlock textBlock) {
        AbstractTextBlock charlie = new AbstractTextBlock(){
            private final BufferedImage charlie = PSystemVersion.getCharlieImage();

            @Override
            public void drawU(UGraphic ug) {
                ug.draw(new UImage(this.charlie));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(this.charlie.getWidth(), this.charlie.getHeight());
            }
        };
        return TextBlockUtils.mergeTB(charlie, textBlock, HorizontalAlignment.LEFT);
    }

    public static TextBlock getComment(List<String> asList, HtmlColor color) {
        UFont font = new UFont("SansSerif", 1, 14);
        TextBlock comment = Display.create(asList).create(new FontConfiguration(font, color, HtmlColorUtils.BLUE, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        comment = TextBlockUtils.withMargin(comment, 4.0, 4.0);
        comment = new TextBlockBordered(comment, color);
        comment = TextBlockUtils.withMargin(comment, 10.0, 10.0);
        return comment;
    }
}

