/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eggs;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.DateEventUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.webp.Portrait;

public class PSystemMemorial
extends AbstractPSystem {
    public static final String PARIS = "A thought for those who died in Paris the 13th November 2015.";
    private Portrait portrait;

    PSystemMemorial(Portrait portrait) {
        this.portrait = portrait;
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                String name = PSystemMemorial.this.portrait.getName();
                String quote = PSystemMemorial.this.portrait.getQuote();
                String age = "" + PSystemMemorial.this.portrait.getAge() + " years old";
                UFont font = new UFont("SansSerif", 1, 14);
                BufferedImage im = PSystemMemorial.this.portrait.getBufferedImage();
                FontConfiguration fc = new FontConfiguration(font, HtmlColorUtils.BLACK, HtmlColorUtils.BLACK, true);
                TextBlock top = DateEventUtils.getComment(Arrays.asList(PSystemMemorial.PARIS), HtmlColorUtils.BLACK);
                TextBlock tb = Display.create(name, age, quote).create(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                top.drawU(ug);
                ug = ug.apply(new UTranslate(0.0, top.calculateDimension(ug.getStringBounder()).getHeight() + 10.0));
                ug.draw(new UImage(im));
                ug = ug.apply(new UTranslate(im.getWidth() + 10, 0.0));
                tb.drawU(ug);
            }
        });
        return imageBuilder.writeImageTOBEMOVED(fileFormat, os);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Memorial)", this.getClass());
    }
}

