/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class PSystemDitaa
extends AbstractPSystem {
    private final ProcessingOptions processingOptions = new ProcessingOptions();
    private final boolean dropShadows;
    private final String data;
    private final float scale;

    public PSystemDitaa(String data, boolean performSeparationOfCommonEdges, boolean dropShadows, float scale) {
        this.data = data;
        this.dropShadows = dropShadows;
        this.processingOptions.setPerformSeparationOfCommonEdges(performSeparationOfCommonEdges);
        this.scale = scale;
    }

    PSystemDitaa add(String line) {
        return new PSystemDitaa(this.data + line + "\n", this.processingOptions.performSeparationOfCommonEdges(), this.dropShadows, this.scale);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Ditaa)", this.getClass());
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        if (fileFormat.getFileFormat() == FileFormat.ATXT) {
            os.write(this.getSource().getPlainString().getBytes());
            return new ImageDataSimple();
        }
        ConversionOptions options = new ConversionOptions();
        options.renderingOptions.setScale(this.scale);
        options.setDropShadows(this.dropShadows);
        TextGrid grid = new TextGrid();
        grid.initialiseWithText(this.data, null);
        Diagram diagram = new Diagram(grid, options, this.processingOptions);
        BufferedImage image = (BufferedImage)new BitmapRenderer().renderToImage(diagram, options.renderingOptions);
        ImageIO.write((RenderedImage)image, "png", os);
        return new ImageDataSimple(image.getWidth(), image.getHeight());
    }
}

