/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.USymbol;

public class DescriptionDiagram
extends AbstractEntityDiagram {
    private String namespaceSeparator = null;

    @Override
    public ILeaf getOrCreateLeaf(Code code, LeafType type, USymbol symbol) {
        if (this.namespaceSeparator != null) {
            code = code.withSeparator(this.namespaceSeparator);
        }
        if (this.namespaceSeparator != null && code.getFullName().contains(this.namespaceSeparator)) {
            Code fullyCode = code;
        }
        if (type == null) {
            String code2 = code.getFullName();
            if (code2.startsWith("[") && code2.endsWith("]")) {
                USymbol sym = this.getSkinParam().useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1;
                return this.getOrCreateLeafDefault(code.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:"), LeafType.DESCRIPTION, sym);
            }
            if (code2.startsWith(":") && code2.endsWith(":")) {
                return this.getOrCreateLeafDefault(code.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:"), LeafType.DESCRIPTION, USymbol.ACTOR);
            }
            if (code2.startsWith("()")) {
                code2 = StringUtils.trin(code2.substring(2));
                code2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(code2);
                return this.getOrCreateLeafDefault(Code.of(code2), LeafType.DESCRIPTION, USymbol.INTERFACE);
            }
            code = code.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
            return this.getOrCreateLeafDefault(code, LeafType.STILL_UNKNOWN, symbol);
        }
        return this.getOrCreateLeafDefault(code, type, symbol);
    }

    private boolean isUsecase() {
        for (ILeaf leaf : this.getLeafsvalues()) {
            LeafType type = leaf.getEntityType();
            USymbol usymbol = leaf.getUSymbol();
            if (type != LeafType.USECASE && usymbol != USymbol.ACTOR) continue;
            return true;
        }
        return false;
    }

    @Override
    public void makeDiagramReady() {
        super.makeDiagramReady();
        LeafType defaultType = this.isUsecase() ? LeafType.DESCRIPTION : LeafType.DESCRIPTION;
        USymbol defaultSymbol = this.isUsecase() ? USymbol.ACTOR : USymbol.INTERFACE;
        for (ILeaf leaf : this.getLeafsvalues()) {
            if (leaf.getEntityType() != LeafType.STILL_UNKNOWN) continue;
            leaf.muteToType(defaultType, defaultSymbol);
        }
    }

    @Override
    public String checkFinalError() {
        this.applySingleStrategy();
        return super.checkFinalError();
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.DESCRIPTION;
    }

    public void setNamespaceSeparator(String namespaceSeparator) {
        this.namespaceSeparator = namespaceSeparator;
    }

    @Override
    public String getNamespaceSeparator() {
        return this.namespaceSeparator;
    }
}

