/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.dedication.Dedication;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

public class PSystemDedication
extends AbstractPSystem {
    private final Dedication dedication;
    private final String keepLetter;

    public PSystemDedication(Dedication dedication, String keepLetter) {
        this.dedication = dedication;
        this.keepLetter = keepLetter;
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                BufferedImage bufferedImage = PSystemDedication.this.dedication.getBufferedImage(PSystemDedication.this.keepLetter);
                if (bufferedImage != null) {
                    ug.draw(new UImage(bufferedImage));
                }
            }
        });
        return imageBuilder.writeImageTOBEMOVED(fileFormat, os);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Dedication)", this.getClass());
    }
}

