/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.GraphvizSolverB;
import net.sourceforge.plantuml.posimo.Path;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public final class CucaDiagramTxtMaker {
    private final FileFormat fileFormat;
    private final UGraphicTxt globalUg = new UGraphicTxt();

    private static double getXPixelPerChar() {
        return 5.0;
    }

    private static double getYPixelPerChar() {
        return 10.0;
    }

    public CucaDiagramTxtMaker(CucaDiagram diagram, FileFormat fileFormat) throws IOException {
        this.fileFormat = fileFormat;
        Cluster root = new Cluster(null, 0.0, 0.0);
        int uid = 0;
        HashMap<IEntity, Block> blocks = new HashMap<IEntity, Block>();
        for (IEntity iEntity : diagram.getLeafsvalues()) {
            double width = (double)this.getWidth(iEntity) * CucaDiagramTxtMaker.getXPixelPerChar();
            double height = (double)this.getHeight(iEntity) * CucaDiagramTxtMaker.getYPixelPerChar();
            Block b = new Block(uid++, width, height, null);
            root.addBloc(b);
            blocks.put(iEntity, b);
        }
        GraphvizSolverB solver = new GraphvizSolverB();
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (Link link : diagram.getLinks()) {
            Block b1 = (Block)blocks.get(link.getEntity1());
            Block b2 = (Block)blocks.get(link.getEntity2());
            arrayList.add(new Path(b1, b2, null, link.getLength()));
        }
        solver.solve(root, arrayList);
        for (Path path2 : arrayList) {
            path2.getDotPath().draw(this.globalUg.getCharArea(), CucaDiagramTxtMaker.getXPixelPerChar(), CucaDiagramTxtMaker.getYPixelPerChar());
        }
        for (IEntity iEntity : diagram.getLeafsvalues()) {
            Block b = (Block)blocks.get(iEntity);
            Point2D p = b.getPosition();
            this.printClass(iEntity, (UGraphicTxt)this.globalUg.apply(new UTranslate(p.getX() / CucaDiagramTxtMaker.getXPixelPerChar(), p.getY() / CucaDiagramTxtMaker.getYPixelPerChar())));
        }
    }

    private void printClass(IEntity ent, UGraphicTxt ug) {
        List<String> disp;
        int w = this.getWidth(ent);
        int h = this.getHeight(ent);
        ug.getCharArea().drawBoxSimple(0, 0, w, h);
        ug.getCharArea().drawStringsLR(ent.getDisplay().as(), 1, 1);
        int y = 2;
        ug.getCharArea().drawHLine('-', y, 1, w - 1);
        ++y;
        for (Member att : ent.getBodier().getFieldsToDisplay()) {
            disp = StringUtils.getWithNewlines(att.getDisplay(true));
            ug.getCharArea().drawStringsLR(disp, 1, y);
            y += StringUtils.getHeight(disp);
        }
        ug.getCharArea().drawHLine('-', y, 1, w - 1);
        ++y;
        for (Member att : ent.getBodier().getMethodsToDisplay()) {
            disp = StringUtils.getWithNewlines(att.getDisplay(true));
            ug.getCharArea().drawStringsLR(disp, 1, y);
            y += StringUtils.getHeight(disp);
        }
    }

    public List<File> createFiles(File suggestedFile) throws IOException {
        if (this.fileFormat == FileFormat.UTXT) {
            this.globalUg.getCharArea().print(new PrintStream(suggestedFile, "UTF-8"));
        } else {
            this.globalUg.getCharArea().print(new PrintStream(suggestedFile));
        }
        return Collections.singletonList(suggestedFile);
    }

    private int getHeight(IEntity entity) {
        int result = StringUtils.getHeight(entity.getDisplay());
        for (Member att : entity.getBodier().getMethodsToDisplay()) {
            result += StringUtils.getHeight(Display.getWithNewlines(att.getDisplay(true)));
        }
        for (Member att : entity.getBodier().getFieldsToDisplay()) {
            result += StringUtils.getHeight(Display.getWithNewlines(att.getDisplay(true)));
        }
        return result + 4;
    }

    private int getWidth(IEntity entity) {
        int w;
        int result = StringUtils.getWidth(entity.getDisplay());
        for (Member att : entity.getBodier().getMethodsToDisplay()) {
            w = StringUtils.getWidth(Display.getWithNewlines(att.getDisplay(true)));
            if (w <= result) continue;
            result = w;
        }
        for (Member att : entity.getBodier().getFieldsToDisplay()) {
            w = StringUtils.getWidth(Display.getWithNewlines(att.getDisplay(true)));
            if (w <= result) continue;
            result = w;
        }
        return result + 2;
    }

    public void createFiles(OutputStream os, int index) {
        this.globalUg.getCharArea().print(new PrintStream(os));
    }
}

