/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.GroupPngMakerState;
import net.sourceforge.plantuml.svek.IEntityImage;

public final class CucaDiagramSimplifierState {
    private final CucaDiagram diagram;
    private final StringBounder stringBounder;

    public CucaDiagramSimplifierState(CucaDiagram diagram, List<String> dotStrings, StringBounder stringBounder) throws IOException, InterruptedException {
        boolean changed;
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        do {
            changed = false;
            Collection<IGroup> groups = this.getOrdered(diagram.getRootGroup());
            for (IGroup g : groups) {
                if (!diagram.isAutarkic(g)) continue;
                IEntityImage img = this.computeImage(g);
                g.overideImage(img, g.getGroupType() == GroupType.CONCURRENT_STATE ? LeafType.STATE_CONCURRENT : LeafType.STATE);
                changed = true;
            }
        } while (changed);
    }

    private Collection<IGroup> getOrdered(IGroup root) {
        LinkedHashSet<IGroup> ordered = new LinkedHashSet<IGroup>();
        ordered.add(root);
        int size = 1;
        do {
            size = ordered.size();
            this.addOneLevel(ordered);
        } while (size != ordered.size());
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        for (IGroup g : ordered) {
            if (g instanceof GroupRoot) continue;
            result.add(0, g);
        }
        return result;
    }

    private void addOneLevel(Collection<IGroup> currents) {
        for (IGroup g : new ArrayList<IGroup>(currents)) {
            for (IGroup child : this.reverse(g.getChildren())) {
                currents.add(child);
            }
        }
    }

    private List<IGroup> reverse(Collection<IGroup> source) {
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        for (IGroup g : source) {
            result.add(0, g);
        }
        return result;
    }

    private IEntityImage computeImage(IGroup g) throws IOException, InterruptedException {
        GroupPngMakerState maker = new GroupPngMakerState(this.diagram, g, this.stringBounder);
        return maker.getImage();
    }
}

