/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.AbstractPlacementStrategy;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyVisibility;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Center;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Left;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import net.sourceforge.plantuml.utils.CharHidder;

public class MethodsOrFieldsArea
extends AbstractTextBlock
implements TextBlockWidth,
TextBlock,
WithPorts {
    private final FontParam fontParam;
    private final ISkinParam skinParam;
    private final HtmlColor color;
    private final HtmlColor hyperlinkColor;
    private final boolean useUnderlineForHyperlink;
    private final Rose rose = new Rose();
    private final List<Member> members = new ArrayList<Member>();
    private final HorizontalAlignment align;
    private final Stereotype stereotype;

    public TextBlock asBlockMemberImpl() {
        return new TextBlockLineBefore(TextBlockUtils.withMargin(this, 6.0, 4.0));
    }

    public MethodsOrFieldsArea(List<Member> members, FontParam fontParam, ISkinParam skinParam, Stereotype stereotype) {
        this(members, fontParam, skinParam, HorizontalAlignment.LEFT, stereotype);
    }

    public MethodsOrFieldsArea(List<Member> members, FontParam fontParam, ISkinParam skinParam, HorizontalAlignment align, Stereotype stereotype) {
        this.stereotype = stereotype;
        this.align = align;
        this.skinParam = skinParam;
        this.fontParam = fontParam;
        this.color = this.rose.getFontColor(skinParam, fontParam);
        this.hyperlinkColor = skinParam.getHyperlinkColor();
        this.useUnderlineForHyperlink = skinParam.useUnderlineForHyperlink();
        this.members.addAll(members);
    }

    private boolean hasSmallIcon() {
        if (this.skinParam.classAttributeIconSize() == 0) {
            return false;
        }
        for (Member m : this.members) {
            if (m.getVisibilityModifier() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double smallIcon = 0.0;
        if (this.hasSmallIcon()) {
            smallIcon = this.skinParam.getCircledCharacterRadius() + 3;
        }
        double x = 0.0;
        double y = 0.0;
        for (Member m : this.members) {
            TextBlock bloc = this.createTextBlock(m);
            Dimension2D dim = bloc.calculateDimension(stringBounder);
            x = Math.max(dim.getWidth(), x);
            y += dim.getHeight();
        }
        return new Dimension2DDouble(x += smallIcon, y);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        Ports result = new Ports();
        double y = 0.0;
        for (Member m : this.members) {
            TextBlock bloc = this.createTextBlock(m);
            Dimension2D dim = bloc.calculateDimension(stringBounder);
            result.add(m.getPort(), y, dim.getHeight());
            y += dim.getHeight();
        }
        return result;
    }

    private TextBlock createTextBlock(Member m) {
        boolean withVisibilityChar = this.skinParam.classAttributeIconSize() == 0;
        String s = m.getDisplay(withVisibilityChar);
        if (withVisibilityChar && s.startsWith("#")) {
            s = CharHidder.addTileAtBegin(s);
        }
        FontConfiguration config = new FontConfiguration(this.skinParam, this.fontParam, this.stereotype);
        if (m.isAbstract()) {
            config = config.italic();
        }
        if (m.isStatic()) {
            config = config.underline();
        }
        TextBlock bloc = Display.getWithNewlines(s).create(config, this.align, this.skinParam, CreoleMode.SIMPLE_LINE);
        bloc = TextBlockUtils.fullInnerPosition(bloc, m.getDisplay(false));
        return new TextBlockTracer(m, bloc);
    }

    private TextBlock getUBlock(VisibilityModifier modifier) {
        if (modifier == null) {
            return new AbstractTextBlock(){

                @Override
                public void drawU(UGraphic ug) {
                }

                @Override
                public Dimension2D calculateDimension(StringBounder stringBounder) {
                    return new Dimension2DDouble(1.0, 1.0);
                }
            };
        }
        HtmlColor back = modifier.getBackground() == null ? null : this.rose.getHtmlColor(this.skinParam, modifier.getBackground());
        HtmlColor fore = this.rose.getHtmlColor(this.skinParam, modifier.getForeground());
        TextBlock uBlock = modifier.getUBlock(this.skinParam.classAttributeIconSize(), fore, back);
        return uBlock;
    }

    @Override
    public TextBlock asTextBlock(double widthToUse) {
        return this;
    }

    public boolean contains(String member) {
        for (Member att : this.members) {
            if (!att.getDisplay(false).startsWith(member)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder) {
        ULayoutGroup group = this.getLayout(stringBounder);
        Dimension2D dim = this.calculateDimension(stringBounder);
        return group.getInnerPosition(member, dim.getWidth(), dim.getHeight(), stringBounder);
    }

    private ULayoutGroup getLayout(StringBounder stringBounder) {
        ULayoutGroup group;
        if (this.hasSmallIcon()) {
            group = new ULayoutGroup(new PlacementStrategyVisibility(stringBounder, this.skinParam.getCircledCharacterRadius() + 3));
            for (Member att : this.members) {
                TextBlock bloc = this.createTextBlock(att);
                VisibilityModifier modifier = att.getVisibilityModifier();
                group.add(this.getUBlock(modifier));
                group.add(bloc);
            }
        } else {
            AbstractPlacementStrategy placementStrategy;
            if (this.align == HorizontalAlignment.LEFT) {
                placementStrategy = new PlacementStrategyY1Y2Left(stringBounder);
            } else if (this.align == HorizontalAlignment.CENTER) {
                placementStrategy = new PlacementStrategyY1Y2Center(stringBounder);
            } else {
                throw new IllegalStateException();
            }
            group = new ULayoutGroup(placementStrategy);
            for (Member att : this.members) {
                TextBlock bloc = this.createTextBlock(att);
                group.add(bloc);
            }
        }
        return group;
    }

    @Override
    public void drawU(UGraphic ug) {
        ULayoutGroup group = this.getLayout(ug.getStringBounder());
        Dimension2D dim = this.calculateDimension(ug.getStringBounder());
        group.drawU(ug, dim.getWidth(), dim.getHeight());
    }

    static class TextBlockTracer
    extends AbstractTextBlock
    implements TextBlock {
        private final TextBlock bloc;
        private final Url url;

        public TextBlockTracer(Member m, TextBlock bloc) {
            this.bloc = bloc;
            this.url = m.getUrl();
        }

        @Override
        public void drawU(UGraphic ug) {
            if (this.url != null) {
                ug.startUrl(this.url);
            }
            this.bloc.drawU(ug);
            if (this.url != null) {
                ug.closeAction();
            }
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            Dimension2D dim = this.bloc.calculateDimension(stringBounder);
            return dim;
        }

        @Override
        public Rectangle2D getInnerPosition(String member, StringBounder stringBounder) {
            return this.bloc.getInnerPosition(member, stringBounder);
        }
    }
}

