/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkHat;
import net.sourceforge.plantuml.cucadiagram.LinkMiddleDecor;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class LinkType {
    private final LinkHat hat1;
    private final LinkDecor decor1;
    private final LinkStyle style;
    private final LinkDecor decor2;
    private final LinkHat hat2;
    private final LinkMiddleDecor middleDecor;

    public LinkType(LinkDecor decor1, LinkDecor decor2) {
        this(LinkHat.NONE, decor1, decor2, LinkHat.NONE);
    }

    public LinkType(LinkHat hat1, LinkDecor decor1, LinkDecor decor2, LinkHat hat2) {
        this(hat1, decor1, LinkStyle.NORMAL, LinkMiddleDecor.NONE, decor2, hat2);
    }

    public LinkType withoutDecors1() {
        return new LinkType(this.hat1, LinkDecor.NONE, this.style, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType withoutDecors2() {
        return new LinkType(this.hat1, this.decor1, this.style, this.middleDecor, LinkDecor.NONE, this.hat2);
    }

    public String toString() {
        return (Object)((Object)this.decor1) + "-" + (Object)((Object)this.style) + "-" + (Object)((Object)this.decor2);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        LinkType other = (LinkType)obj;
        return this.decor1 == other.decor1 && this.decor2 == other.decor2 && this.style == other.style;
    }

    private LinkType(LinkHat hat1, LinkDecor decor1, LinkStyle style, LinkMiddleDecor middleDecor, LinkDecor decor2, LinkHat hat2) {
        this.decor1 = decor1;
        this.style = style;
        this.decor2 = decor2;
        this.middleDecor = middleDecor;
        this.hat1 = hat1;
        this.hat2 = hat2;
    }

    public boolean isDashed() {
        return this.style == LinkStyle.DASHED;
    }

    public boolean isDotted() {
        return this.style == LinkStyle.DOTTED;
    }

    public boolean isBold() {
        return this.style == LinkStyle.BOLD;
    }

    public boolean isInvisible() {
        return this.style == LinkStyle.INVISIBLE;
    }

    public LinkType getDashed() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.DASHED, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType getDotted() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.DOTTED, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType getBold() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.BOLD, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType getInterfaceProvider() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.__toremove_INTERFACE_PROVIDER, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType getInterfaceUser() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.__toremove_INTERFACE_USER, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType getInversed() {
        return new LinkType(this.hat2, this.decor2, this.style, this.middleDecor, this.decor1, this.hat1);
    }

    public LinkType withMiddleCircle() {
        return new LinkType(this.hat1, this.decor1, this.style, LinkMiddleDecor.CIRCLE, this.decor2, this.hat2);
    }

    public LinkType withMiddleCircleCircled() {
        return new LinkType(this.hat1, this.decor1, this.style, LinkMiddleDecor.CIRCLE_CIRCLED, this.decor2, this.hat2);
    }

    public LinkType withMiddleCircleCircled1() {
        return new LinkType(this.hat1, this.decor1, this.style, LinkMiddleDecor.CIRCLE_CIRCLED1, this.decor2, this.hat2);
    }

    public LinkType withMiddleCircleCircled2() {
        return new LinkType(this.hat1, this.decor1, this.style, LinkMiddleDecor.CIRCLE_CIRCLED2, this.decor2, this.hat2);
    }

    public LinkType getInvisible() {
        return new LinkType(this.hat1, this.decor1, LinkStyle.INVISIBLE, this.middleDecor, this.decor2, this.hat2);
    }

    public String getSpecificDecorationSvek() {
        boolean isEmpty2;
        StringBuilder sb = new StringBuilder();
        boolean isEmpty1 = this.decor1 == LinkDecor.NONE && this.hat1 == LinkHat.NONE;
        boolean bl = isEmpty2 = this.decor2 == LinkDecor.NONE && this.hat2 == LinkHat.NONE;
        if (isEmpty1 && isEmpty2) {
            sb.append("arrowtail=none");
            sb.append(",arrowhead=none");
        } else if (!isEmpty1 && !isEmpty2) {
            sb.append("dir=both,");
            sb.append("arrowtail=empty");
            sb.append(",arrowhead=empty");
        } else if (isEmpty1 && !isEmpty2) {
            sb.append("arrowtail=empty");
            sb.append(",arrowhead=none");
            sb.append(",dir=back");
        } else if (!isEmpty1 && isEmpty2) {
            sb.append("arrowtail=none");
            sb.append(",arrowhead=empty");
        }
        double arrowsize = Math.max(this.decor1.getArrowSize(), this.decor2.getArrowSize());
        if (arrowsize > 0.0) {
            sb.append(",arrowsize=" + arrowsize);
        }
        return sb.toString();
    }

    public final LinkDecor getDecor1() {
        return this.decor1;
    }

    public final LinkStyle getStyle() {
        return this.style;
    }

    public final LinkDecor getDecor2() {
        return this.decor2;
    }

    public boolean isExtendsOrAgregationOrCompositionOrPlus() {
        return this.isExtends() || this.isAgregationOrComposition() || this.isPlus();
    }

    private boolean isExtends() {
        return this.decor1 == LinkDecor.EXTENDS || this.decor2 == LinkDecor.EXTENDS;
    }

    private boolean isPlus() {
        return this.decor1 == LinkDecor.PLUS || this.decor2 == LinkDecor.PLUS;
    }

    private boolean isAgregationOrComposition() {
        return this.decor1 == LinkDecor.AGREGATION || this.decor2 == LinkDecor.AGREGATION || this.decor1 == LinkDecor.COMPOSITION || this.decor2 == LinkDecor.COMPOSITION;
    }

    public LinkType getPart1() {
        return new LinkType(this.hat1, this.decor1, this.style, this.middleDecor, LinkDecor.NONE, LinkHat.NONE);
    }

    public LinkType getPart2() {
        return new LinkType(LinkHat.NONE, LinkDecor.NONE, this.style, this.middleDecor, this.decor2, this.hat2);
    }

    public UStroke getStroke() {
        if (this.style == LinkStyle.DASHED) {
            return new UStroke(7.0, 7.0, 1.0);
        }
        if (this.style == LinkStyle.DOTTED) {
            return new UStroke(1.0, 3.0, 1.0);
        }
        if (this.style == LinkStyle.BOLD) {
            return new UStroke(2.0);
        }
        return new UStroke();
    }

    public LinkMiddleDecor getMiddleDecor() {
        return this.middleDecor;
    }

    public LinkHat getHat1() {
        return this.hat1;
    }

    public LinkHat getHat2() {
        return this.hat2;
    }

    public LinkType withLollipopInterfaceEye2() {
        return new LinkType(this.hat1, LinkDecor.NONE, this.style, this.middleDecor, this.decor2, this.hat2);
    }

    public LinkType withLollipopInterfaceEye1() {
        return new LinkType(this.hat1, this.decor1, this.style, this.middleDecor, LinkDecor.NONE, this.hat2);
    }
}

