/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.code.Base64Coder;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.AtomImgSvg;
import net.sourceforge.plantuml.creole.AtomText;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.ImgValign;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TileImageSvg;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

public class AtomImg
implements Atom {
    private static final String DATA_IMAGE_PNG_BASE64 = "data:image/png;base64,";
    private final BufferedImage image;
    private final double scale;

    private AtomImg(BufferedImage image, double scale) {
        this.image = image;
        this.scale = scale;
    }

    public static Atom create(String src, ImgValign valign, int vspace, double scale) {
        UFont font = new UFont("Monospaced", 0, 14);
        FontConfiguration fc = FontConfiguration.blackBlueTrue(font);
        if (src.startsWith(DATA_IMAGE_PNG_BASE64)) {
            String data = src.substring(DATA_IMAGE_PNG_BASE64.length(), src.length());
            try {
                byte[] bytes = Base64Coder.decode(data);
                return AtomImg.build(src, fc, bytes, scale);
            }
            catch (Exception e) {
                return AtomText.create("ERROR " + e.toString(), fc);
            }
        }
        try {
            File f = FileSystem.getInstance().getFile(src);
            if (!f.exists()) {
                if (src.startsWith("http:") || src.startsWith("https:")) {
                    byte[] image = AtomImg.getFile(src);
                    return AtomImg.build(src, fc, image, scale);
                }
                return AtomText.create("(File not found: " + f + ")", fc);
            }
            if (f.getName().endsWith(".svg")) {
                return new AtomImgSvg(new TileImageSvg(f));
            }
            BufferedImage read = ImageIO.read(f);
            if (read == null) {
                return AtomText.create("(Cannot decode: " + f + ")", fc);
            }
            return new AtomImg(ImageIO.read(f), scale);
        }
        catch (IOException e) {
            return AtomText.create("ERROR " + e.toString(), fc);
        }
    }

    private static Atom build(String source, FontConfiguration fc, byte[] data, double scale) throws IOException {
        BufferedImage read = ImageIO.read(new ByteArrayInputStream(data));
        if (read == null) {
            return AtomText.create("(Cannot decode: " + source + ")", fc);
        }
        return new AtomImg(read, scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getFile(String host) throws IOException {
        ByteArrayOutputStream image = new ByteArrayOutputStream();
        InputStream input = null;
        try {
            int read;
            URL url = new URL(host);
            URLConnection connection = url.openConnection();
            input = connection.getInputStream();
            byte[] buffer = new byte[1024];
            while ((read = input.read(buffer)) > 0) {
                image.write(buffer, 0, read);
            }
            image.close();
            byte[] byArray = image.toByteArray();
            return byArray;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble((double)this.image.getWidth() * this.scale, (double)this.image.getHeight() * this.scale);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.draw(new UImage(this.image, this.scale));
    }
}

