/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.core.Diagram;

public abstract class SingleLineCommand2<S extends Diagram>
implements Command<S> {
    private final RegexConcat pattern;

    public SingleLineCommand2(RegexConcat pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        if (!pattern.getPattern().startsWith("^") || !pattern.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + pattern.getPattern());
        }
        this.pattern = pattern;
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.pattern.getPattern()};
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        if (lines.size() != 1) {
            return CommandControl.NOT_OK;
        }
        lines = lines.removeInnerComments();
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        String line = StringUtils.trin(lines.getFirst499());
        boolean result = this.pattern.match(line);
        if (result) {
            this.actionIfCommandValid();
        }
        return result ? CommandControl.OK : CommandControl.NOT_OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    @Override
    public final CommandExecutionResult execute(S system, BlocLines lines) {
        if (lines.size() != 1) {
            throw new IllegalArgumentException();
        }
        String line = StringUtils.trin((lines = lines.removeInnerComments()).getFirst499());
        if (this.isForbidden(line)) {
            return CommandExecutionResult.error("Forbidden line " + line);
        }
        RegexResult arg = this.pattern.matcher(line);
        if (arg == null) {
            return CommandExecutionResult.error("Cannot parse line " + line);
        }
        if (system instanceof PSystemError) {
            return CommandExecutionResult.error("PSystemError cannot be cast");
        }
        return this.executeArg(system, arg);
    }

    protected boolean isForbidden(CharSequence line) {
        return false;
    }

    protected abstract CommandExecutionResult executeArg(S var1, RegexResult var2);
}

