/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.ugraphic.sprite.SpriteImage;

public class CommandSpriteFile
extends SingleLineCommand2<UmlDiagram> {
    public CommandSpriteFile() {
        super(CommandSpriteFile.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("sprite[%s]+\\$?"), new RegexLeaf("NAME", "([\\p{L}0-9_]+)[%s]*"), new RegexLeaf("[%s]+"), new RegexLeaf("FILE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(UmlDiagram system, RegexResult arg) {
        BufferedImage im;
        String src = arg.get("FILE", 0);
        try {
            if (src.startsWith("jar:")) {
                String inner = src.substring(4) + ".png";
                InputStream is = SpriteImage.getInternalSprite(inner);
                if (is == null) {
                    return CommandExecutionResult.error("No such internal sprite: " + inner);
                }
                im = ImageIO.read(is);
            } else {
                File f = FileSystem.getInstance().getFile(src);
                if (!f.exists()) {
                    return CommandExecutionResult.error("File does not exist: " + src);
                }
                im = ImageIO.read(f);
            }
        }
        catch (IOException e) {
            Log.error("Error reading " + src + " " + e);
            return CommandExecutionResult.error("Cannot read: " + src);
        }
        system.addSprite(arg.get("NAME", 0), new SpriteImage(im));
        return CommandExecutionResult.ok();
    }
}

