/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;

public class CommandNamespace
extends SingleLineCommand2<ClassDiagram> {
    public CommandNamespace() {
        super(CommandNamespace.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^namespace[%s]+"), new RegexLeaf("NAME", "([\\p{L}0-9_][\\p{L}0-9_.:\\\\]*)"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*\\{$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram diagram, RegexResult arg) {
        String color;
        Code code = Code.of(arg.get("NAME", 0));
        IGroup currentPackage = diagram.getCurrentGroup();
        IGroup p = diagram.getOrCreateNamespace(code, Display.getWithNewlines(code), GroupType.PACKAGE, currentPackage);
        String stereotype = arg.get("STEREOTYPE", 0);
        if (stereotype != null) {
            p.setStereotype(new Stereotype(stereotype));
        }
        if ((color = arg.get("COLOR", 0)) != null) {
            p.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(color));
        }
        return CommandExecutionResult.ok();
    }
}

