/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.cucadiagram.Display;

public class BlocLines
implements Iterable<CharSequence> {
    private List<CharSequence> lines;

    public String toString() {
        return this.lines.toString();
    }

    private BlocLines(List<? extends CharSequence> lines) {
        this.lines = Collections.unmodifiableList(lines);
    }

    public Display toDisplay() {
        return Display.create(this.lines);
    }

    public static BlocLines single(CharSequence single) {
        return new BlocLines(Arrays.asList(single));
    }

    public static BlocLines getWithNewlines(CharSequence s) {
        return new BlocLines(StringUtils.getWithNewlines(s));
    }

    public BlocLines() {
        this(new ArrayList());
    }

    public BlocLines add2(CharSequence s) {
        ArrayList<CharSequence> copy = new ArrayList<CharSequence>(this.lines);
        copy.add(s);
        return new BlocLines(copy);
    }

    public List<CharSequence> getLines() {
        return this.lines;
    }

    public int size() {
        return this.lines.size();
    }

    public CharSequence get499(int i) {
        return this.lines.get(i);
    }

    public CharSequence getFirst499() {
        return this.lines.get(0);
    }

    public CharSequence getLast499() {
        return this.lines.get(this.lines.size() - 1);
    }

    public BlocLines cleanList2(MultilinesStrategy strategy) {
        ArrayList<CharSequence> copy = new ArrayList<CharSequence>(this.lines);
        strategy.cleanList(copy);
        return new BlocLines(copy);
    }

    public BlocLines trim(boolean removeEmptyLines) {
        ArrayList<CharSequence> copy = new ArrayList<CharSequence>(this.lines);
        for (int i = 0; i < copy.size(); ++i) {
            CharSequence s = (CharSequence)copy.get(i);
            copy.set(i, StringUtils.trin(s));
        }
        if (removeEmptyLines) {
            Iterator it = copy.iterator();
            while (it.hasNext()) {
                if (((CharSequence)it.next()).length() != 0) continue;
                it.remove();
            }
        }
        return new BlocLines(copy);
    }

    public BlocLines removeEmptyColumns() {
        if (!BlocLines.firstColumnRemovable(this.lines)) {
            return this;
        }
        ArrayList<CharSequence> copy = new ArrayList<CharSequence>(this.lines);
        do {
            for (int i = 0; i < copy.size(); ++i) {
                CharSequence s = (CharSequence)copy.get(i);
                if (s.length() <= 0) continue;
                copy.set(i, s.subSequence(1, s.length()));
            }
        } while (BlocLines.firstColumnRemovable(copy));
        return new BlocLines(copy);
    }

    private static boolean firstColumnRemovable(List<CharSequence> data) {
        boolean allEmpty = true;
        for (CharSequence s : data) {
            if (s.length() == 0) continue;
            allEmpty = false;
            char c = s.charAt(0);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return !allEmpty;
    }

    public char getLastChar() {
        CharSequence s = this.lines.get(this.lines.size() - 1);
        return s.charAt(s.length() - 1);
    }

    public BlocLines removeStartingAndEnding2(String data) {
        if (this.lines.size() == 0) {
            return this;
        }
        ArrayList<CharSequence> copy = new ArrayList<CharSequence>(this.lines);
        copy.set(0, data);
        int n = copy.size() - 1;
        CharSequence s = (CharSequence)copy.get(n);
        copy.set(n, s.subSequence(0, s.length() - 1));
        return new BlocLines(copy);
    }

    public BlocLines concat2() {
        StringBuilder sb = new StringBuilder();
        for (CharSequence line : this.lines) {
            sb.append(line);
            sb.append(StringUtils.hiddenNewLine());
        }
        return BlocLines.single(sb.substring(0, sb.length() - 1));
    }

    public BlocLines trimSmart(int referenceLine) {
        if (this.lines.size() <= referenceLine) {
            return this;
        }
        ArrayList<CharSequence> copy = new ArrayList<CharSequence>(this.lines);
        int nbStartingSpace = BlocLines.nbStartingSpace((CharSequence)copy.get(referenceLine));
        for (int i = referenceLine; i < copy.size(); ++i) {
            CharSequence s = (CharSequence)copy.get(i);
            copy.set(i, BlocLines.removeStartingSpaces(s, nbStartingSpace));
        }
        return new BlocLines(copy);
    }

    private static int nbStartingSpace(CharSequence s) {
        int nb;
        for (nb = 0; nb < s.length() && BlocLines.isSpaceOrTab(s.charAt(nb)); ++nb) {
        }
        return nb;
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private static CharSequence removeStartingSpaces(CharSequence arg, int nbStartingSpace) {
        int i;
        if (arg.length() == 0) {
            return arg;
        }
        for (i = 0; i < nbStartingSpace && i < arg.length() && BlocLines.isSpaceOrTab(arg.charAt(i)); ++i) {
        }
        if (i == 0) {
            return arg;
        }
        return arg.subSequence(i, arg.length());
    }

    public BlocLines subExtract(int start, int end) {
        List<CharSequence> copy = new ArrayList<CharSequence>(this.lines);
        copy = copy.subList(start, copy.size() - end);
        return new BlocLines(copy);
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return this.lines.iterator();
    }

    public BlocLines removeComments() {
        ArrayList<CharSequence> copy = new ArrayList<CharSequence>();
        boolean inComment = false;
        for (CharSequence cs : this.lines) {
            if (!inComment && MyPattern.mtches(cs, "(?i)^[%s]*([%q].*||/[%q].*[%q]/[%s]*)$")) continue;
            if (!inComment && MyPattern.mtches(cs, "(?i)^[%s]*/[%q]([^%q]|[%q][^/])*$")) {
                inComment = true;
                continue;
            }
            if (inComment && MyPattern.mtches(cs, "(?i)^([^%q]|[%q][^/])*[%q]/[%s]*$")) {
                inComment = false;
                continue;
            }
            if (inComment) continue;
            copy.add(cs);
        }
        return new BlocLines(copy);
    }

    public BlocLines removeInnerComments() {
        ArrayList<CharSequence> copy = new ArrayList<CharSequence>();
        for (CharSequence cs : this.lines) {
            copy.add(MyPattern.removeAll(cs, "/[%q].*?[%q]/"));
        }
        return new BlocLines(copy);
    }
}

