/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextArrow
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;
    private final ArrowConfiguration config;
    private final int maxAsciiMessageLength;

    public ComponentTextArrow(ComponentType type, ArrowConfiguration config, Display stringsToDisplay, FileFormat fileFormat, int maxAsciiMessageLength) {
        this.maxAsciiMessageLength = maxAsciiMessageLength;
        this.type = type;
        this.config = config;
        this.stringsToDisplay = ComponentTextArrow.clean(stringsToDisplay);
        this.fileFormat = fileFormat;
    }

    private static Display clean(Display orig) {
        if (orig.size() == 0 || !(orig.get(0) instanceof MessageNumber)) {
            return orig;
        }
        Display result = Display.empty();
        for (int i = 0; i < orig.size(); ++i) {
            CharSequence element = orig.get(i);
            if (i == 1) {
                element = ComponentTextArrow.removeTag(orig.get(0).toString()) + " " + element;
            }
            if (i == 0) continue;
            result = result.add(element);
        }
        return result;
    }

    private static String removeTag(String s) {
        return s.replaceAll("\\<[^<>]+\\>", "");
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        if (this.config.isHidden()) {
            return;
        }
        Dimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight();
        int textWidth = StringUtils.getWidth(this.stringsToDisplay);
        int yarrow = height - 2;
        charArea.drawHLine(this.fileFormat == FileFormat.UTXT ? (char)'\u2500' : '-', yarrow, 1, width);
        if (this.config.isDotted()) {
            for (int i = 1; i < width; i += 2) {
                charArea.drawChar(' ', i, yarrow);
            }
        }
        if (this.config.getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            charArea.drawChar('>', width - 1, yarrow);
        } else if (this.config.getArrowDirection() == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
            charArea.drawChar('<', 1, yarrow);
        } else if (this.config.getArrowDirection() == ArrowDirection.BOTH_DIRECTION) {
            charArea.drawChar('>', width - 1, yarrow);
            charArea.drawChar('<', 1, yarrow);
        } else {
            throw new UnsupportedOperationException();
        }
        charArea.drawStringsLR(this.stringsToDisplay.as(), (width - textWidth) / 2, 0);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 2;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        int width = StringUtils.getWidth(this.stringsToDisplay) + 2;
        if (this.maxAsciiMessageLength > 0) {
            return Math.min(this.maxAsciiMessageLength, width);
        }
        return width;
    }
}

