/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileCircleEnd
extends AbstractFtile {
    private static final int SIZE = 20;
    private final HtmlColor backColor;
    private final Swimlane swimlane;

    public FtileCircleEnd(ISkinParam skinParam, HtmlColor backColor, Swimlane swimlane) {
        super(skinParam);
        this.backColor = backColor;
        this.swimlane = swimlane;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        double xTheoricalPosition = 0.0;
        double yTheoricalPosition = 0.0;
        xTheoricalPosition = Math.round(xTheoricalPosition);
        yTheoricalPosition = Math.round(yTheoricalPosition);
        UEllipse circle = new UEllipse(20.0, 20.0);
        if (this.skinParam().shadowing()) {
            circle.setDeltaShadow(3.0);
        }
        ug = ug.apply(new UChangeColor(this.backColor));
        double thickness = 2.5;
        ug.apply(new UChangeBackColor(HtmlColorUtils.WHITE)).apply(new UStroke(1.5)).apply(new UTranslate(xTheoricalPosition, yTheoricalPosition)).draw(circle);
        double size2 = 17.5 / Math.sqrt(2.0);
        double delta = (20.0 - size2) / 2.0;
        ug = ug.apply(new UStroke(2.5));
        ug.apply(new UTranslate(delta, delta)).draw(new ULine(size2, size2));
        ug.apply(new UTranslate(delta, 20.0 - delta)).draw(new ULine(size2, -size2));
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        return new FtileGeometry(20.0, 20.0, 10.0, 0.0);
    }
}

