/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileBox
extends AbstractFtile {
    private static final int MARGIN = 10;
    private final TextBlock tb;
    private final LinkRendering inRenreding;
    private final Swimlane swimlane;
    private final BoxStyle style;
    private final ISkinParam skinParam;
    private final String print;

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.inRenreding;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public FtileBox(ISkinParam skinParam, Display label, UFont font, Swimlane swimlane, BoxStyle style) {
        super(skinParam);
        this.style = style;
        this.skinParam = skinParam;
        this.swimlane = swimlane;
        this.inRenreding = new LinkRendering(HtmlColorAndStyle.build(skinParam));
        FontConfiguration fc = new FontConfiguration(skinParam, FontParam.ACTIVITY, null);
        Sheet sheet = new CreoleParser(fc, skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), skinParam, CreoleMode.FULL).createSheet(label);
        this.tb = new SheetBlock2(new SheetBlock1(sheet, 0.0, skinParam.getPadding()), new MyStencil(), new UStroke(1.0));
        this.print = label.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    public void drawU(UGraphic ug) {
        FtileGeometry dimTotal = this.calculateDimension(ug.getStringBounder());
        double widthTotal = ((Dimension2D)dimTotal).getWidth();
        double heightTotal = ((Dimension2D)dimTotal).getHeight();
        UDrawable rect = this.style.getUDrawable(widthTotal, heightTotal, this.skinParam().shadowing());
        HtmlColor borderColor = SkinParamUtils.getColor(this.skinParam, ColorParam.activityBorder, null);
        HtmlColor backColor = SkinParamUtils.getColor(this.skinParam, ColorParam.activityBackground, null);
        ug = ug.apply(new UChangeColor(borderColor)).apply(new UChangeBackColor(backColor)).apply(this.getThickness());
        rect.drawU(ug);
        this.tb.drawU(ug.apply(new UTranslate(10.0, 10.0)));
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.tb.calculateDimension(stringBounder);
        return new FtileGeometry(Dimension2DDouble.delta(dim, 20.0, 20.0), dim.getWidth() / 2.0 + 10.0, 0.0, dim.getHeight() + 20.0);
    }

    class MyStencil
    implements Stencil {
        MyStencil() {
        }

        @Override
        public double getStartingX(StringBounder stringBounder, double y) {
            return -10.0;
        }

        @Override
        public double getEndingX(StringBounder stringBounder, double y) {
            FtileGeometry dim = FtileBox.this.calculateDimension(stringBounder);
            return ((Dimension2D)dim).getWidth() - 10.0;
        }
    }
}

