/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

public class FtileBlackBlock
extends AbstractFtile {
    private double width;
    private double height;
    private final HtmlColor colorBar;
    private final Swimlane swimlane;

    public FtileBlackBlock(ISkinParam skinParam, HtmlColor colorBar, Swimlane swimlane) {
        super(skinParam);
        this.colorBar = colorBar;
        this.swimlane = swimlane;
    }

    public void setDimenstion(double width, double height) {
        this.height = height;
        this.width = width;
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        return new FtileGeometry(this.width, this.height, this.width / 2.0, 0.0, this.height);
    }

    @Override
    public void drawU(UGraphic ug) {
        URectangle rect = new URectangle(this.width, this.height, 5.0, 5.0);
        if (this.skinParam().shadowing()) {
            rect.setDeltaShadow(3.0);
        }
        ug.apply(new UChangeColor(this.colorBar)).apply(new UChangeBackColor(this.colorBar)).draw(rect);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }
}

