/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileForkInner;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBox;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileCircleEnd;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileCircleStart;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileCircleStop;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorateIn;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorateOut;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;

public class VCompactFactory
implements FtileFactory {
    private final ISkinParam skinParam;
    private final Rose rose = new Rose();
    private final StringBounder stringBounder;

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public VCompactFactory(ISkinParam skinParam, StringBounder stringBounder) {
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
    }

    @Override
    public Ftile start(Swimlane swimlane) {
        HtmlColor color = this.rose.getHtmlColor(this.skinParam, ColorParam.activityStart);
        return new FtileCircleStart(this.skinParam(), color, swimlane);
    }

    @Override
    public Ftile stop(Swimlane swimlane) {
        HtmlColor color = this.rose.getHtmlColor(this.skinParam, ColorParam.activityEnd);
        return new FtileCircleStop(this.skinParam(), color, swimlane);
    }

    @Override
    public Ftile end(Swimlane swimlane) {
        HtmlColor color = this.rose.getHtmlColor(this.skinParam, ColorParam.activityEnd);
        return new FtileCircleEnd(this.skinParam(), color, swimlane);
    }

    @Override
    public Ftile activity(Display label, Swimlane swimlane, BoxStyle style, Colors colors) {
        UFont font = this.skinParam.getFont(null, false, FontParam.ACTIVITY);
        return new FtileBox(colors.mute(this.skinParam), label, font, swimlane, style);
    }

    @Override
    public Ftile addNote(Ftile ftile, Swimlane swimlane, Collection<PositionedNote> notes) {
        return ftile;
    }

    @Override
    public Ftile addUrl(Ftile ftile, Url url) {
        return ftile;
    }

    @Override
    public Ftile assembly(Ftile tile1, Ftile tile2) {
        return new FtileAssemblySimple(tile1, tile2);
    }

    @Override
    public Ftile repeat(Swimlane swimlane, Swimlane swimlaneOut, Ftile repeat, Display test, Display yes, Display out, HtmlColor color, LinkRendering backRepeatLinkRendering) {
        return repeat;
    }

    @Override
    public Ftile createWhile(Swimlane swimlane, Ftile whileBlock, Display test, Display yes, Display out, LinkRendering afterEndwhile, HtmlColor color) {
        return whileBlock;
    }

    @Override
    public Ftile createIf(Swimlane swimlane, List<Branch> thens, Branch elseBranch, LinkRendering afterEndwhile, LinkRendering topInlinkRendering) {
        ArrayList<Ftile> ftiles = new ArrayList<Ftile>();
        for (Branch branch : thens) {
            ftiles.add(branch.getFtile());
        }
        ftiles.add(elseBranch.getFtile());
        return new FtileForkInner(ftiles);
    }

    @Override
    public Ftile createFork(Swimlane swimlane, List<Ftile> all) {
        return new FtileForkInner(all);
    }

    @Override
    public Ftile createSplit(List<Ftile> all) {
        return new FtileForkInner(all);
    }

    @Override
    public Ftile createGroup(Ftile list, Display name, HtmlColor backColor, HtmlColor titleColor, Display headerNote, HtmlColor borderColor) {
        return list;
    }

    @Override
    public Ftile decorateIn(Ftile ftile, LinkRendering linkRendering) {
        return new FtileDecorateIn(ftile, linkRendering);
    }

    @Override
    public Ftile decorateOut(Ftile ftile, LinkRendering linkRendering) {
        return new FtileDecorateOut(ftile, linkRendering);
    }

    @Override
    public ISkinParam skinParam() {
        return this.skinParam;
    }
}

