/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class FtileWithNotes
extends AbstractFtile {
    private final Ftile tile;
    private TextBlock left;
    private TextBlock right;
    private final double suppSpace = 20.0;

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    public FtileWithNotes(Ftile tile, Collection<PositionedNote> notes, ISkinParam skinParam) {
        super(tile.skinParam());
        this.tile = tile;
        Rose rose = new Rose();
        HtmlColor noteBackgroundColor = rose.getHtmlColor(skinParam, ColorParam.noteBackground);
        HtmlColor borderColor = rose.getHtmlColor(skinParam, ColorParam.noteBorder);
        FontConfiguration fc = new FontConfiguration(skinParam, FontParam.NOTE, null);
        for (PositionedNote note : notes) {
            Sheet sheet = new CreoleParser(fc, skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), skinParam, CreoleMode.FULL).createSheet(note.getDisplay());
            SheetBlock1 sheet1 = new SheetBlock1(sheet, 0.0, skinParam.getPadding());
            TextBlock opale = TextBlockUtils.withMargin(new Opale(borderColor, noteBackgroundColor, sheet1, skinParam.shadowing(), false), 10.0, 10.0);
            if (note.getNotePosition() == NotePosition.LEFT) {
                if (this.left == null) {
                    this.left = opale;
                    continue;
                }
                this.left = TextBlockUtils.mergeTB(this.left, opale, HorizontalAlignment.CENTER);
                continue;
            }
            if (this.right == null) {
                this.right = opale;
                continue;
            }
            this.right = TextBlockUtils.mergeTB(this.right, opale, HorizontalAlignment.CENTER);
        }
        if (this.left == null) {
            this.left = TextBlockUtils.empty(0.0, 0.0);
        }
        if (this.right == null) {
            this.right = TextBlockUtils.empty(0.0, 0.0);
        }
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        double xDelta = this.left.calculateDimension(stringBounder).getWidth();
        double yDelta = (dimTotal.getHeight() - ((Dimension2D)dimTile).getHeight()) / 2.0;
        return new UTranslate(xDelta, yDelta);
    }

    private UTranslate getTranslateForLeft(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimLeft = this.left.calculateDimension(stringBounder);
        double xDelta = 0.0;
        double yDelta = (dimTotal.getHeight() - dimLeft.getHeight()) / 2.0;
        return new UTranslate(0.0, yDelta);
    }

    private UTranslate getTranslateForRight(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimRight = this.right.calculateDimension(stringBounder);
        double xDelta = dimTotal.getWidth() - dimRight.getWidth();
        double yDelta = (dimTotal.getHeight() - dimRight.getHeight()) / 2.0;
        return new UTranslate(xDelta, yDelta);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateForLeft(stringBounder)).draw(this.left);
        ug.apply(this.getTranslateForRight(stringBounder)).draw(this.right);
        ug.apply(this.getTranslate(stringBounder)).draw(this.tile);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry orig = this.tile.calculateDimension(stringBounder);
        UTranslate translate = this.getTranslate(stringBounder);
        if (orig.hasPointOut()) {
            return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy(), orig.getOutY() + translate.getDy());
        }
        return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        Dimension2D dimLeft = this.left.calculateDimension(stringBounder);
        Dimension2D dimRight = this.right.calculateDimension(stringBounder);
        double height = MathUtils.max(dimLeft.getHeight(), dimRight.getHeight(), ((Dimension2D)dimTile).getHeight());
        return new Dimension2DDouble(((Dimension2D)dimTile).getWidth() + dimLeft.getWidth() + dimRight.getWidth(), height);
    }
}

