/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ftile.Worm;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class WormMutation {
    private final List<UTranslate> translations = new ArrayList<UTranslate>();

    private WormMutation() {
    }

    public static WormMutation create(Worm worm, double delta) {
        String signature = worm.getDirectionsCode();
        if (signature.length() > 2) {
            return WormMutation.createFromLongSignature(signature, delta);
        }
        return WormMutation.createFromSimpleSignature(signature, delta);
    }

    private static WormMutation createFromLongSignature(String signature, double delta) {
        WormMutation result = new WormMutation();
        for (int i = 0; i < signature.length() - 1; ++i) {
            WormMutation tmp = WormMutation.createFromSimpleSignature(signature.substring(i, i + 2), delta);
            if (i == 0) {
                result.translations.add(tmp.translations.get(0));
            } else {
                UTranslate last = result.getLast();
                if (!last.isAlmostSame(tmp.translations.get(0))) {
                    tmp = tmp.reverse();
                }
            }
            result.translations.add(tmp.translations.get(1));
            if (i != signature.length() - 2) continue;
            result.translations.add(tmp.translations.get(2));
        }
        return result;
    }

    private WormMutation reverse() {
        WormMutation result = new WormMutation();
        for (UTranslate tr : this.translations) {
            result.translations.add(tr.reverse());
        }
        return result;
    }

    public UTranslate getLast() {
        return this.translations.get(this.translations.size() - 1);
    }

    public UTranslate getFirst() {
        return this.translations.get(0);
    }

    public int size() {
        return this.translations.size();
    }

    private static WormMutation createFromSimpleSignature(String signature, double delta) {
        WormMutation result = new WormMutation();
        if (signature.equals("D") || signature.equals("U")) {
            UTranslate translate = new UTranslate(delta, 0.0);
            result.translations.add(translate);
            result.translations.add(translate);
            return result;
        }
        if (signature.equals("L") || signature.equals("R")) {
            UTranslate translate = new UTranslate(0.0, delta);
            result.translations.add(translate);
            result.translations.add(translate);
            return result;
        }
        if (signature.equals("RD")) {
            result.translations.add(new UTranslate(0.0, -delta));
            result.translations.add(new UTranslate(delta, -delta));
            result.translations.add(new UTranslate(delta, 0.0));
            return result;
        }
        if (signature.equals("RU")) {
            result.translations.add(new UTranslate(0.0, delta));
            result.translations.add(new UTranslate(delta, delta));
            result.translations.add(new UTranslate(delta, 0.0));
            return result;
        }
        if (signature.equals("LD")) {
            result.translations.add(new UTranslate(0.0, -delta));
            result.translations.add(new UTranslate(-delta, -delta));
            result.translations.add(new UTranslate(-delta, 0.0));
            return result;
        }
        if (signature.equals("DL")) {
            result.translations.add(new UTranslate(delta, 0.0));
            result.translations.add(new UTranslate(delta, delta));
            result.translations.add(new UTranslate(0.0, delta));
            return result;
        }
        if (signature.equals("DR")) {
            result.translations.add(new UTranslate(-delta, 0.0));
            result.translations.add(new UTranslate(-delta, delta));
            result.translations.add(new UTranslate(0.0, delta));
            return result;
        }
        if (signature.equals("UL")) {
            result.translations.add(new UTranslate(delta, 0.0));
            result.translations.add(new UTranslate(delta, -delta));
            result.translations.add(new UTranslate(0.0, -delta));
            return result;
        }
        if (signature.equals("UR")) {
            result.translations.add(new UTranslate(-delta, 0.0));
            result.translations.add(new UTranslate(-delta, -delta));
            result.translations.add(new UTranslate(0.0, -delta));
            return result;
        }
        throw new UnsupportedOperationException(signature);
    }

    public UTranslate getTextTranslate(int size) {
        MinMax result = new MinMax();
        for (UTranslate tr : this.translations) {
            result.append(tr.getDx());
        }
        return new UTranslate(result.getExtreme() * (double)(size - 1), 0.0);
    }

    public Worm mute(Worm original) {
        Worm result = new Worm();
        for (int i = 0; i < original.size(); ++i) {
            result.addPoint(this.translations.get(i).getTranslated(original.get(i)));
        }
        return result;
    }

    private static class MinMax {
        private double min = Double.MAX_VALUE;
        private double max = Double.MIN_VALUE;

        private MinMax() {
        }

        private void append(double v) {
            if (v > this.max) {
                this.max = v;
            }
            if (v < this.min) {
                this.min = v;
            }
        }

        private double getExtreme() {
            if (Math.abs(this.max) > Math.abs(this.min)) {
                return this.max;
            }
            return this.min;
        }
    }
}

