/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageLegend
extends AbstractTextBlock
implements TextBlock {
    private final int cornersize = 10;
    private final HtmlColor legendBackgroundColor;
    private final HtmlColor legendColor;
    private final int marginX = 6;
    private final int marginY = 5;
    private final boolean withShadow;
    private final ISkinParam skinParam;
    private final TextBlock textBlock;

    private EntityImageLegend(Display note, ISkinParam skinParam) {
        this.withShadow = false;
        Rose rose = new Rose();
        this.skinParam = skinParam;
        this.legendBackgroundColor = rose.getHtmlColor(skinParam, ColorParam.legendBackground);
        this.legendColor = rose.getHtmlColor(skinParam, ColorParam.legendBorder);
        this.textBlock = note.create(new FontConfiguration(skinParam, FontParam.LEGEND, null), HorizontalAlignment.LEFT, skinParam);
    }

    public static TextBlock create(Display legend, ISkinParam skinParam) {
        return TextBlockUtils.withMargin(new EntityImageLegend(legend, skinParam), 8.0, 8.0);
    }

    private double getTextHeight(StringBounder stringBounder) {
        Dimension2D size = this.textBlock.calculateDimension(stringBounder);
        return size.getHeight() + 10.0;
    }

    private double getPureTextWidth(StringBounder stringBounder) {
        Dimension2D size = this.textBlock.calculateDimension(stringBounder);
        return size.getWidth();
    }

    private double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + 12.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double height = this.getTextHeight(stringBounder);
        double width = this.getTextWidth(stringBounder);
        return new Dimension2DDouble(width + 1.0, height + 1.0);
    }

    private UGraphic applyStroke(UGraphic ug) {
        UStroke stroke = this.skinParam.getThickness(LineParam.legendBorder, null);
        if (stroke == null) {
            return ug;
        }
        return ug.apply(stroke);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        UPolygon polygon = this.getPolygonNormal(stringBounder);
        if (this.withShadow) {
            polygon.setDeltaShadow(4.0);
        }
        ug = ug.apply(new UChangeBackColor(this.legendBackgroundColor)).apply(new UChangeColor(this.legendColor));
        ug = this.applyStroke(ug);
        ug.draw(polygon);
        this.textBlock.drawU(ug.apply(new UTranslate(6.0, 5.0)));
    }

    private UPolygon getPolygonNormal(StringBounder stringBounder) {
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        polygon.addPoint(0.0, this.getTextHeight(stringBounder));
        double width = this.getTextWidth(stringBounder);
        polygon.addPoint(width, this.getTextHeight(stringBounder));
        polygon.addPoint(width, 0.0);
        polygon.addPoint(0.0, 0.0);
        return polygon;
    }
}

