/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Collection;
import java.util.Collections;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public abstract class AbstractFtile
extends AbstractTextBlock
implements Ftile {
    private final boolean shadowing;
    private final ISkinParam skinParam;

    private AbstractFtile(boolean shadowing) {
        this.shadowing = shadowing;
        this.skinParam = null;
    }

    public AbstractFtile(ISkinParam skinParam) {
        this.shadowing = skinParam.shadowing();
        this.skinParam = skinParam;
    }

    @Override
    public final ISkinParam skinParam() {
        if (this.skinParam == null) {
            throw new IllegalStateException();
        }
        return this.skinParam;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return LinkRendering.none();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return LinkRendering.none();
    }

    @Override
    public Collection<Connection> getInnerConnections() {
        return Collections.emptyList();
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final UStroke getThickness() {
        UStroke thickness = this.skinParam.getThickness(LineParam.activityBorder, null);
        if (thickness == null) {
            thickness = new UStroke(1.5);
        }
        return thickness;
    }
}

