/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.WithNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNoteOpale;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;

public class InstructionWhile
extends WithNote
implements Instruction,
InstructionCollection {
    private final InstructionList repeatList = new InstructionList();
    private final Instruction parent;
    private final LinkRendering nextLinkRenderer;
    private final HtmlColor color;
    private boolean killed = false;
    private final Display test;
    private Display yes;
    private Display out = Display.NULL;
    private boolean testCalled = false;
    private LinkRendering endInlinkRendering = LinkRendering.none();
    private LinkRendering afterEndwhile = LinkRendering.none();
    private final Swimlane swimlane;
    private final ISkinParam skinParam;

    public void overwriteYes(Display yes) {
        this.yes = yes;
    }

    public InstructionWhile(Swimlane swimlane, Instruction parent, Display test, LinkRendering nextLinkRenderer, Display yes, HtmlColor color, ISkinParam skinParam) {
        if (test == null) {
            throw new IllegalArgumentException();
        }
        if (yes == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.test = test;
        this.nextLinkRenderer = nextLinkRenderer;
        if (nextLinkRenderer == null) {
            throw new IllegalArgumentException();
        }
        this.yes = yes;
        this.swimlane = swimlane;
        this.color = color;
        this.skinParam = skinParam;
    }

    @Override
    public void add(Instruction ins) {
        this.repeatList.add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile tmp = factory.decorateOut(this.repeatList.createFtile(factory), this.endInlinkRendering);
        tmp = factory.createWhile(this.swimlane, tmp, this.test, this.yes, this.out, this.afterEndwhile, this.color);
        if (this.getPositionedNotes().size() > 0) {
            tmp = FtileWithNoteOpale.create(tmp, this.getPositionedNotes(), this.skinParam, false);
        }
        if (this.killed) {
            return new FtileKilled(tmp);
        }
        return tmp;
    }

    public Instruction getParent() {
        return this.parent;
    }

    @Override
    public final boolean kill() {
        if (this.testCalled) {
            this.killed = true;
            return true;
        }
        return this.repeatList.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.nextLinkRenderer;
    }

    public void endwhile(LinkRendering nextLinkRenderer, Display out) {
        this.endInlinkRendering = nextLinkRenderer;
        this.out = out;
        if (out == null) {
            throw new IllegalArgumentException();
        }
        this.testCalled = true;
    }

    public void afterEndwhile(LinkRendering linkRenderer) {
        this.afterEndwhile = linkRenderer;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors) {
        if (this.repeatList.isEmpty()) {
            return super.addNote(note, position, type, colors);
        }
        return this.repeatList.addNote(note, position, type, colors);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeatList.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Instruction getLast() {
        return this.repeatList.getLast();
    }
}

