/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.WithNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNoteOpale;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;

public class InstructionFork
extends WithNote
implements Instruction {
    private final List<InstructionList> forks = new ArrayList<InstructionList>();
    private final Instruction parent;
    private final LinkRendering inlinkRendering;
    private final ISkinParam skinParam;
    boolean finished = false;

    public InstructionFork(Instruction parent, LinkRendering inlinkRendering, ISkinParam skinParam) {
        this.parent = parent;
        this.inlinkRendering = inlinkRendering;
        this.skinParam = skinParam;
        this.forks.add(new InstructionList());
        if (inlinkRendering == null) {
            throw new IllegalArgumentException();
        }
    }

    private InstructionList getLastList() {
        return this.forks.get(this.forks.size() - 1);
    }

    @Override
    public void add(Instruction ins) {
        this.getLastList().add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        ArrayList<Ftile> all = new ArrayList<Ftile>();
        for (InstructionList list : this.forks) {
            all.add(list.createFtile(factory));
        }
        Ftile result = factory.createFork(this.getSwimlaneIn(), all);
        if (this.getPositionedNotes().size() > 0) {
            result = FtileWithNoteOpale.create(result, this.getPositionedNotes(), this.skinParam, false);
        }
        return result;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void forkAgain() {
        this.forks.add(new InstructionList());
    }

    @Override
    public final boolean kill() {
        return this.getLastList().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors) {
        if (this.finished) {
            return super.addNote(note, position, type, colors);
        }
        if (this.getLastList().getLast() == null) {
            return this.getLastList().addNote(note, position, type, colors);
        }
        return this.getLastList().addNote(note, position, type, colors);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.forks);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.forks.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.forks.get(0).getSwimlaneOut();
    }

    public void manageOutRendering(LinkRendering nextLinkRenderer, boolean endFork) {
        if (endFork) {
            this.finished = true;
        }
        if (nextLinkRenderer == null) {
            return;
        }
        this.getLastList().setOutRendering(nextLinkRenderer);
    }
}

