/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;

public class UrlBuilder {
    private static final String URL_PATTERN_OLD = "\\[\\[([%g][^%g]+[%g]|[^{}%s\\]\\[]*)(?:[%s]*\\{((?:[^{}]|\\{[^{}]*\\})+)\\})?(?:[%s]*([^\\]\\[]+))?\\]\\]";
    private static final String URL_PATTERN = "\\[\\[([%g][^%g]+[%g])?([\\w\\W]*)\\]\\]";
    private static final String URL_PATTERN_BAD = "\\[\\[([%g][^%g]+[%g]|[^{}%s\\]\\[]*)(?:[%s]*\\{(" + UrlBuilder.levelN(3) + ")" + "\\})?(?:[%s]*([^\\]\\[]+))?\\]\\]";
    private final String topurl;
    private ModeUrl mode;

    private static String level0() {
        return "(?:[^{}]|\\{[^{}]*\\})+";
    }

    private static String levelN(int n) {
        if (n == 0) {
            return UrlBuilder.level0();
        }
        return "(?:[^{}]|\\{" + UrlBuilder.levelN(n - 1) + "\\})+";
    }

    public UrlBuilder(String topurl, ModeUrl mode) {
        this.topurl = topurl;
        this.mode = mode;
    }

    public static String multilineTooltip(String label) {
        Pattern2 p = MyPattern.cmpile("(?i)^(\\[\\[([%g][^%g]+[%g])?([\\w\\W]*)\\]\\])?(.*)$");
        Matcher2 m = p.matcher(label);
        if (!m.matches()) {
            return label;
        }
        String gr1 = m.group(1);
        if (gr1 == null) {
            return label;
        }
        String gr2 = m.group(m.groupCount());
        gr1 = gr1.replaceAll("\\\\n", "\n");
        return gr1 + gr2;
    }

    public Url getUrl(String s) {
        Pattern2 p;
        if (this.mode == ModeUrl.STRICT) {
            p = MyPattern.cmpile("(?i)^\\[\\[([%g][^%g]+[%g])?([\\w\\W]*)\\]\\]$");
        } else if (this.mode == ModeUrl.AT_START) {
            p = MyPattern.cmpile("(?i)^\\[\\[([%g][^%g]+[%g])?([\\w\\W]*)\\]\\].*");
        } else if (this.mode == ModeUrl.AT_END) {
            p = MyPattern.cmpile("(?i).*\\[\\[([%g][^%g]+[%g])?([\\w\\W]*)\\]\\]$");
        } else if (this.mode == ModeUrl.ANYWHERE) {
            p = MyPattern.cmpile("(?i).*\\[\\[([%g][^%g]+[%g])?([\\w\\W]*)\\]\\].*");
        } else {
            throw new IllegalStateException();
        }
        Matcher2 m = p.matcher(StringUtils.trinNoTrace(s));
        if (!m.matches()) {
            return null;
        }
        String quotedPart = m.group(1);
        String full = m.group(2);
        int openBracket = full.indexOf(123);
        int closeBracket = full.lastIndexOf(125);
        if (quotedPart == null) {
            if (openBracket != -1 && closeBracket != -1) {
                return new Url(this.withTopUrl(full.substring(0, openBracket)), full.substring(openBracket + 1, closeBracket), full.substring(closeBracket + 1).trim());
            }
            int firstSpace = full.indexOf(32);
            if (firstSpace == -1) {
                return new Url(full, null, null);
            }
            return new Url(this.withTopUrl(full.substring(0, firstSpace)), null, full.substring(firstSpace + 1).trim());
        }
        if (openBracket != -1 && closeBracket != -1) {
            return new Url(this.withTopUrl(quotedPart), full.substring(openBracket + 1, closeBracket), full.substring(closeBracket + 1).trim());
        }
        return new Url(this.withTopUrl(quotedPart), null, null);
    }

    private String withTopUrl(String url) {
        if (!url.startsWith("http:") && !url.startsWith("https:") && this.topurl != null) {
            return this.topurl + url;
        }
        return url;
    }

    public static String getRegexp() {
        return URL_PATTERN;
    }

    public static String purgeUrl(String label) {
        Pattern2 p = MyPattern.cmpile("[%s]*\\[\\[([%g][^%g]+[%g])?([\\w\\W]*)\\]\\][%s]*");
        Matcher2 m = p.matcher(label);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String url = m.group(0);
        int x = label.indexOf(url);
        return label.substring(0, x) + label.substring(x + url.length());
    }

    public static enum ModeUrl {
        STRICT,
        AT_START,
        ANYWHERE,
        AT_END;

    }
}

