/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class SourceStringReader {
    private final List<BlockUml> blocks;

    public SourceStringReader(String source) {
        this(new Defines(), source, Collections.emptyList());
    }

    public SourceStringReader(String source, String charset) {
        this(new Defines(), source, "UTF-8", Collections.emptyList());
    }

    public SourceStringReader(Defines defines, String source, List<String> config) {
        this(defines, source, "UTF-8", config);
    }

    public SourceStringReader(String source, File newCurrentDir) {
        this(new Defines(), source, "UTF-8", Collections.emptyList(), newCurrentDir);
    }

    public SourceStringReader(Defines defines, String source, String charset, List<String> config) {
        this(defines, source, charset, config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceStringReader(Defines defines, String source, String charset, List<String> config, File newCurrentDir) {
        Class<SourceStringReader> clazz = SourceStringReader.class;
        synchronized (SourceStringReader.class) {
            try {
                BlockUmlBuilder builder = new BlockUmlBuilder(config, charset, defines, new StringReader(source), newCurrentDir, null);
                this.blocks = builder.getBlockUmls();
            }
            catch (IOException e) {
                Log.error("error " + e);
                throw new IllegalStateException(e);
            }
            return;
        }
    }

    public String generateImage(OutputStream os) throws IOException {
        return this.generateImage(os, 0);
    }

    public String generateImage(File f) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
        String result = this.generateImage((OutputStream)os, 0);
        ((OutputStream)os).close();
        return result;
    }

    public String generateImage(OutputStream os, FileFormatOption fileFormatOption) throws IOException {
        return this.generateImage(os, 0, fileFormatOption);
    }

    public String generateImage(OutputStream os, int numImage) throws IOException {
        return this.generateImage(os, numImage, new FileFormatOption(FileFormat.PNG));
    }

    public String generateImage(OutputStream os, int numImage, FileFormatOption fileFormatOption) throws IOException {
        if (this.blocks.size() == 0) {
            this.noStartumlFound(os, fileFormatOption);
            return null;
        }
        for (BlockUml b : this.blocks) {
            Diagram system = b.getDiagram();
            int nbInSystem = system.getNbImages();
            if (numImage < nbInSystem) {
                ImageData imageData = system.exportDiagram(os, numImage, fileFormatOption);
                if (imageData.containsCMapData()) {
                    return system.getDescription().getDescription() + "\n" + imageData.getCMapData("plantuml");
                }
                return system.getDescription().getDescription();
            }
            numImage -= nbInSystem;
        }
        Log.error("numImage is too big = " + numImage);
        return null;
    }

    private void noStartumlFound(OutputStream os, FileFormatOption fileFormatOption) throws IOException {
        GraphicStrings error = GraphicStrings.createDefault(Arrays.asList("No @startuml found"), fileFormatOption.isUseRedForError());
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, error.getBackcolor(), null, null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(error);
        imageBuilder.writeImageTOBEMOVED(fileFormatOption, os);
    }

    public DiagramDescription generateDiagramDescription(OutputStream os) throws IOException {
        return this.generateDiagramDescription(os, 0);
    }

    public DiagramDescription generateDiagramDescription(File f) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
        DiagramDescription result = this.generateDiagramDescription((OutputStream)os, 0);
        ((OutputStream)os).close();
        return result;
    }

    public DiagramDescription generateDiagramDescription(OutputStream os, FileFormatOption fileFormatOption) throws IOException {
        return this.generateDiagramDescription(os, 0, fileFormatOption);
    }

    public DiagramDescription generateDiagramDescription(OutputStream os, int numImage) throws IOException {
        return this.generateDiagramDescription(os, numImage, new FileFormatOption(FileFormat.PNG));
    }

    public DiagramDescription generateDiagramDescription(OutputStream os, int numImage, FileFormatOption fileFormatOption) throws IOException {
        if (this.blocks.size() == 0) {
            this.noStartumlFound(os, fileFormatOption);
            return null;
        }
        for (BlockUml b : this.blocks) {
            Diagram system = b.getDiagram();
            int nbInSystem = system.getNbImages();
            if (numImage < nbInSystem) {
                ImageData imageData = system.exportDiagram(os, numImage, fileFormatOption);
                if (imageData.containsCMapData()) {
                    return ((DiagramDescriptionImpl)system.getDescription()).withCMapData(imageData.getCMapData("plantuml"));
                }
                return system.getDescription();
            }
            numImage -= nbInSystem;
        }
        Log.error("numImage is too big = " + numImage);
        return null;
    }

    public final List<BlockUml> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }
}

