/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.EnumMap;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamDelegator;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;

public class SkinParamBackcolored
extends SkinParamDelegator {
    private final HtmlColor backColorElement;
    private final HtmlColor backColorGeneral;
    private final boolean forceClickage;
    private final Map<ColorParam, HtmlColor> forced = new EnumMap<ColorParam, HtmlColor>(ColorParam.class);

    public SkinParamBackcolored(ISkinParam skinParam, HtmlColor backColorElement) {
        this(skinParam, backColorElement, null, false);
    }

    public SkinParamBackcolored(ISkinParam skinParam, HtmlColor backColorElement, boolean forceClickage) {
        this(skinParam, backColorElement, null, forceClickage);
    }

    public SkinParamBackcolored(ISkinParam skinParam, HtmlColor backColorElement, HtmlColor backColorGeneral) {
        this(skinParam, backColorElement, backColorGeneral, false);
    }

    public SkinParamBackcolored(ISkinParam skinParam, HtmlColor backColorElement, HtmlColor backColorGeneral, boolean forceClickage) {
        super(skinParam);
        this.forceClickage = forceClickage;
        this.backColorElement = backColorElement;
        this.backColorGeneral = backColorGeneral;
    }

    @Override
    public HtmlColor getBackgroundColor() {
        if (this.backColorGeneral != null) {
            return this.backColorGeneral;
        }
        return super.getBackgroundColor();
    }

    @Override
    public HtmlColor getHtmlColor(ColorParam param, Stereotype stereotype, boolean clickable) {
        HtmlColor c1;
        if (param.isBackground() && this.backColorElement != null) {
            return this.backColorElement;
        }
        if (this.forceClickage && (c1 = super.getHtmlColor(param, stereotype, true)) != null) {
            return c1;
        }
        HtmlColor forcedColor = this.forced.get((Object)param);
        if (forcedColor != null) {
            return forcedColor;
        }
        return super.getHtmlColor(param, stereotype, clickable);
    }

    public void forceColor(ColorParam param, HtmlColor color) {
        this.forced.put(param, color);
    }
}

