/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.preproc.Defines;

public class Option {
    private final List<String> excludes = new ArrayList<String>();
    private final List<String> config = new ArrayList<String>();
    private final Map<String, String> defines = new LinkedHashMap<String, String>();
    private String charset;
    private boolean computeurl = false;
    private boolean decodeurl = false;
    private boolean pipe = false;
    private boolean syntax = false;
    private boolean checkOnly = false;
    private boolean failfast = false;
    private boolean failfast2 = false;
    private boolean pattern = false;
    private boolean duration = false;
    private boolean debugsvek = false;
    private int nbThreads = 0;
    private int ftpPort = -1;
    private File outputDir = null;
    private File outputFile = null;
    private final List<String> result = new ArrayList<String>();
    private FileFormat fileFormat = FileFormat.PNG;

    public Option() {
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public Option(String ... arg) throws InterruptedException, IOException {
        if (arg.length == 0) {
            OptionFlags.getInstance().setGui(true);
        }
        for (int i = 0; i < arg.length; ++i) {
            String s = arg[i];
            if (s.equalsIgnoreCase("-tsvg") || s.equalsIgnoreCase("-svg")) {
                this.setFileFormat(FileFormat.SVG);
                continue;
            }
            if (s.equalsIgnoreCase("-thtml") || s.equalsIgnoreCase("-html")) {
                this.setFileFormat(FileFormat.HTML);
                continue;
            }
            if (s.equalsIgnoreCase("-tscxml") || s.equalsIgnoreCase("-scxml")) {
                this.setFileFormat(FileFormat.SCXML);
                continue;
            }
            if (s.equalsIgnoreCase("-txmi") || s.equalsIgnoreCase("-xmi")) {
                this.setFileFormat(FileFormat.XMI_STANDARD);
                continue;
            }
            if (s.equalsIgnoreCase("-txmi:argo") || s.equalsIgnoreCase("-xmi:argo")) {
                this.setFileFormat(FileFormat.XMI_ARGO);
                continue;
            }
            if (s.equalsIgnoreCase("-txmi:star") || s.equalsIgnoreCase("-xmi:star")) {
                this.setFileFormat(FileFormat.XMI_STAR);
                continue;
            }
            if (s.equalsIgnoreCase("-teps") || s.equalsIgnoreCase("-eps")) {
                this.setFileFormat(FileFormat.EPS);
                continue;
            }
            if (s.equalsIgnoreCase("-teps:text") || s.equalsIgnoreCase("-eps:text")) {
                this.setFileFormat(FileFormat.EPS_TEXT);
                continue;
            }
            if (s.equalsIgnoreCase("-ttxt") || s.equalsIgnoreCase("-txt")) {
                this.setFileFormat(FileFormat.ATXT);
                continue;
            }
            if (s.equalsIgnoreCase("-tutxt") || s.equalsIgnoreCase("-utxt")) {
                this.setFileFormat(FileFormat.UTXT);
                continue;
            }
            if (s.equalsIgnoreCase("-braille") || s.equalsIgnoreCase("-tbraille")) {
                this.setFileFormat(FileFormat.BRAILLE_PNG);
                continue;
            }
            if (s.equalsIgnoreCase("-png") || s.equalsIgnoreCase("-tpng")) {
                this.setFileFormat(FileFormat.PNG);
                continue;
            }
            if (s.equalsIgnoreCase("-vdx") || s.equalsIgnoreCase("-tvdx")) {
                this.setFileFormat(FileFormat.VDX);
                continue;
            }
            if (s.equalsIgnoreCase("-latex") || s.equalsIgnoreCase("-tlatex")) {
                this.setFileFormat(FileFormat.LATEX);
                continue;
            }
            if (s.equalsIgnoreCase("-latex:nopreamble") || s.equalsIgnoreCase("-tlatex:nopreamble")) {
                this.setFileFormat(FileFormat.LATEX_NO_PREAMBLE);
                continue;
            }
            if (s.equalsIgnoreCase("-base64") || s.equalsIgnoreCase("-tbase64")) {
                this.setFileFormat(FileFormat.BASE64);
                continue;
            }
            if (s.equalsIgnoreCase("-pdf") || s.equalsIgnoreCase("-tpdf")) {
                this.setFileFormat(FileFormat.PDF);
                continue;
            }
            if (s.equalsIgnoreCase("-overwrite")) {
                OptionFlags.getInstance().setOverwrite(true);
                continue;
            }
            if (s.equalsIgnoreCase("-output") || s.equalsIgnoreCase("-o")) {
                if (++i == arg.length) continue;
                this.outputDir = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]));
                continue;
            }
            if (s.equalsIgnoreCase("-ofile")) {
                if (++i == arg.length) continue;
                this.outputFile = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]));
                continue;
            }
            if (s.equalsIgnoreCase("-graphvizdot") || s.equalsIgnoreCase("-graphviz_dot")) {
                if (++i == arg.length) continue;
                GraphvizUtils.setDotExecutable(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]));
                continue;
            }
            if (s.equalsIgnoreCase("-charset")) {
                if (++i == arg.length) continue;
                this.charset = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]);
                continue;
            }
            if (s.startsWith("-o") && s.length() > 3) {
                s = s.substring(2);
                this.outputDir = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s));
                continue;
            }
            if (s.equalsIgnoreCase("-recurse") || s.equalsIgnoreCase("-r")) continue;
            if (s.equalsIgnoreCase("-exclude") || s.equalsIgnoreCase("-x")) {
                if (++i == arg.length) continue;
                this.excludes.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]));
                continue;
            }
            if (s.equalsIgnoreCase("-nbthread") || s.equalsIgnoreCase("-nbthreads")) {
                if (++i == arg.length) continue;
                String nb = arg[i];
                if ("auto".equalsIgnoreCase(nb)) {
                    this.nbThreads = Option.defaultNbThreads();
                    continue;
                }
                if (!nb.matches("\\d+")) continue;
                this.nbThreads = Integer.parseInt(nb);
                continue;
            }
            if (s.equalsIgnoreCase("-failfast")) {
                this.failfast = true;
                continue;
            }
            if (s.equalsIgnoreCase("-failfast2")) {
                this.failfast2 = true;
                continue;
            }
            if (s.equalsIgnoreCase("-checkonly")) {
                this.checkOnly = true;
                continue;
            }
            if (s.equalsIgnoreCase("-config")) {
                if (++i == arg.length) continue;
                this.initConfig(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]));
                continue;
            }
            if (s.equalsIgnoreCase("-computeurl") || s.equalsIgnoreCase("-encodeurl")) {
                this.computeurl = true;
                continue;
            }
            if (s.startsWith("-x")) {
                s = s.substring(2);
                this.excludes.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s));
                continue;
            }
            if (s.equalsIgnoreCase("-verbose") || s.equalsIgnoreCase("-v")) {
                OptionFlags.getInstance().setVerbose(true);
                continue;
            }
            if (s.equalsIgnoreCase("-pipe") || s.equalsIgnoreCase("-p")) {
                this.pipe = true;
                continue;
            }
            if (s.equalsIgnoreCase("-pattern")) {
                this.pattern = true;
                continue;
            }
            if (s.equalsIgnoreCase("-syntax")) {
                this.syntax = true;
                OptionFlags.getInstance().setQuiet(true);
                continue;
            }
            if (s.equalsIgnoreCase("-duration")) {
                this.duration = true;
                continue;
            }
            if (s.equalsIgnoreCase("-debugsvek") || s.equalsIgnoreCase("-debug_svek")) {
                this.debugsvek = true;
                continue;
            }
            if (s.equalsIgnoreCase("-keepfiles") || s.equalsIgnoreCase("-keepfile")) {
                System.err.println("-keepfiles option has been removed. Please consider -debugsvek instead");
                continue;
            }
            if (s.equalsIgnoreCase("-metadata")) {
                OptionFlags.getInstance().setMetadata(true);
                continue;
            }
            if (s.equalsIgnoreCase("-logdata")) {
                if (++i == arg.length) continue;
                OptionFlags.getInstance().setLogData(new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i])));
                continue;
            }
            if (s.equalsIgnoreCase("-word")) {
                OptionFlags.getInstance().setWord(true);
                OptionFlags.getInstance().setQuiet(true);
                continue;
            }
            if (s.equalsIgnoreCase("-quiet")) {
                OptionFlags.getInstance().setQuiet(true);
                continue;
            }
            if (s.equalsIgnoreCase("-decodeurl")) {
                this.decodeurl = true;
                continue;
            }
            if (s.equalsIgnoreCase("-version")) {
                OptionPrint.printVersion();
                continue;
            }
            if (s.matches("(?i)^-li[sc][ea]n[sc]e\\s*$")) {
                OptionPrint.printLicense();
                continue;
            }
            if (s.equalsIgnoreCase("-checkversion")) {
                OptionPrint.checkVersion();
                continue;
            }
            if (s.startsWith("-D")) {
                this.manageDefine(s.substring(2));
                continue;
            }
            if (s.startsWith("-S")) {
                this.manageSkinParam(s.substring(2));
                continue;
            }
            if (s.equalsIgnoreCase("-testdot")) {
                OptionPrint.printTestDot();
                continue;
            }
            if (s.equalsIgnoreCase("-about") || s.equalsIgnoreCase("-author") || s.equalsIgnoreCase("-authors")) {
                OptionPrint.printAbout();
                continue;
            }
            if (s.equalsIgnoreCase("-help") || s.equalsIgnoreCase("-h") || s.equalsIgnoreCase("-?")) {
                OptionPrint.printHelp();
                continue;
            }
            if (s.equalsIgnoreCase("-language")) {
                OptionPrint.printLanguage();
                continue;
            }
            if (s.equalsIgnoreCase("-gui")) {
                OptionFlags.getInstance().setGui(true);
                continue;
            }
            if (s.equalsIgnoreCase("-encodesprite")) {
                OptionFlags.getInstance().setEncodesprite(true);
                continue;
            }
            if (s.equalsIgnoreCase("-nosuggestengine")) {
                OptionFlags.getInstance().setUseSuggestEngine(false);
                continue;
            }
            if (s.equalsIgnoreCase("-printfonts")) {
                OptionFlags.getInstance().setPrintFonts(true);
                continue;
            }
            if (StringUtils.goLowerCase(s).startsWith("-ftp")) {
                int x = s.indexOf(58);
                if (x == -1) {
                    this.ftpPort = 4242;
                    continue;
                }
                this.ftpPort = Integer.parseInt(s.substring(x + 1));
                continue;
            }
            if (s.startsWith("-c")) {
                s = s.substring(2);
                this.config.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s));
                continue;
            }
            this.result.add(s);
        }
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConfig(String filename) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filename));
            String s = null;
            while ((s = br.readLine()) != null) {
                this.config.add(s);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private void manageDefine(String s) {
        Pattern2 p = MyPattern.cmpile("^(\\w+)(?:=(.*))?$");
        Matcher2 m = p.matcher(s);
        if (m.find()) {
            this.define(m.group(1), m.group(2));
        }
    }

    private void manageSkinParam(String s) {
        Pattern2 p = MyPattern.cmpile("^(\\w+)(?:=(.*))?$");
        Matcher2 m = p.matcher(s);
        if (m.find()) {
            this.skinParam(m.group(1), m.group(2));
        }
    }

    private void skinParam(String var, String value) {
        if (var != null && value != null) {
            this.config.add("skinparamlocked " + var + " " + value);
        }
    }

    public final File getOutputDir() {
        return this.outputDir;
    }

    public static final String getPattern() {
        return "(?i)^.*\\.(txt|tex|java|htm|html|c|h|cpp|apt|pu)$";
    }

    public void setOutputDir(File f) {
        this.outputDir = f;
    }

    public final List<String> getExcludes() {
        return Collections.unmodifiableList(this.excludes);
    }

    public Defines getDefaultDefines() {
        Defines result = new Defines();
        for (Map.Entry<String, String> ent : this.defines.entrySet()) {
            result.define(ent.getKey(), Arrays.asList(ent.getValue()));
        }
        return result;
    }

    public void define(String name, String value) {
        this.defines.put(name, value);
    }

    public List<String> getConfig() {
        return Collections.unmodifiableList(this.config);
    }

    public final List<String> getResult() {
        return Collections.unmodifiableList(this.result);
    }

    public final String getCharset() {
        return this.charset;
    }

    public void setCharset(String s) {
        this.charset = s;
    }

    public final boolean isComputeurl() {
        return this.computeurl;
    }

    public final boolean isDecodeurl() {
        return this.decodeurl;
    }

    public final boolean isPipe() {
        return this.pipe;
    }

    public final boolean isSyntax() {
        return this.syntax;
    }

    public final boolean isPattern() {
        return this.pattern;
    }

    public FileFormatOption getFileFormatOption() {
        FileFormatOption fileFormatOption = new FileFormatOption(this.getFileFormat());
        if (this.debugsvek) {
            fileFormatOption.setDebugSvek(true);
        }
        return fileFormatOption;
    }

    public final boolean isDuration() {
        return this.duration;
    }

    public final int getNbThreads() {
        return this.nbThreads;
    }

    public final void setNbThreads(int nb) {
        this.nbThreads = nb;
    }

    public static int defaultNbThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    public final boolean isCheckOnly() {
        return this.checkOnly;
    }

    public final void setCheckOnly(boolean checkOnly) {
        this.checkOnly = checkOnly;
    }

    public final boolean isFailfastOrFailfast2() {
        return this.failfast || this.failfast2;
    }

    public final boolean isFailfast2() {
        return this.failfast2;
    }

    public final void setFailfast(boolean failfast) {
        this.failfast = failfast;
    }

    public final void setFailfast2(boolean failfast2) {
        this.failfast2 = failfast2;
    }

    public final File getOutputFile() {
        return this.outputFile;
    }

    public final void setDebugSvek(boolean debugsvek) {
        this.debugsvek = debugsvek;
    }

    boolean isDebugSvek() {
        return this.debugsvek;
    }
}

