/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.graphic.StringBounder;

public class FileFormatOption
implements Serializable {
    private final FileFormat fileFormat;
    private final AffineTransform affineTransform;
    private final boolean withMetadata;
    private final boolean useRedForError;
    private final String svgLinkTarget;
    private boolean debugsvek = false;

    public FileFormatOption(FileFormat fileFormat) {
        this(fileFormat, null, true, false, "_top", false);
    }

    public StringBounder getDefaultStringBounder() {
        return this.fileFormat.getDefaultStringBounder();
    }

    public String getSvgLinkTarget() {
        return this.svgLinkTarget;
    }

    public final boolean isWithMetadata() {
        return this.withMetadata;
    }

    public FileFormatOption(FileFormat fileFormat, boolean withMetadata) {
        this(fileFormat, null, false, false, "_top", false);
    }

    private FileFormatOption(FileFormat fileFormat, AffineTransform at, boolean withMetadata, boolean useRedForError, String svgLinkTarget, boolean debugsvek) {
        this.fileFormat = fileFormat;
        this.affineTransform = at;
        this.withMetadata = withMetadata;
        this.useRedForError = useRedForError;
        this.svgLinkTarget = svgLinkTarget;
        this.debugsvek = debugsvek;
    }

    public FileFormatOption withUseRedForError() {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, true, this.svgLinkTarget, this.debugsvek);
    }

    public FileFormatOption withSvgLinkTarget(String target) {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, this.useRedForError, target, this.debugsvek);
    }

    public String toString() {
        return this.fileFormat.toString() + " " + this.affineTransform;
    }

    public final FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public final boolean isUseRedForError() {
        return this.useRedForError;
    }

    public void setDebugSvek(boolean debugsvek) {
        this.debugsvek = debugsvek;
    }

    public boolean isDebugSvek() {
        return this.debugsvek;
    }
}

