/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.braille.BrailleCharFactory;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UFont;

public enum FileFormat {
    PNG,
    SVG,
    EPS,
    EPS_TEXT,
    ATXT,
    UTXT,
    XMI_STANDARD,
    XMI_STAR,
    XMI_ARGO,
    SCXML,
    PDF,
    MJPEG,
    ANIMATED_GIF,
    HTML,
    HTML5,
    VDX,
    LATEX,
    LATEX_NO_PREAMBLE,
    BASE64,
    BRAILLE_PNG;

    private static final BufferedImage imDummy;
    private static final Graphics2D gg;

    public String getFileSuffix() {
        if (this.name().startsWith("XMI")) {
            return ".xmi";
        }
        if (this == MJPEG) {
            return ".avi";
        }
        if (this == LATEX_NO_PREAMBLE) {
            return ".latex";
        }
        if (this == ANIMATED_GIF) {
            return ".gif";
        }
        if (this == BRAILLE_PNG) {
            return ".braille.png";
        }
        if (this == EPS_TEXT) {
            return EPS.getFileSuffix();
        }
        return "." + StringUtils.goLowerCase(this.name());
    }

    public StringBounder getDefaultStringBounder() {
        if (this == BRAILLE_PNG) {
            return new StringBounder(){

                @Override
                public Dimension2D calculateDimension(UFont font, String text) {
                    int nb = BrailleCharFactory.build(text).size();
                    double quanta = 4.0;
                    double height = 20.0;
                    double width = (double)(3 * nb) * 4.0 + 1.0;
                    return new Dimension2DDouble(width, 20.0);
                }
            };
        }
        return new StringBounder(){

            @Override
            public Dimension2D calculateDimension(UFont font, String text) {
                FontMetrics fm = gg.getFontMetrics(font.getFont());
                Rectangle2D rect = fm.getStringBounds(text, gg);
                return new Dimension2DDouble(rect.getWidth(), rect.getHeight());
            }
        };
    }

    public boolean isEps() {
        if (this == EPS) {
            return true;
        }
        return this == EPS_TEXT;
    }

    public String changeName(String fileName, int cpt) {
        if (cpt == 0) {
            return this.changeName(fileName, this.getFileSuffix());
        }
        return this.changeName(fileName, "_" + String.format("%03d", cpt) + this.getFileSuffix());
    }

    private String changeName(String fileName, String replacement) {
        String result = fileName.replaceAll("\\.\\w+$", replacement);
        if (result.equals(fileName)) {
            result = fileName + replacement;
        }
        return result;
    }

    public File computeFilename(File pngFile, int i) {
        if (i == 0) {
            return pngFile;
        }
        File dir = pngFile.getParentFile();
        return new File(dir, this.computeFilename(pngFile.getName(), i));
    }

    public String computeFilename(String name, int i) {
        if (i == 0) {
            return name;
        }
        return name.replaceAll("\\" + this.getFileSuffix() + "$", "_" + String.format("%03d", i) + this.getFileSuffix());
    }

    static {
        imDummy = new BufferedImage(800, 100, 1);
        gg = imDummy.createGraphics();
    }
}

