/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.DecorateEntityImage;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;

public class AnnotatedWorker {
    private final Annotated annotated;
    private final ISkinParam skinParam;

    public AnnotatedWorker(Annotated annotated, ISkinParam skinParam) {
        this.annotated = annotated;
        this.skinParam = skinParam;
    }

    public TextBlockBackcolored addAdd(TextBlock result) {
        result = this.addLegend(result);
        result = this.addTitle(result);
        result = this.addCaption(result);
        result = this.addHeaderAndFooter(result);
        return (TextBlockBackcolored)result;
    }

    private TextBlock addLegend(TextBlock original) {
        if (DisplayPositionned.isNull(this.annotated.getLegend())) {
            return original;
        }
        TextBlock text = EntityImageLegend.create(this.annotated.getLegend().getDisplay(), this.getSkinParam());
        return DecorateEntityImage.add(original, text, this.annotated.getLegend().getHorizontalAlignment(), this.annotated.getLegend().getVerticalAlignment());
    }

    private ISkinParam getSkinParam() {
        return this.skinParam;
    }

    private TextBlock addCaption(TextBlock original) {
        if (DisplayPositionned.isNull(this.annotated.getCaption())) {
            return original;
        }
        TextBlock text = this.getCaption();
        return DecorateEntityImage.addBottom(original, text, HorizontalAlignment.CENTER);
    }

    public TextBlock getCaption() {
        if (DisplayPositionned.isNull(this.annotated.getCaption())) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return this.annotated.getCaption().getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.CAPTION, null), HorizontalAlignment.CENTER, this.getSkinParam());
    }

    private TextBlock addTitle(TextBlock original) {
        if (DisplayPositionned.isNull(this.annotated.getTitle())) {
            return original;
        }
        TextBlock text = this.annotated.getTitle().getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.TITLE, null), HorizontalAlignment.CENTER, this.getSkinParam());
        return DecorateEntityImage.addTop(original, text, HorizontalAlignment.CENTER);
    }

    private TextBlock addHeaderAndFooter(TextBlock original) {
        if (DisplayPositionned.isNull(this.annotated.getFooter()) && DisplayPositionned.isNull(this.annotated.getHeader())) {
            return original;
        }
        TextBlock textFooter = DisplayPositionned.isNull(this.annotated.getFooter()) ? null : this.annotated.getFooter().getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.FOOTER, null), this.annotated.getFooter().getHorizontalAlignment(), this.getSkinParam());
        TextBlock textHeader = DisplayPositionned.isNull(this.annotated.getHeader()) ? null : this.annotated.getHeader().getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.HEADER, null), this.annotated.getHeader().getHorizontalAlignment(), this.getSkinParam());
        return new DecorateEntityImage(original, textHeader, this.annotated.getHeader().getHorizontalAlignment(), textFooter, this.annotated.getFooter().getHorizontalAlignment());
    }
}

