/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Locale;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.atomique.ksar.SplashScreen;
import net.atomique.ksar.VersionNumber;
import net.atomique.ksar.Wizard;
import net.atomique.ksar.XMLConfig;
import net.atomique.ksar.kSar;
import net.atomique.ksar.kSarConfig;
import net.atomique.ksar.kSarDesktop;

public class Main {
    private static kSarDesktop mydesktop = null;
    private static boolean nogui = false;
    private static ArrayList<String> inputfile = new ArrayList();
    private static String graphs = null;
    private static boolean usepref = false;
    private static boolean usetrigger = false;
    private static boolean useemptydisk = true;
    private static boolean usecpustacked = false;
    private static boolean linuxhack = false;
    private static boolean onlygraphname = false;
    private static boolean usecpufixedaxis = false;
    private static boolean addhtml = false;
    private static boolean usememorystacked = false;
    private static boolean useintrliststacked = false;
    private static boolean use_wizard = false;
    private static String outputpdffile = null;
    private static String outputpngbase = null;
    private static String outputjpgbase = null;
    private static String outputcsvfile = null;
    private static Integer width = new Integer(800);
    private static Integer height = new Integer(600);
    private static String startdate = null;
    private static String enddate = null;
    private static Integer pagesize = new Integer(-1);
    private static boolean dotile = false;
    private static boolean replaceshortcut = false;
    private static boolean open_at_startup = false;
    private static File tmpfile = null;
    private static String xmlfile = null;

    public static void main(String[] args) {
        int i = 0;
        if (args.length > 0) {
            while (i < args.length && args[i].startsWith("-")) {
                String arg;
                if ("-help".equals(arg = args[i++])) {
                    Main.usage();
                    continue;
                }
                if ("-input".equals(arg)) {
                    if (i < args.length) {
                        inputfile.add(args[i++]);
                        continue;
                    }
                    Main.exit_error("-input requires an option");
                    continue;
                }
                if ("-graph".equals(arg)) {
                    if (i < args.length) {
                        graphs = new String(" " + args[i++] + " ");
                        continue;
                    }
                    Main.exit_error("-graph requires a graph list");
                    continue;
                }
                if ("-showCPUstacked".equals(arg)) {
                    usecpustacked = true;
                    continue;
                }
                if ("-showMEMstacked".equals(arg)) {
                    usememorystacked = true;
                    continue;
                }
                if ("-cpuFixedAxis".equals(arg)) {
                    usecpufixedaxis = true;
                    continue;
                }
                if ("-showIntrListstacked".equals(arg)) {
                    useintrliststacked = true;
                    continue;
                }
                if ("-showTrigger".equals(arg)) {
                    usetrigger = true;
                    continue;
                }
                if ("-noEmptyDisk".equals(arg)) {
                    useemptydisk = false;
                    continue;
                }
                if ("-tile".equals(arg)) {
                    dotile = true;
                    continue;
                }
                if ("-userPrefs".equals(arg)) {
                    usepref = true;
                    continue;
                }
                if ("-showOnlygraphName".equals(arg)) {
                    onlygraphname = true;
                    continue;
                }
                if ("-addHTML".equals(arg)) {
                    addhtml = true;
                    continue;
                }
                if ("-output".equals(arg) || "-outputPDF".equals(arg)) {
                    if (i < args.length) {
                        if (new File(outputpdffile = args[i++]).exists()) {
                            Main.exit_error("The output filename already exist.....exiting");
                        }
                        if (!"-output".equals(arg)) continue;
                        System.err.println("please use -outputPDF from now");
                        continue;
                    }
                    Main.exit_error("-output|-outputPDF requires a filename");
                    continue;
                }
                if ("-outputJPG".equals(arg)) {
                    if (i < args.length) {
                        outputjpgbase = args[i++];
                        continue;
                    }
                    Main.exit_error("-outputJPG requires a base filename");
                    continue;
                }
                if ("-outputPNG".equals(arg)) {
                    if (i < args.length) {
                        outputpngbase = args[i++];
                        continue;
                    }
                    Main.exit_error("-outputPNG requires a base filename");
                    continue;
                }
                if ("-outputCSV".equals(arg)) {
                    if (i < args.length) {
                        outputcsvfile = args[i++];
                        continue;
                    }
                    Main.exit_error("-outputCSV requires a base filename");
                    continue;
                }
                if ("-width".equals(arg)) {
                    if (i < args.length) {
                        try {
                            width = Integer.valueOf(args[i++]);
                        }
                        catch (NumberFormatException e) {
                            Main.exit_error("-width and -height must be followed by an integer value");
                        }
                        continue;
                    }
                    Main.exit_error("-height and -width requires a integer value");
                    continue;
                }
                if ("-height".equals(arg)) {
                    if (i < args.length) {
                        try {
                            height = Integer.valueOf(args[i++]);
                        }
                        catch (NumberFormatException e) {
                            Main.exit_error("-width and -height must be followed by an integer value");
                        }
                        continue;
                    }
                    Main.exit_error("-height and -width requires a integer value");
                    continue;
                }
                if ("-solarisPagesize".equals(arg)) {
                    if (i < args.length) {
                        try {
                            pagesize = Integer.valueOf(args[i++]);
                        }
                        catch (NumberFormatException e) {
                            Main.exit_error("-solarisPagesize must be followed by an integer value");
                        }
                        continue;
                    }
                    Main.exit_error("-solarisPagesize requires a integer value");
                    continue;
                }
                if ("-startdate".equals(arg)) {
                    if (i < args.length) {
                        startdate = args[i++];
                        continue;
                    }
                    Main.exit_error("startdate requires an argument");
                    continue;
                }
                if ("-enddate".equals(arg)) {
                    if (i < args.length) {
                        enddate = args[i++];
                        continue;
                    }
                    Main.exit_error("-enddate requires an argument");
                    continue;
                }
                if ("-flushPrefs".equals(arg)) {
                    if (i < args.length) {
                        kSarConfig.flush_prefs(args[i++]);
                        kSarConfig.writeDefault();
                        System.exit(0);
                    } else {
                        Main.exit_error("-flushPrefs requires an argument");
                    }
                }
                if ("-ClearAllPrefs".equals(arg)) {
                    kSarConfig.clear_all();
                    continue;
                }
                if ("-wizard".equals(arg)) {
                    use_wizard = true;
                    continue;
                }
                if ("-startup".equals(arg)) {
                    open_at_startup = true;
                    continue;
                }
                if ("-version".equals(arg)) {
                    Main.show_version();
                }
                if ("-replaceShortcut".equals(arg)) {
                    if (i < args.length) {
                        if (!(tmpfile = new File(xmlfile = args[i++])).canRead() || !tmpfile.isFile()) {
                            xmlfile = null;
                            Main.exit_error("Unable to open xml file (" + xmlfile + ")");
                        }
                        replaceshortcut = true;
                        continue;
                    }
                    Main.exit_error("-replaceShortcut requires a filename");
                    continue;
                }
                if ("-addShortcut".equals(arg)) {
                    if (i < args.length) {
                        if ((tmpfile = new File(xmlfile = args[i++])).canRead() && tmpfile.isFile()) continue;
                        xmlfile = null;
                        Main.exit_error("Unable to open xml file (" + xmlfile + ")");
                        continue;
                    }
                    Main.exit_error("-addShortcut requires a filename");
                    continue;
                }
                if ("-showLocale".equals(arg)) {
                    Locale[] locales = Locale.getAvailableLocales();
                    for (i = 0; i < locales.length; ++i) {
                        System.out.println("" + locales[i].getCountry());
                    }
                    Main.exit_error("debug");
                    continue;
                }
                Main.exit_error("unknown argument: " + arg);
            }
        }
        if (outputpdffile != null || outputjpgbase != null || outputpngbase != null || outputcsvfile != null) {
            nogui = true;
            if (inputfile.size() > 1 || inputfile == null || inputfile.size() < 0) {
                Main.exit_error("-input must be specify once for using -output|outputPDF|outputPNG|outputJPG");
            }
            if (outputcsvfile != null && outputpdffile != null && outputjpgbase != null && outputpngbase != null && onlygraphname) {
                Main.exit_error("You cannot specify -outputPDF -outpufPNG -output -outputJPG -outputCSV -showOnlygraphName together");
            }
        }
        if (xmlfile != null) {
            XMLConfig tmp = new XMLConfig(xmlfile, replaceshortcut);
            tmp = null;
        }
        if (!nogui) {
            Main.start_gui();
        } else {
            System.setProperty("java.awt.headless", "true");
            ListIterator<String> listItr = inputfile.listIterator();
            while (listItr.hasNext()) {
                kSar mysar = new kSar(listItr.next().toString());
                if (usetrigger) {
                    mysar.showtrigger = true;
                }
                if (!useemptydisk) {
                    mysar.showemptydisk = false;
                }
                if (usecpustacked) {
                    mysar.showstackedcpu = true;
                }
                if (usecpufixedaxis) {
                    mysar.show100axiscpu = true;
                }
                if (useintrliststacked) {
                    mysar.showstackedintrlist = true;
                }
                try {
                    mysar.launched_command.join();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (outputpdffile != null) {
                    mysar.outputPdf(outputpdffile, usepref, graphs);
                }
                if (outputjpgbase != null) {
                    mysar.outputJpg(outputjpgbase, usepref, addhtml, graphs, height, width);
                }
                if (outputpngbase != null) {
                    mysar.outputPng(outputpngbase, usepref, addhtml, graphs, height, width);
                }
                if (outputcsvfile == null) continue;
                mysar.outputCsv(outputcsvfile);
            }
        }
    }

    public static void show_version() {
        System.out.println("kSar version: " + VersionNumber.getVersionNumber());
        System.exit(0);
    }

    public static void usage() {
        System.out.println("kSar version: " + VersionNumber.getVersionNumber());
        System.err.println("Usage: ");
        System.err.println("-version: show kSar version number");
        System.err.println("-help: show this help");
        System.err.println("-input <arg>: argument must be either ssh://user@host/command or cmd://command or file://path/to/file or just /path/to/file");
        System.err.println("-graph <graph list>: space separated list of graph you want to be outputed");
        System.err.println("-showCPUstacked: will make the CPU used graph as stacked");
        System.err.println("-showMEMstacked: will make the Memory graph as stacked (linux only)");
        System.err.println("-cpuFixedAxis:  will graph CPU used with fixed axis from 0% to 100%");
        System.err.println("-showIntrListstacked : will make the Interrupt List graph as stacked");
        System.err.println("-showTrigger:  will show trigger on graph (disabled by default)");
        System.err.println("-noEmptyDisk: will not export disk with no data");
        System.err.println("-tile: will tile window");
        System.err.println("-userPrefs: will use the userPrefs for outputing graphs (last export of this host)");
        System.err.println("-showOnlygraphName: will only print graph name available for that data (to be use for -graph)");
        System.err.println("-addHTML: will create an html page with PNG/JPG image");
        System.err.println("-outputPDF <pdf file> : output the pdf report to the pdf file");
        System.err.println("-outputPNG <base filename> : output the graphs to PNG file using argument as base filename");
        System.err.println("-outputJPG <base filename> : output the graphs to JPG file using argument as base filename");
        System.err.println("-outputCSV <CSV file> : output the CSV file");
        System.err.println("-width <size> : make JPG/PNG with specified width size (default: 800)");
        System.err.println("-height <size> : make JPG/PNG with specified height size (default: 600)");
        System.err.println("-startdate <date> : will graph the range begining at that time");
        System.err.println("-enddate <date> : will graph the range until that date");
        System.err.println("-solarisPagesize <pagesize in B>: will set solaris pagesize");
        System.err.println("-wizard: open with unified login popup");
        System.err.println("-replaceShortcut <xml file>: replace all shortcut with those in the xml file");
        System.err.println("-addShortcut <xml file>: add shortcut from the xml file");
        System.err.println("-startup: open window marked for opening at startup");
        System.exit(0);
    }

    public static void exit_error(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public static void doSplashScreen() {
        SplashScreen mysplash = new SplashScreen("/logo_ksar.jpg", null, 3000);
        while (mysplash.isVisible()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public static void make_window(String command) {
        kSar new_window = mydesktop.make_new_window(command);
        if (usetrigger) {
            new_window.showtrigger = true;
        }
        if (!useemptydisk) {
            new_window.showemptydisk = false;
        }
        if (usecpufixedaxis) {
            new_window.show100axiscpu = true;
        }
        if (usecpustacked) {
            new_window.showstackedcpu = true;
        }
        if (usememorystacked) {
            new_window.showstackedmem = true;
        }
        if (useintrliststacked) {
            new_window.showstackedintrlist = true;
        }
        if (pagesize != -1) {
            new_window.solarispagesize = pagesize;
        }
    }

    private static void set_lookandfeel() {
        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
            if (!kSarConfig.landf.equals(laf.getName())) continue;
            try {
                UIManager.setLookAndFeel(laf.getClassName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static void show_lookandfeel() {
        System.out.println("Default L&F:");
        System.out.println("  " + UIManager.getLookAndFeel().getName());
        UIManager.LookAndFeelInfo[] inst = UIManager.getInstalledLookAndFeels();
        System.out.println("Installed L&Fs: ");
        for (int i = 0; i < inst.length; ++i) {
            System.out.println("  " + inst[i].getName() + " = " + inst[i].getClass());
        }
        LookAndFeel[] aux = UIManager.getAuxiliaryLookAndFeels();
        System.out.println("Auxiliary L&Fs: ");
        if (aux != null) {
            for (int i = 0; i < aux.length; ++i) {
                System.out.println("  " + aux[i].getName() + " = " + aux[i].getClass());
            }
        } else {
            System.out.println("  <NONE>");
        }
        System.out.println("Cross-Platform:");
        System.out.println("  " + UIManager.getCrossPlatformLookAndFeelClassName());
        System.out.println("System:");
        System.out.println("  " + UIManager.getSystemLookAndFeelClassName());
    }

    public static void start_gui() {
        System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        Main.set_lookandfeel();
        Main.doSplashScreen();
        mydesktop = new kSarDesktop();
        mydesktop.setVisible(true);
        if (inputfile.size() > 0 && !use_wizard) {
            ListIterator<String> listItr = inputfile.listIterator();
            while (listItr.hasNext()) {
                Main.make_window(listItr.next().toString());
            }
            mydesktop.do_tile();
        } else {
            Wizard wizardwind = null;
            if (use_wizard) {
                wizardwind = new Wizard((Frame)mydesktop, true);
                wizardwind.setVisible(true);
                wizardwind.setLocationRelativeTo(mydesktop);
            }
            if (wizardwind != null) {
                if (wizardwind.openinigraph.isSelected()) {
                    for (String key : kSarConfig.shortcut_window_list.keySet()) {
                        String value = kSarConfig.shortcut_window_list.get(key);
                        if (kSarConfig.startup_windows_list == null || !kSarConfig.startup_windows_list.contains(value)) continue;
                        Main.make_window(key);
                    }
                } else {
                    Main.make_window("Empty");
                }
            } else if (open_at_startup) {
                for (String key : kSarConfig.shortcut_window_list.keySet()) {
                    String value = kSarConfig.shortcut_window_list.get(key);
                    if (kSarConfig.startup_windows_list == null || !kSarConfig.startup_windows_list.contains(value)) continue;
                    Main.make_window(key);
                }
            } else {
                Main.make_window("Empty");
            }
        }
        if (kSarConfig.tile_at_startup) {
            mydesktop.do_tile();
        }
    }
}

