/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.Hpux;

import java.awt.Paint;
import java.awt.Stroke;
import javax.swing.tree.DefaultMutableTreeNode;
import net.atomique.ksar.AllGraph;
import net.atomique.ksar.GraphDescription;
import net.atomique.ksar.Trigger;
import net.atomique.ksar.kSar;
import net.atomique.ksar.kSarConfig;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class bufferSar
extends AllGraph {
    private Trigger bufferrcachetrigger;
    private TimeSeries t_bread;
    private TimeSeries t_lread;
    private TimeSeries t_rcache;
    private TimeSeries t_bwrit;
    private TimeSeries t_lwrit;
    private TimeSeries t_wcache;
    private TimeSeries t_pread;
    private TimeSeries t_pwrit;

    public bufferSar(kSar hissar) {
        super(hissar);
        this.Title = new String("Buffers");
        this.t_bread = new TimeSeries((Comparable)((Object)"bread/s"), Second.class);
        this.t_lread = new TimeSeries((Comparable)((Object)"lread/s"), Second.class);
        this.t_rcache = new TimeSeries((Comparable)((Object)"%rcache"), Second.class);
        this.t_bwrit = new TimeSeries((Comparable)((Object)"bwrit/s"), Second.class);
        this.t_lwrit = new TimeSeries((Comparable)((Object)"lwrit/s"), Second.class);
        this.t_wcache = new TimeSeries((Comparable)((Object)"%wcache"), Second.class);
        this.t_pread = new TimeSeries((Comparable)((Object)"pread/s"), Second.class);
        this.t_pwrit = new TimeSeries((Comparable)((Object)"pwrit/s"), Second.class);
        this.bufferrcachetrigger = new Trigger(this.mysar, this, "read cache", this.t_rcache, "down");
        this.bufferrcachetrigger.setTriggerValue(kSarConfig.hpuxbufferrcachetrigger);
    }

    public void doclosetrigger() {
        this.bufferrcachetrigger.doclose();
    }

    public void add(Second now, Float val1Init, Float val2Init, Float val3Init, Float val4Init, Float val5Init, Float val6Init, Float val7Init, Float val8Init) {
        this.t_bread.add((RegularTimePeriod)now, (Number)val1Init);
        this.t_lread.add((RegularTimePeriod)now, (Number)val2Init);
        this.t_rcache.add((RegularTimePeriod)now, (Number)val3Init);
        this.t_bwrit.add((RegularTimePeriod)now, (Number)val4Init);
        this.t_lwrit.add((RegularTimePeriod)now, (Number)val5Init);
        this.t_wcache.add((RegularTimePeriod)now, (Number)val6Init);
        this.t_pread.add((RegularTimePeriod)now, (Number)val7Init);
        this.t_pwrit.add((RegularTimePeriod)now, (Number)val8Init);
        this.bufferrcachetrigger.doMarker(now, val3Init);
    }

    public XYDataset createread() {
        TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
        timeseriescollection.addSeries(this.t_bread);
        timeseriescollection.addSeries(this.t_lread);
        timeseriescollection.addSeries(this.t_pread);
        return timeseriescollection;
    }

    public XYDataset createwrit() {
        TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
        timeseriescollection.addSeries(this.t_bwrit);
        timeseriescollection.addSeries(this.t_lwrit);
        timeseriescollection.addSeries(this.t_pwrit);
        return timeseriescollection;
    }

    public XYDataset creatercache() {
        TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
        timeseriescollection.addSeries(this.t_rcache);
        return timeseriescollection;
    }

    public XYDataset createwcache() {
        TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
        timeseriescollection.addSeries(this.t_wcache);
        return timeseriescollection;
    }

    public void addtotree(DefaultMutableTreeNode myroot) {
        this.mynode = new DefaultMutableTreeNode(new GraphDescription(this, "HPUXBUFFER", this.Title, null));
        this.mysar.add2tree(myroot, this.mynode);
    }

    public JFreeChart makegraph(Second g_start, Second g_end) {
        XYDataset readset = this.createread();
        StandardXYItemRenderer minichart1 = new StandardXYItemRenderer();
        minichart1.setSeriesPaint(0, (Paint)kSarConfig.color1);
        minichart1.setBaseStroke((Stroke)kSarConfig.DEFAULT_STROKE);
        XYPlot subplot1 = new XYPlot(readset, null, (ValueAxis)new NumberAxis("Read"), (XYItemRenderer)minichart1);
        XYDataset writset = this.createwrit();
        StandardXYItemRenderer minichart2 = new StandardXYItemRenderer();
        minichart2.setSeriesPaint(0, (Paint)kSarConfig.color2);
        minichart1.setSeriesPaint(1, (Paint)kSarConfig.color3);
        minichart2.setBaseStroke((Stroke)kSarConfig.DEFAULT_STROKE);
        XYPlot subplot2 = new XYPlot(writset, null, (ValueAxis)new NumberAxis("Write"), (XYItemRenderer)minichart2);
        XYDataset wcacheset = this.createwcache();
        StandardXYItemRenderer minichart3 = new StandardXYItemRenderer();
        minichart3.setSeriesPaint(0, (Paint)kSarConfig.color4);
        minichart3.setBaseStroke((Stroke)kSarConfig.DEFAULT_STROKE);
        XYPlot subplot3 = new XYPlot(wcacheset, null, (ValueAxis)new NumberAxis("%wcache"), (XYItemRenderer)minichart3);
        XYDataset rcacheset = this.creatercache();
        StandardXYItemRenderer minichart4 = new StandardXYItemRenderer();
        minichart4.setSeriesPaint(0, (Paint)kSarConfig.color5);
        minichart4.setBaseStroke((Stroke)kSarConfig.DEFAULT_STROKE);
        XYPlot subplot4 = new XYPlot(rcacheset, null, (ValueAxis)new NumberAxis("%rcache"), (XYItemRenderer)minichart4);
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot((ValueAxis)new DateAxis(""));
        plot.add(subplot1, 1);
        plot.add(subplot2, 1);
        plot.add(subplot3, 1);
        plot.add(subplot4, 1);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart mychart = new JFreeChart(this.getGraphTitle(), kSarConfig.DEFAULT_FONT, (Plot)plot, true);
        if (this.setbackgroundimage(mychart) == 1) {
            subplot1.setBackgroundPaint(null);
            subplot2.setBackgroundPaint(null);
            subplot3.setBackgroundPaint(null);
            subplot4.setBackgroundPaint(null);
        }
        if (g_start != null) {
            DateAxis dateaxis1 = (DateAxis)mychart.getXYPlot().getDomainAxis();
            dateaxis1.setRange(g_start.getStart(), g_end.getEnd());
        }
        this.bufferrcachetrigger.setTriggerValue(kSarConfig.hpuxbufferrcachetrigger);
        this.bufferrcachetrigger.tagMarker(subplot4);
        return mychart;
    }
}

