/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.AIX;

import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import javax.swing.tree.DefaultMutableTreeNode;
import net.atomique.ksar.AllGraph;
import net.atomique.ksar.GraphDescription;
import net.atomique.ksar.kSar;
import net.atomique.ksar.kSarConfig;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class kernelSar
extends AllGraph {
    final TimeSeries ksched;
    final TimeSeries kproc;
    final TimeSeries kexit;

    public kernelSar(kSar hissar) {
        super(hissar);
        this.Title = new String("Kernel Process");
        this.ksched = new TimeSeries((Comparable)((Object)"ksched/s"), Second.class);
        this.mysar.dispo.put("ksched/s", this.ksched);
        this.kproc = new TimeSeries((Comparable)((Object)"kproc-ov"), Second.class);
        this.mysar.dispo.put("kproc-ov", this.kproc);
        this.kexit = new TimeSeries((Comparable)((Object)"kexit/s"), Second.class);
        this.mysar.dispo.put("kexit/s", this.kexit);
    }

    public void add(Second now, Float val1Int, Float val2Int, Float val3Int) {
        this.ksched.add((RegularTimePeriod)now, (Number)val1Int);
        this.kproc.add((RegularTimePeriod)now, (Number)val2Int);
        this.kexit.add((RegularTimePeriod)now, (Number)val3Int);
    }

    public XYDataset create() {
        TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
        timeseriescollection.addSeries(this.ksched);
        timeseriescollection.addSeries(this.kexit);
        return timeseriescollection;
    }

    public XYDataset create2() {
        TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
        timeseriescollection.addSeries(this.kproc);
        return timeseriescollection;
    }

    public void addtotree(DefaultMutableTreeNode myroot) {
        this.mynode = new DefaultMutableTreeNode(new GraphDescription(this, "AIXKPROC", this.Title, null));
        this.mysar.add2tree(myroot, this.mynode);
    }

    public JFreeChart makegraph(Second g_start, Second g_end) {
        XYDataset xydataset1 = this.create();
        StandardXYItemRenderer minichart1 = new StandardXYItemRenderer();
        minichart1.setBaseStroke((Stroke)new BasicStroke(1.0f));
        minichart1.setSeriesPaint(0, (Paint)kSarConfig.color1);
        minichart1.setSeriesPaint(1, (Paint)kSarConfig.color2);
        minichart1.setSeriesPaint(2, (Paint)kSarConfig.color3);
        XYPlot subplot1 = new XYPlot(xydataset1, null, (ValueAxis)new NumberAxis("ksched/kexit /s"), (XYItemRenderer)minichart1);
        XYDataset idleset = this.create2();
        StandardXYItemRenderer minichart2 = new StandardXYItemRenderer();
        minichart2.setSeriesPaint(0, (Paint)kSarConfig.color4);
        minichart2.setBaseStroke((Stroke)new BasicStroke(1.0f));
        XYPlot subplot2 = new XYPlot(idleset, null, (ValueAxis)new NumberAxis("kproc-ov"), (XYItemRenderer)minichart2);
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot((ValueAxis)new DateAxis(""));
        plot.add(subplot1, 3);
        plot.add(subplot2, 1);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart mychart = new JFreeChart(this.getGraphTitle(), kSarConfig.DEFAULT_FONT, (Plot)plot, true);
        if (this.setbackgroundimage(mychart) == 1) {
            subplot1.setBackgroundPaint(null);
            subplot2.setBackgroundPaint(null);
        }
        if (g_start != null) {
            DateAxis dateaxis1 = (DateAxis)mychart.getXYPlot().getDomainAxis();
            dateaxis1.setRange(g_start.getStart(), g_end.getEnd());
        }
        return mychart;
    }
}

