/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.HistoryReference;

@Deprecated
public class HistoryReferenceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(HistoryReferenceTableModel.class);
    public static final int COLUMN_ = 0;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("view.href.table.header.hrefid"), Constant.messages.getString("view.href.table.header.hreftype"), Constant.messages.getString("view.href.table.header.method"), Constant.messages.getString("view.href.table.header.url"), Constant.messages.getString("view.href.table.header.code"), Constant.messages.getString("view.href.table.header.reason"), Constant.messages.getString("view.href.table.header.rtt"), Constant.messages.getString("view.href.table.header.size.message"), Constant.messages.getString("view.href.table.header.sessionid"), Constant.messages.getString("view.href.table.header.highestalert"), Constant.messages.getString("view.href.table.header.tags", "", "", "")};
    private List<HistoryReference> hrefList;
    private COLUMN[] columns = null;

    public HistoryReferenceTableModel(COLUMN[] cOLUMNArray) {
        this.columns = cOLUMNArray;
        this.hrefList = new ArrayList<HistoryReference>();
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[this.columns[n].ordinal()];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public COLUMN getColumn(int n) {
        return this.columns[n];
    }

    @Override
    public int getRowCount() {
        return this.hrefList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        HistoryReference historyReference = this.hrefList.get(n);
        try {
            switch (this.columns[n2]) {
                case HREF_ID: {
                    return historyReference.getHistoryId();
                }
                case TYPE_FLAG: {
                    return this.getHrefTypeIcon(historyReference);
                }
                case METHOD: {
                    return historyReference.getMethod();
                }
                case URL: {
                    return historyReference.getURI().toString();
                }
                case CODE: {
                    return historyReference.getStatusCode();
                }
                case REASON: {
                    return historyReference.getReason();
                }
                case RTT: {
                    return historyReference.getRtt();
                }
                case SIZE: {
                    return historyReference.getResponseBodyLength();
                }
                case SESSION_ID: {
                    return historyReference.getSessionId();
                }
                case ALERT_FLAG: {
                    return this.getHrefAlertIcon(historyReference);
                }
                case TAGS: {
                    return this.listToCsv(historyReference.getTags());
                }
            }
            return null;
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public HistoryReference getHistoryReference(int n) {
        return this.hrefList.get(n);
    }

    private String listToCsv(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private ImageIcon getHrefAlertIcon(HistoryReference historyReference) {
        switch (historyReference.getHighestAlert()) {
            case 0: {
                return new ImageIcon(Constant.INFO_FLAG_IMAGE_URL);
            }
            case 1: {
                return new ImageIcon(Constant.LOW_FLAG_IMAGE_URL);
            }
            case 2: {
                return new ImageIcon(Constant.MED_FLAG_IMAGE_URL);
            }
            case 3: {
                return new ImageIcon(Constant.HIGH_FLAG_IMAGE_URL);
            }
        }
        return null;
    }

    private ImageIcon getHrefTypeIcon(HistoryReference historyReference) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllElements() {
        List<HistoryReference> list = this.hrefList;
        synchronized (list) {
            this.hrefList.clear();
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(HistoryReference historyReference) {
        List<HistoryReference> list = this.hrefList;
        synchronized (list) {
            this.hrefList.add(historyReference);
            this.fireTableRowsInserted(this.hrefList.size() - 1, this.hrefList.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(HistoryReference historyReference) {
        List<HistoryReference> list = this.hrefList;
        synchronized (list) {
            int n = this.hrefList.indexOf(historyReference);
            if (n >= 0) {
                this.hrefList.remove(n);
                this.fireTableRowsDeleted(n, n);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (this.columns[n]) {
            case HREF_ID: {
                return Integer.class;
            }
            case TYPE_FLAG: {
                return ImageIcon.class;
            }
            case METHOD: {
                return String.class;
            }
            case URL: {
                return String.class;
            }
            case CODE: {
                return Integer.class;
            }
            case REASON: {
                return String.class;
            }
            case RTT: {
                return Integer.class;
            }
            case SIZE: {
                return Integer.class;
            }
            case SESSION_ID: {
                return Long.class;
            }
            case ALERT_FLAG: {
                return ImageIcon.class;
            }
            case TAGS: {
                return String.class;
            }
        }
        return null;
    }

    public static enum COLUMN {
        HREF_ID,
        TYPE_FLAG,
        METHOD,
        URL,
        CODE,
        REASON,
        RTT,
        SIZE,
        SESSION_ID,
        ALERT_FLAG,
        TAGS,
        CUSTOM_1,
        CUSTOM_2,
        CUSTOM_3;

    }
}

