/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.zaproxy.zap.spider.Spider;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderTask
implements Runnable {
    private Spider parent;
    private HistoryReference reference;
    private int depth;
    private ExtensionHistory extHistory = null;
    private static final Logger log = Logger.getLogger(SpiderTask.class);

    public SpiderTask(Spider spider, URI uRI, int n, String string) {
        this(spider, null, uRI, n, string, null);
    }

    public SpiderTask(Spider spider, URI uRI, URI uRI2, int n, String string) {
        this(spider, uRI, uRI2, n, string, null);
    }

    public SpiderTask(Spider spider, URI uRI, int n, String string, String string2) {
        this(spider, null, uRI, n, string, string2);
    }

    public SpiderTask(Spider spider, URI uRI, URI uRI2, int n, String string, String string2) {
        this.parent = spider;
        this.depth = n;
        if (log.isDebugEnabled()) {
            log.debug((Object)("New task submitted for uri: " + uRI2));
        }
        try {
            HttpRequestHeader httpRequestHeader = new HttpRequestHeader(string, uRI2, "HTTP/1.1", spider.getConnectionParam());
            if (uRI != null && spider.getSpiderParam().isSendRefererHeader()) {
                httpRequestHeader.setHeader("Referer", uRI.toString());
            }
            HttpMessage httpMessage = new HttpMessage(httpRequestHeader);
            if (string2 != null) {
                httpMessage.getRequestHeader().setContentLength(string2.length());
                httpMessage.setRequestBody(string2);
            }
            this.reference = new HistoryReference(spider.getModel().getSession(), 9, httpMessage);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            log.error((Object)("Error while building HttpMessage for uri: " + uRI2), (Throwable)httpMalformedHeaderException);
        }
        catch (DatabaseException databaseException) {
            log.error((Object)("Error while persisting HttpMessage for uri: " + uRI2), (Throwable)databaseException);
        }
    }

    @Override
    public void run() {
        if (this.reference == null) {
            log.warn((Object)("Null URI. Skipping crawling task: " + this));
            this.parent.postTaskExecution();
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Spider Task Started. Processing uri at depth " + this.depth + " using already constructed message:  " + this.reference.getURI()));
        }
        if (this.parent.isStopped()) {
            log.debug((Object)"Spider process is stopped. Skipping crawling task...");
            this.deleteHistoryReference();
            this.parent.postTaskExecution();
            return;
        }
        this.parent.preTaskExecution();
        HttpMessage httpMessage = null;
        try {
            httpMessage = this.fetchResource();
        }
        catch (ConnectException connectException) {
            this.parent.postTaskExecution();
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.parent.postTaskExecution();
            return;
        }
        catch (SocketException socketException) {
            this.parent.postTaskExecution();
            return;
        }
        catch (UnknownHostException unknownHostException) {
            this.parent.postTaskExecution();
            return;
        }
        catch (Exception exception) {
            log.error((Object)("An error occured while fetching the resource: " + exception.getMessage()), (Throwable)exception);
            this.parent.postTaskExecution();
            return;
        }
        if (this.parent.isStopped()) {
            log.debug((Object)"Spider process is stopped. Skipping crawling task...");
            this.parent.postTaskExecution();
            return;
        }
        this.parent.checkPauseAndWait();
        boolean bl = false;
        for (ParseFilter parseFilter : this.parent.getController().getParseFilters()) {
            if (!parseFilter.isFiltered(httpMessage)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource fetched, but will not be parsed due to a ParseFilter rule: " + httpMessage.getRequestHeader().getURI()));
            }
            bl = true;
            break;
        }
        if (!bl) {
            this.parent.notifyListenersReadURI(httpMessage);
        }
        if (this.parent.isStopped()) {
            log.debug((Object)"Spider process is stopped. Skipping crawling task...");
            this.parent.postTaskExecution();
            return;
        }
        this.parent.checkPauseAndWait();
        if (!bl && this.depth < this.parent.getSpiderParam().getMaxDepth()) {
            this.processResource(httpMessage);
        }
        this.parent.postTaskExecution();
        log.debug((Object)"Spider Task finished.");
    }

    private void deleteHistoryReference() {
        if (this.reference == null) {
            return;
        }
        if (this.getExtensionHistory() != null) {
            this.getExtensionHistory().delete(this.reference);
            this.reference = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResource(HttpMessage httpMessage) {
        List<SpiderParser> list = this.parent.getController().getParsers();
        Source source = new Source((CharSequence)httpMessage.getResponseBody().toString());
        String string = null;
        try {
            string = httpMessage.getRequestHeader().getURI().getPath();
        }
        catch (URIException uRIException) {
        }
        finally {
            if (string == null) {
                string = "";
            }
        }
        boolean bl = false;
        for (SpiderParser spiderParser : list) {
            if (spiderParser.canParseResource(httpMessage, string, bl)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parser " + spiderParser + " can parse resource '" + string + "'"));
                }
                if (!spiderParser.parseResource(httpMessage, source, this.depth)) continue;
                bl = true;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Parser " + spiderParser + " cannot parse resource '" + string + "'"));
        }
    }

    private ExtensionHistory getExtensionHistory() {
        if (this.extHistory == null) {
            this.extHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        }
        return this.extHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpMessage fetchResource() throws HttpException, IOException, DatabaseException {
        HttpMessage httpMessage;
        try {
            httpMessage = this.reference.getHttpMessage();
        }
        finally {
            this.deleteHistoryReference();
        }
        httpMessage.getRequestHeader().setHeader("If-Modified-Since", null);
        httpMessage.getRequestHeader().setHeader("If-None-Match", null);
        if (this.parent.getSpiderParam().getUserAgent() != null) {
            httpMessage.getRequestHeader().setHeader("User-Agent", this.parent.getSpiderParam().getUserAgent());
        }
        if (this.parent.getScanUser() != null) {
            httpMessage.setRequestingUser(this.parent.getScanUser());
        }
        if (this.parent.getHttpSender() != null) {
            try {
                this.parent.getHttpSender().sendAndReceive(httpMessage);
            }
            catch (ConnectException connectException) {
                log.debug((Object)("Failed to connect to: " + httpMessage.getRequestHeader().getURI()), (Throwable)connectException);
                throw connectException;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                log.debug((Object)("Socket timeout: " + httpMessage.getRequestHeader().getURI()), (Throwable)socketTimeoutException);
                throw socketTimeoutException;
            }
            catch (SocketException socketException) {
                log.debug((Object)("Socket exception: " + httpMessage.getRequestHeader().getURI()), (Throwable)socketException);
                throw socketException;
            }
            catch (UnknownHostException unknownHostException) {
                log.debug((Object)("Unknown host: " + httpMessage.getRequestHeader().getURI()), (Throwable)unknownHostException);
                throw unknownHostException;
            }
        }
        return httpMessage;
    }

    void cleanup() {
        this.deleteHistoryReference();
    }
}

