/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.zaproxy.zap.utils.DisplayUtils;

public abstract class AbstractFrame
extends JFrame {
    private static final long serialVersionUID = 6751593232255236597L;
    private static final String PREF_WINDOW_STATE = "window.state";
    private static final String PREF_WINDOW_SIZE = "window.size";
    private static final String PREF_WINDOW_POSITION = "window.position";
    private static final int WINDOW_DEFAULT_WIDTH = 800;
    private static final int WINDOW_DEFAULT_HEIGHT = 600;
    private final Preferences preferences;
    private final String prefnzPrefix = this.getClass().getSimpleName() + ".";
    private final Logger logger = Logger.getLogger(AbstractFrame.class);

    public AbstractFrame() {
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.initialize();
    }

    private void initialize() {
        Point point;
        this.setIconImages(DisplayUtils.getZapIconImages());
        this.setVisible(false);
        this.setTitle("OWASP ZAP");
        Dimension dimension = this.restoreWindowSize();
        if (dimension == null) {
            this.setSize(800, 600);
        }
        if ((point = this.restoreWindowLocation()) == null) {
            this.centerFrame();
        }
        this.restoreWindowState();
        this.addWindowStateListener(new FrameWindowStateListener());
        this.addComponentListener(new FrameResizedListener());
    }

    public void centerFrame() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private void saveWindowState(int n) {
        if ((n & 1) == 1) {
            this.preferences.put(this.prefnzPrefix + PREF_WINDOW_STATE, SimpleWindowState.ICONFIED.toString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Saving preference window.state=" + (Object)((Object)SimpleWindowState.ICONFIED)));
            }
        }
        if ((n & 6) == 6) {
            this.preferences.put(this.prefnzPrefix + PREF_WINDOW_STATE, SimpleWindowState.MAXIMIZED.toString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Saving preference window.state=" + (Object)((Object)SimpleWindowState.MAXIMIZED)));
            }
        }
        if (n == 0) {
            this.preferences.put(this.prefnzPrefix + PREF_WINDOW_STATE, SimpleWindowState.NORMAL.toString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Saving preference window.state=" + (Object)((Object)SimpleWindowState.NORMAL)));
            }
        }
    }

    private SimpleWindowState restoreWindowState() {
        SimpleWindowState simpleWindowState = null;
        String string = this.preferences.get(this.prefnzPrefix + PREF_WINDOW_STATE, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Restoring preference window.state=" + string));
        }
        if (string != null) {
            SimpleWindowState simpleWindowState2 = null;
            try {
                simpleWindowState2 = SimpleWindowState.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                simpleWindowState2 = null;
            }
            if (simpleWindowState2 != null) {
                switch (simpleWindowState2) {
                    case ICONFIED: {
                        this.setExtendedState(1);
                        break;
                    }
                    case NORMAL: {
                        this.setExtendedState(0);
                        break;
                    }
                    case MAXIMIZED: {
                        this.setExtendedState(6);
                        break;
                    }
                    default: {
                        this.logger.error((Object)("Invalid window state (nothing will changed): " + string));
                    }
                }
            }
            simpleWindowState = simpleWindowState2;
        }
        return simpleWindowState;
    }

    private void saveWindowSize(Dimension dimension) {
        if (dimension != null) {
            if (this.getExtendedState() == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Saving preference window.size=" + dimension.width + "," + dimension.height));
                }
                this.preferences.put(this.prefnzPrefix + PREF_WINDOW_SIZE, dimension.width + "," + dimension.height);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Preference window.size not saved, cause window state is not 'normal'.");
            }
        }
    }

    private Dimension restoreWindowSize() {
        Dimension dimension = null;
        String string = this.preferences.get(this.prefnzPrefix + PREF_WINDOW_SIZE, null);
        if (string != null) {
            int n = 0;
            int n2 = 0;
            String[] stringArray = string.split("[,]");
            try {
                n = Integer.parseInt(stringArray[0].trim());
                n2 = Integer.parseInt(stringArray[1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n > 0 && n2 > 0) {
                dimension = new Dimension(n, n2);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Restoring preference window.size=" + dimension.width + "," + dimension.height));
                }
                this.setSize(dimension);
            }
        }
        return dimension;
    }

    private void saveWindowLocation(Point point) {
        if (point != null) {
            if (this.getExtendedState() == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Saving preference window.position=" + point.x + "," + point.y));
                }
                this.preferences.put(this.prefnzPrefix + PREF_WINDOW_POSITION, point.x + "," + point.y);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Preference window.position not saved, cause window state is not 'normal'.");
            }
        }
    }

    private Point restoreWindowLocation() {
        Point point = null;
        String string = this.preferences.get(this.prefnzPrefix + PREF_WINDOW_POSITION, null);
        if (string != null) {
            int n = 0;
            int n2 = 0;
            String[] stringArray = string.split("[,]");
            try {
                n = Integer.parseInt(stringArray[0].trim());
                n2 = Integer.parseInt(stringArray[1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n > 0 && n2 > 0) {
                point = new Point(n, n2);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Restoring preference window.position=" + point.x + "," + point.y));
                }
                this.setLocation(point);
            }
        }
        return point;
    }

    @Deprecated
    protected List<Image> loadIconImages() {
        return new ArrayList<Image>(DisplayUtils.getZapIconImages());
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            this.logger.error((Object)"Error while saving the preferences", (Throwable)backingStoreException);
        }
    }

    private static enum SimpleWindowState {
        ICONFIED,
        NORMAL,
        MAXIMIZED;

    }

    private final class FrameResizedListener
    extends ComponentAdapter {
        private FrameResizedListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (componentEvent.getComponent() != null) {
                AbstractFrame.this.saveWindowSize(componentEvent.getComponent().getSize());
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            if (componentEvent.getComponent() != null) {
                AbstractFrame.this.saveWindowLocation(componentEvent.getComponent().getLocation());
            }
        }
    }

    private final class FrameWindowStateListener
    implements WindowStateListener {
        private FrameWindowStateListener() {
        }

        @Override
        public void windowStateChanged(WindowEvent windowEvent) {
            AbstractFrame.this.saveWindowState(windowEvent.getNewState());
        }
    }
}

