package saccubus;

import java.util.LinkedList;

public class HistoryDeque<T> {
	private final LinkedList<T> deque = new LinkedList<>();
	private T now;
	private final T initV;
	private int index;

	public HistoryDeque(T t){
		initV = t;
		now = initV;
		index = 0;
	}

	/**
	 *  Ōɒǉ
	 *  ݈ʒuindex͍ŌɈړ(t|Cg)
	 */
	public boolean add(T t){
		synchronized(deque){
			now = t;
			index = deque.size();
			return deque.add(t);
		}
	}
	public boolean addLast(T t){
		return add(t);
	}
	/**
	 *  擪ɒǉ
	 *  ݈ʒuindex͐擪Ɉړ(t|Cg)
	 */
	public void addFirst(T t) {
		synchronized(deque) {
			now = t;
			index = 0;
			deque.addFirst(t);
		}
	}
	/**
	 *  Ōɒǉ
	 *  ݈ʒuindex͓Ȃ
	 */
	public boolean offer(T t) {
		synchronized(deque){
			return deque.offer(t);
		}
	}
	/**
	 *  ݂̒lԂ
	 *  ݈ʒuindex͓Ȃ(now|Cg)
	 */
	public T getNow(){
		synchronized(deque){
			return now;
		}
	}
	/**
	 *  ŌԂ
	 *  ݈ʒuindex͍ŌɈړ(now|Cg)
	 */
	public T getLast(){
		synchronized(deque){
			index = size() - 1;
			if(deque.isEmpty())
				now = initV;
			else
				now = deque.getLast();
			return now;
		}
	}
	/**
	 *  ݈ʒuindex̒lԂ
	 *  index͕Ԃl̎̈ʒuɈړB
	 */
	public T next(){
		synchronized(deque){
			if(index >= deque.size()){
				index = deque.size();
				now = initV;
			} else {
				now = deque.get(index);
				index++;			}
			return now;
		}
	}
	/**
	 *  ݈ʒuindex̑O̒lԂ
	 *  index͕Ԃl̈ʒuɈړB
	 */
	public T back(){
		synchronized(deque){
			if(index <= 0 || deque.isEmpty()){
				index = 0;
				now = initV;
			}else{
				now = deque.get(--index);
			}
			return now;
		}
	}
	/**
	 *  擪̒l폜ĕԂ
	 *  ݈ʒuindex͓Ȃ
	 */
	public T poll() {
		synchronized(deque){
			if(!deque.isEmpty()){
				now = deque.poll();
			}else
				now = initV;
			return now;
		}
	}
	/**
	 *  擪̒lԂ
	 *  ݈ʒuindex͓Ȃ
	 */
	public T peek() {
		synchronized(deque){
			if(!deque.isEmpty()){
				now = deque.peek();
			}else
				now = initV;
			return now;
		}
	}
	/**
	 *  Ԃ
	 */
	public String getText() {
		StringBuffer sb = new StringBuffer("");
		synchronized(deque){
			if(!deque.isEmpty()){
				for(T t:deque){
					sb.append(t.toString());
					sb.append("\n");
				}
			}
			return sb.substring(0);
		}
	}
	/**
	 *  TCYԂ
	 */
	public int size() {
		return deque.size();
	}
	/**
	 *  indexԂ
	 */
	public int getIndex() {
		return index;
	}
}
