package saccubus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

import saccubus.FFmpeg.Aspect;
import saccubus.conv.Chat;
import saccubus.conv.CombineXML;
import saccubus.conv.CommandReplace;
import saccubus.conv.CommentReplace;
import saccubus.conv.ConvertToVideoHook;
import saccubus.conv.NicoXMLReader;
import saccubus.net.BrowserInfo;
import saccubus.net.BrowserInfo.BrowserCookieKind;
import saccubus.net.Gate;
import saccubus.net.NicoClient;
import saccubus.net.Path;
import saccubus.util.AudioPlay;
import saccubus.util.Cws2Fws;
import saccubus.util.Logger;
import saccubus.util.Stopwatch;
import saccubus.util.Util;

/**
 * <p>^Cg: ΂</p>
 *
 * <p>: jRjR̓Rgŕۑ</p>
 *
 * <p>쌠: Copyright (c) 2007 PSI</p>
 *
 * <p>Ж: </p>
 *
 * @author 
 * @version 1.0
 *  EventDispatchThread̂GUI`ׂ͂invokeLater()ɂčs
 *  JLabel̕\Ȃ
 */
public class ConvertWorker extends SwingWorker<String, String> {
	private ConvertingSetting Setting;
	private String Vid;
	private String Tag;
	private String VideoID;
	private String VideoTitle;
	private String VideoBaseName = "";
	private String Time;
	private JLabel Status;
	private final JLabel MovieInfo;
	private final ConvertStopFlag StopFlag;
	private static final String TMP_COMMENT = "_vhook.tmp";
	private static final String TMP_OWNERCOMMENT = "_vhookowner.tmp";
	private static final String TMP_OPTIONALTHREAD = "_vhookoptional.tmp";
//	private static final String VIDEO_URL_PARSER = "http://www.nicovideo.jp/watch/";
	public static final String OWNER_EXT = "[Owner].xml";	// e҃RgTtBbNX
	public static final String OPTIONAL_EXT = "{Optional}.xml";	// IvViXbhTtBbNX
	public static final String TMP_APPEND_EXT = "_all_comment.xml";
	public static final String TMP_APPEND_OPTIONAL_EXT = "_all_optional.xml";
	private static final String TMP_COMBINED_XML = "_tmp_comment.xml";
	private static final String TMP_COMBINED_XML2 = "_tmp_optional.xml";
	private static final String TMP_COMBINED_XML3 = "_tmp_comment2.xml";
	private static final String TMP_COMBINED_XML4 = "_tmp_optiona2.xml";
	static final String TMP_LOG_FRONTEND = "frontend.txt";
	private static final String THUMB_INFO = "_thumb_info";
	private String OtherVideo;
	private final String WatchInfo;
	private InfoStack infoStack;
	private BrowserCookieKind BrowserKind = BrowserCookieKind.NONE;
	private final BrowserInfo browserInfo;
	private String UserSession = "";	//uEU擾[U[ZbV
	private final Stopwatch stopwatch;
	private File selectedVhook;
	private Aspect videoAspect;
	private boolean isPlayerWide;
	private File fwsFile = null;
	private VideoIDFilter DefaultVideoIDFilter;
	private String proxy;
	private int proxy_port;
	private String mailAddress;
	private String password;
	private String inSize;
	private String setSize;
	private String padOption;
	private String outSize;
	private String aprilFool;
	private final StringBuffer sbRet;
	private final saccubus.MainFrame parent;
	/*
	 * sbRet is return String value to EXTERNAL PROGRAM such as BAT file, SH script, so on.
	 * string should be ASCII or URLEncoded in System Encoding.
	 * format: KEY=VALUE\n[KRY=VALUE\n]...
	 * KEYs are:
	 *  RESULT=0 //success, other integer //error code, Prompt(CUI) will exit(this value)
	 *  DATEUF=integer //Date seconds of first user comment downloaded, otherwise ThreadID
	 *  ...
	 */
	private String result = "0";
	private String dateUserFirst = "";
	//private String dateUserLast = "";
	//private final boolean watchvideo;
	private double frameRate = 0.0;
	private double fpsUp = 0.0;
	private double fpsMin = 0.0;
	private boolean checkFps;
	private String lastFrame = "";
	private AutoPlay autoPlay;
	private ArrayList<CommentReplace> CommentReplaceList = new ArrayList<CommentReplace>();
	private File imgDir;
	private Aspect outAspect;
	private String alternativeTag = "";
	private final ConvertManager manager;
	private Gate gate;
	private ErrorControl errorControl;
	private String lowVideoID;
	private int tid;
	private Logger log;

	public ConvertWorker(int worker_id,
			String url, String time, ConvertingSetting setting,
			JLabel[] jLabels, ConvertStopFlag flag,	MainFrame frame,
			AutoPlay autoplay, ConvertManager conv, ErrorControl errcon, StringBuffer sb) {
		Vid = url;
		url = url.trim();
		//watchvideo = !url.startsWith("http");
		int index = 0;
		index = url.indexOf('?');
		if(index >= 0){
			int index2 = url.lastIndexOf('/',index);
			Tag = url.substring(index2+1,index);
			WatchInfo = url.substring(index);
		}else{
			int index2 = url.lastIndexOf('/');
			Tag = url.substring(index2+1);
			WatchInfo = "";
		}
		VideoID = "[" + Tag + "]";
		lowVideoID = VideoID + "low_";
		DefaultVideoIDFilter = new VideoIDFilter(VideoID);
		if (time.equals("000000") || time.equals("0")){		// for auto.bat
			Time = "";
		} else {
			Time = time;
		}
		Setting = setting;
		Status = jLabels[0];
		StopFlag = flag;
		MovieInfo = jLabels[1];
		MovieInfo.setText(" ");
		stopwatch = new Stopwatch(jLabels[2]);
		manager = conv;
		autoPlay = autoplay;
		parent = frame;
		sbRet = sb;
		errorControl = errcon;
		tid = worker_id;
		log = new Logger(Tag, tid, TMP_LOG_FRONTEND);
		browserInfo = new BrowserInfo(log);
	}
	private File VideoFile = null;
	private File CommentFile = null;
	private File OwnerCommentFile = null;
	private File OptionalThreadFile = null;
	private File ConvertedVideoFile = null;
	private File CommentMiddleFile = null;
	private File OwnerMiddleFile = null;
	private File OptionalMiddleFile = null;
	private FFmpeg ffmpeg = null;
	private File VhookNormal = null;
	private File VhookWide = null;
	private File VhookQ = null;
	private int wayOfVhook = 0;
	private ArrayList<File> listOfCommentFile = new ArrayList<File>();
	private String optionalThreadID = "";	// set in
	private String errorLog = "";
	private int videoLength = 0;
	private int ownerCommentNum = 0;
	private File fontDir;
	private File gothicFont = null;
	private File simsunFont = null;
	private File gulimFont = null;
	private File arialFont = null;
	private File georgiaFont = null;
	private File devabagariFont = null;
	private File tahomaFont = null;
	private File mingliuFont = null;
	private File newMinchoFont = null;
	private File estrangeloEdessaFont = null;
	private File arialUnicodeFont = null;
	private File gujaratiFont = null;
	private File bengalFont = null;
	private File tamilFont = null;
	private File laooFont = null;
	private File gurmukhiFont = null;
	private File kannadaFont = null;
	private File thaanaFont = null;
	private File malayalamFont = null;
	private File teluguFont = null;
	private File nirmalaFont = null;
	private Pattern ngWordPat;
	private Pattern ngIDPat;
	private CommandReplace ngCmd;
	private Path thumbInfo = new Path("null");
	private File thumbInfoFile;
	private String wakuiro = "";
	private StringBuffer resultBuffer;
	private File thumbnailJpg;
	private String addOption;
	private File CombinedCommentFile;
	private File CombinedOptionalFile;
	private File appendCommentFile;
	private File appendOptionalFile;
	private File lowVideoFile;
	private boolean isConverting = false;
	private boolean isDebugNet = false;
	private boolean isLive = false;

	public File getVideoFile() {
		return VideoFile;
	}
	private String getVideoBaseName() {
		return VideoBaseName;
	}
	public ConvertingSetting getSetting(){
		return Setting;
	}
	public String getErrorLog() {
		return errorLog;
	}
	public String getLastError() {
		if (errorLog==null)
			return "";
		errorLog = errorLog.trim();
		int index = errorLog.lastIndexOf("\n");
		String lasterror = errorLog.substring(index+1);
		return lasterror;
	}

//	private void sendtext(final String text){
//		Status.setText(text);
//	}

	private String mySendedText;
	private void sendtext(final String text){
		mySendedText = text;
		publish(text);
	}
	private String gettext(){
		return mySendedText;
	}
	protected void process(List<String> chunk){
		while(!chunk.isEmpty())
			Status.setText(chunk.remove(0));
	}
	private boolean isSaveConverted(){
		return Setting.isSaveConverted();
	}
	private boolean isSaveVideo(){
		return Setting.isSaveVideo();
	}
	private boolean isSaveComment(){
		return Setting.isSaveComment();
	}
	private boolean isSaveOwnerComment(){
		return Setting.isSaveOwnerComment() && isSaveComment();
	}
	private boolean isConvertWithComment(){
		return Setting.isConvertWithComment();
	}
	private boolean isConvertWithOwnerComment(){
		return Setting.isConvertWithOwnerComment();
	}
	private boolean isVideoFixFileName(){
		return Setting.isVideoFixFileName();
	}
	private boolean isCommentFixFileName(){
		return Setting.isCommentFixFileName();
	}
	private boolean isDeleteVideoAfterConverting(){
		return Setting.isDeleteVideoAfterConverting();
	}
	private boolean isDeleteCommentAfterConverting(){
		return Setting.isDeleteCommentAfterConverting();
	}
	private boolean useProxy(){
		return Setting.useProxy();
	}
//	private ArrayList<CommentReplace> getCommentReplaceSet(){
//		return commentReplaceSet;
//	}
//	private void addCommentReplace(CommentReplace cmrpl){
//		commentReplaceSet.add(cmrpl);
//	}
	private boolean isAppendComment(){
		return Setting.isAppendComment();
	}
	private boolean checkOK() {
		sendtext("`FbNĂ܂");
		if (!isSaveConverted() && !isSaveVideo()
			&& !isSaveComment() && !isSaveOwnerComment()
			&& !Setting.isSaveThumbInfo()){
			sendtext("邱Ƃ܂");
			result = "1";
			return false;
		}
		if (isSaveConverted()) {
			File a = new File(Setting.getFFmpegPath());
			if (!a.canRead()) {
				sendtext("FFmpeg܂B");
				result = "2";
				return false;
			}
			this.ffmpeg = new FFmpeg(Setting.getFFmpegPath());
			if (Setting.isZqPlayer()) {
				if(Setting.getZqVhookPath().indexOf(' ') >= 0){
					sendtext("܂BvhookCuɂ͔p󔒂͎g܂B");
					result = "3";
					return false;
				}
				VhookQ = new File(Setting.getZqVhookPath());
				if(!VhookQ.canRead()){
					sendtext("ʊgVhookCu܂B");
					result = "4";
					return false;
				}
				wayOfVhook = 3;
			} else {
				if (Setting.isUseVhookNormal()){
					if(Setting.getVhookPath().indexOf(' ') >= 0) {
						sendtext("܂BvhookCuɂ͔p󔒂͎g܂B");
						result = "3";
						return false;
					}
					VhookNormal = new File(Setting.getVhookPath());
					if (!VhookNormal.canRead()) {
						sendtext("VhookCu܂B");
						result = "4";
						return false;
					}
					wayOfVhook++;
				}
				if (Setting.isUseVhookWide()){
					if(Setting.getVhookWidePath().isEmpty()){
						VhookWide = VhookNormal;
					}
					else {
						if(Setting.getVhookWidePath().indexOf(' ') >= 0) {
							sendtext("܂Bvhookt@Cɂ͔p󔒂͎g܂B");
							result = "5";
							return false;
						}
						VhookWide = new File(Setting.getVhookWidePath());
					}
					if (!VhookWide.canRead()) {
						sendtext("VhookCuiChj܂B");
						result = "6";
						return false;
					}
					wayOfVhook++;
				}
			}
			if (wayOfVhook == 0){
				sendtext("gpłVhookCu܂B");
				result = "7";
				return false;
			}
			if(Setting.isEnableCA()){
				String windir = System.getenv("windir");
				if(windir == null){
					sendtext("WindowstH_܂B");
					result = "8";
					return false;
				}
				fontDir = new File(windir, "Fonts");
				if(!fontDir.isDirectory()){
					sendtext("FontstH_܂B");
					result = "9";
					return false;
				}
				simsunFont = new File(fontDir, "SIMSUN.TTC");
				if (!simsunFont.canRead()) {
					sendtext("CAptHg܂B" + simsunFont.getPath());
					result = "10";
					return false;
				}
				gulimFont = new File(fontDir, "GULIM.TTC");	//windowsXP,7,8 ە
				File saveGulimFont = gulimFont;
				if (!gulimFont.canRead()) {
					sendtext("x@CAptHg܂B" + gulimFont.getPath());
					gulimFont = new File(fontDir, "MALGUN.TTF");	//windows10 nO
				}
				if (!gulimFont.canRead()) {
					gulimFont = simsunFont;	// 
				}
				if (!gulimFont.canRead()) {
					sendtext("CAptHg̑ւ܂B" + gulimFont.getPath());
					result = "11";
					return false;
				}
				if(!gulimFont.equals(saveGulimFont)){
					log.println("CAptHg" + saveGulimFont.getPath() + "" + gulimFont.getName() + "őւ܂B");
				}
				arialFont = new File(fontDir, "ARIAL.TTF");
				if(!arialFont.canRead()){
					sendtext("CAptHg܂B" + arialFont.getPath());
					result = "12";
					return false;
				}
				gothicFont = new File(fontDir, "MSGOTHIC.TTC");
				if (!gothicFont.canRead()) {
					sendtext("CAptHg܂B" + gothicFont.getPath());
					result = "13";
					return false;
				}
				georgiaFont  = new File(fontDir, "sylfaen.ttf");
				if (!georgiaFont.canRead()) {
					sendtext("x@CAptHg܂B" + georgiaFont.getPath());
					//retValue = "14";
					//return false;
					log.println("CAptHg" + georgiaFont.getPath() + "" + gothicFont.getName() + "őւ܂B");
					georgiaFont = gothicFont;
				}
				nirmalaFont = new File(fontDir,"Nirmala.ttf");
				devabagariFont = new File(fontDir, "mangal.ttf");
				if (!devabagariFont.canRead()) {
					devabagariFont = nirmalaFont;
				}
				if(!devabagariFont.canRead()){
					sendtext("x@CAptHg܂B" + devabagariFont.getPath());
					//retValue = "15";
					//return false;
					log.println("CAptHg" + devabagariFont.getPath() + "" + arialFont.getName() + "őւ܂B");
					devabagariFont = arialFont;
				}
				tahomaFont = new File(fontDir, "tahoma.ttf");
				if (!tahomaFont.canRead()) {
					sendtext("x@CAptHg܂B" + tahomaFont.getPath());
					//retValue = "16";
					//return false;
					log.println("CAptHg" + tahomaFont.getPath() + "" + arialFont.getName() + "őւ܂B");
					tahomaFont = arialFont;
				}
				mingliuFont = new File(fontDir, "mingliu.ttc");
				if (!mingliuFont.canRead()) {
					sendtext("x@CAptHg܂B" + mingliuFont.getPath());
					//retValue = "17";
					//return false;
					log.println("CAptHg" + mingliuFont.getPath() + "" + simsunFont.getName() + "őւ܂B");
					mingliuFont = simsunFont;
				}
				newMinchoFont = new File(fontDir, "SIMSUN.TTC");	//NGULIM.TTF
				if (!newMinchoFont.canRead()) {
					sendtext("x@CAptHg܂B" + newMinchoFont.getPath());
					//retValue = "18";
					//return false;
					log.println("CAptHg" + newMinchoFont.getPath() + "" + simsunFont.getName() + "őւ܂B");
					newMinchoFont = simsunFont;
				}
				estrangeloEdessaFont = new File(fontDir, "estre.ttf");
				if (!estrangeloEdessaFont.canRead()) {
					estrangeloEdessaFont = new File(fontDir, "seguihis.ttf");
				}
				if (!estrangeloEdessaFont.canRead()){
					sendtext("x@CAptHg܂B" + estrangeloEdessaFont.getPath());
					//retValue = "19";
					//return false;
					log.println("CAptHg" + estrangeloEdessaFont.getPath() + "" + arialFont.getName() + "őւ܂B");
					estrangeloEdessaFont = arialFont;
				}
				arialUnicodeFont = new File(fontDir, "arialuni.ttf");
				if (!arialUnicodeFont.canRead()) {
					sendtext("x@CAptHg܂B" + arialUnicodeFont.getPath());
					//retValue = "20";
					//return false;
					log.println("CAptHg" + arialUnicodeFont.getPath() + "" + arialFont.getName() + "őւ܂B");
					arialUnicodeFont = arialFont;
				}
				gujaratiFont = new File(fontDir, "shruti.ttf");
				if (!gujaratiFont.canRead()){
					gujaratiFont = nirmalaFont;
				}
				if (!gujaratiFont.canRead()) {
					sendtext("x@CAptHg܂B" + gujaratiFont.getPath());
					//retValue = "21";
					//return false;
					log.println("CAptHg" + gujaratiFont.getPath() + "" + arialUnicodeFont.getName() + "őւ܂B");
					gujaratiFont = arialUnicodeFont;
				}
				bengalFont = new File(fontDir, "vrinda.ttf");
				if (!bengalFont.canRead()) {
					bengalFont = nirmalaFont;
				}
				if(!bengalFont.canRead()){
					sendtext("x@CAptHg܂B" + bengalFont.getPath());
					//retValue = "22";
					//return false;
					log.println("CAptHg" + bengalFont.getPath() + "" + arialUnicodeFont.getName() + "őւ܂B");
					bengalFont = arialUnicodeFont;
				}
				tamilFont = new File(fontDir, "latha.ttf");
				if (!tamilFont.canRead()) {
					tamilFont = nirmalaFont;
				}
				if (!tamilFont.canRead()) {
					sendtext("x@CAptHg܂B" + tamilFont.getPath());
					//retValue = "23";
					//return false;
					log.println("CAptHg" + tamilFont.getPath() + "" + arialUnicodeFont.getName() + "őւ܂B");
					tamilFont = arialUnicodeFont;
				}
				laooFont = new File(fontDir, "laoui.ttf");
				if (!laooFont.canRead()) {
					laooFont = new File(fontDir, "LeelawUI.ttf");
				}
				if (!laooFont.canRead()) {
					sendtext("x@CAptHg܂B" + laooFont.getPath());
					//retValue = "24";
					//return false;
					log.println("CAptHg" + laooFont.getPath() + "" + arialUnicodeFont.getName() + "őւ܂B");
					laooFont = arialUnicodeFont;
				}
				gurmukhiFont = new File(fontDir, "raavi.ttf");
				if (!gurmukhiFont.canRead()) {
					gurmukhiFont = nirmalaFont;
				}
				if (!gurmukhiFont.canRead()) {
					sendtext("x@CAptHg܂B" + gurmukhiFont.getPath());
					//retValue = "25";
					//return false;
					log.println("CAptHg" + gurmukhiFont.getPath() + "" + arialUnicodeFont.getName() + "őւ܂B");
					gurmukhiFont = arialUnicodeFont;
				}
				kannadaFont = new File(fontDir, "tunga.ttf");
				if (!kannadaFont.canRead()) {
					kannadaFont = nirmalaFont;
				}
				if (!kannadaFont.canRead()) {
					sendtext("x@CAptHg܂B" + kannadaFont.getPath());
					//retValue = "26";
					//return false;
					log.println("CAptHg" + kannadaFont.getPath() + "" + arialUnicodeFont.getName() + "őւ܂B");
					kannadaFont = arialUnicodeFont;
				}
				thaanaFont = new File(fontDir, "mvboli.ttf");
				if (!thaanaFont.canRead()) {
					sendtext("x@CAptHg܂B" + thaanaFont.getPath());
					//retValue = "27";
					//return false;
					log.println("CAptHg" + thaanaFont.getPath() + "" + arialUnicodeFont.getName() + "őւ܂B");
					thaanaFont = arialUnicodeFont;
				}
				malayalamFont = new File(fontDir, "kartika.ttf");
				if (!malayalamFont.canRead()) {
					malayalamFont = nirmalaFont;
				}
				if (!malayalamFont.canRead()) {
					sendtext("x@CAptHg܂B" + malayalamFont.getPath());
					//retValue = "28";
					//return false;
					log.println("CAptHg" + malayalamFont.getPath() + "" + arialUnicodeFont.getName() + "őւ܂B");
					malayalamFont = arialUnicodeFont;
				}
				teluguFont = new File(fontDir, "gautami.ttf");
				if (!teluguFont.canRead()) {
					teluguFont = nirmalaFont;
				}
				if (!teluguFont.canRead()) {
					sendtext("x@CAptHg܂B" + teluguFont.getPath());
					//retValue = "29";
					//return false;
					log.println("CAptHg" + teluguFont.getPath() + "" + arialUnicodeFont.getName() + "őւ܂B");
					teluguFont = arialUnicodeFont;
				}
			}else{
				a = new File(Setting.getFontPath());
				if (!a.canRead()) {
					sendtext("tHg܂B");
					result = "30";
					return false;
				}
			}
		} else {
			if (isDeleteVideoAfterConverting()) {
				sendtext("ϊȂ̂ɁA폜ėǂłH");
				result = "31";
				return false;
			}
			if (isDeleteCommentAfterConverting()) {
				sendtext("ϊȂ̂ɁARg폜ėǂłH");
				result = "32";
				return false;
			}
		}
		if (isSaveVideo() || isSaveComment() || isSaveOwnerComment()
			|| Setting.isSaveThumbInfo()) {
			// uEUZbVL̏ꍇ͂ŃZbVǂݍ
			UserSession = browserInfo.getUserSession(Setting);
			BrowserKind = browserInfo.getValidBrowser();
			if (BrowserKind == BrowserCookieKind.NONE){
				mailAddress = Setting.getMailAddress();
				password = Setting.getPassword();
				if (mailAddress == null || mailAddress.isEmpty()
					|| password == null || password.isEmpty()) {
					sendtext("OCZbVA[AhXpX[h󔒂łB");
					result = "33";
					return false;
				}
			} else if(UserSession.isEmpty()){
				sendtext("uEU" + BrowserKind.getName() + "̃ZbV擾Ɏs");
				result = "34";
				return false;
			}
			if (useProxy()){
				proxy = Setting.getProxy();
				proxy_port = Setting.getProxyPort();
				if (   proxy == null || proxy.isEmpty()
					|| proxy_port < 0 || proxy_port > 65535   ){
					sendtext("vLV̐ݒ肪słB");
					result = "35";
					return false;
				}
				isDebugNet = proxy.startsWith(NicoClient.DEBUG_PROXY);
			} else {
				proxy = null;
				proxy_port = -1;
			}
		}
		resultBuffer = Setting.getReturnBuffer();
		sendtext("`FbNI");
		return true;
	}

	public synchronized NicoClient getNicoClient() {
		if (isSaveVideo() || isSaveComment() || isSaveOwnerComment()
			|| Setting.isSaveThumbInfo()) {
			sendtext("OC");
			NicoClient client = null;
			if (BrowserKind != BrowserCookieKind.NONE){
				// ZbVLAOCς݂NicoClientclientɕԂ
				client = new NicoClient(BrowserKind, UserSession, proxy, proxy_port, stopwatch, log);
			} else {
				client = new NicoClient(mailAddress, password, proxy, proxy_port, stopwatch, log);
			}
			if (!client.isLoggedIn()) {
				sendtext("OCs " + BrowserKind.getName() + " " + client.getExtraError());
			} else {
				sendtext("OC " + BrowserKind.getName());
			}
			return client;
		} else {
			return null;
		}
	}

	private boolean saveVideo(NicoClient client) {
		File folder = Setting.getVideoFixFileNameFolder();
		sendtext("̕ۑ");
		/*̕ۑ*/
		try {
			if (isSaveVideo()) {
				if (isVideoFixFileName()) {
					if (folder.mkdir()) {
						log.println("Folder created: " + folder.getPath());
					}
					if (!folder.isDirectory()) {
						sendtext("̕ۑtH_쐬ł܂B");
						result = "40";
						return false;
					}
					lowVideoFile = null;
					if(client.isEco()){
						if(Setting.isDisableEco()){
							sendtext("GRm~[[hȂ̂Œ~܂");
							result = "42";
							return false;
						}else{
							lowVideoFile = new File(folder, lowVideoID+VideoTitle+".flv");
						}
					}
					VideoFile = new File(folder, getVideoBaseName() + ".flv");
				} else {
					VideoFile = Setting.getVideoFile();
				}
				if(VideoFile.isFile() && VideoFile.canRead()){
					sendtext("͊ɑ݂܂");
					log.println("͊ɑ݂܂B_E[hXLbv܂");
				}else{
					sendtext("̃_E[hJn");
					if (client == null){
						sendtext("OCĂȂ̂ɓ̕ۑɂȂ܂");
						result = "41";
						return false;
					}
					if(lowVideoFile==null){
						lowVideoFile = VideoFile;
					}
					if(client.isEco() && lowVideoFile.isFile() && lowVideoFile.canRead()){
						sendtext("GRm~[[hŃGR͊ɑ݂܂");
						log.println("GR͊ɑ݂܂B_E[hXLbv܂");
						VideoFile = lowVideoFile;
					}else{
						VideoFile = client.getVideo(lowVideoFile, Status, StopFlag,
								isVideoFixFileName() && Setting.isChangeMp4Ext());
							if (stopFlagReturn()) {
								result = "43";
								return false;
							}
					}
					if (VideoFile == null) {
						sendtext("̃_E[hɎs" + client.getExtraError());
						result = "44";
						return false;
					}
					resultBuffer.append("video: "+VideoFile.getName()+"\n");
				}
				if (optionalThreadID == null || optionalThreadID.isEmpty()) {
					optionalThreadID = client.getOptionalThreadID();
				}
				videoLength = client.getVideoLength();
				setVideoTitleIfNull(VideoFile.getName());
			} else {
				if (isSaveConverted()) {
					if (isVideoFixFileName()) {
						String videoFilename;
						if((videoFilename = detectTitleFromVideo(folder)) == null){
							if (OtherVideo == null){
								sendtext("t@CtH_ɑ݂܂B");
								result = "45";
							} else {
								sendtext("t@C.flvł܂F" + OtherVideo);
								result = "46";
							}
							return false;
						}
						VideoFile = new File(folder, videoFilename);
						if (!VideoFile.canRead()) {
							sendtext("t@Cǂݍ߂܂B");
							result = "47";
							return false;
						}
					} else {
						VideoFile = Setting.getVideoFile();
						if (!VideoFile.exists()) {
							sendtext("t@C݂܂B");
							result = "48";
							return false;
						}
					}
					setVideoTitleIfNull(VideoFile.getName());
				}
			}
			sendtext("̕ۑI");
		}catch(NullPointerException e){
			sendtext("(ĹM)ʂ\nKb\n");
			log.printStackTrace(e);
		}
		return true;
	}

	private boolean saveComment(NicoClient client) {
		sendtext("Rg̕ۑ");
		File folder = Setting.getCommentFixFileNameFolder();
		String commentTitle = "";
		String prefix = "";
		String back_comment = Setting.getBackComment();
		ArrayList<File> filelist = new ArrayList<>();
		boolean backup = false;
		if (isSaveComment()) {
			if (isCommentFixFileName()) {
				if (folder.mkdir()) {
					log.println("Folder created: " + folder.getPath());
				}
				if (!folder.isDirectory()) {
					sendtext("Rg̕ۑtH_쐬ł܂B");
					result = "50";
					return false;
				}
				if (Setting.isAddTimeStamp()) {	// prefix set
					if(Time == null || Time.isEmpty() || Time.equals("0")
						|| Time.equals("Owner") || Time.equals("Optional")){
						prefix = "[" + WayBackDate.formatNow() + "]";
					} else {
						WayBackDate wbDate = new WayBackDate(Time);
						if (wbDate.isValid()){
							prefix = "[" + wbDate.format() + "]";
						} else {
							prefix = "[" + Time + "]";
						}
					}
				}
				commentTitle = getVideoBaseName() + prefix;
			//	commentTitle = (Setting.isChangeTitleId()? VideoTitle + VideoID : VideoID + VideoTitle) + prefix;
				CommentFile = new File(folder, commentTitle + ".xml");
			} else {
				CommentFile = Setting.getCommentFile();
			}
			if (client == null){
				sendtext("OCĂȂ̂ɃRg̕ۑɂȂ܂");
				result = "51";
				return false;
			}
			if (Setting.isFixCommentNum()) {
				back_comment = client
						.getBackCommentFromLength(back_comment);
			}
			sendtext("Rg̃_E[hJn");
			if(isAppendComment() || !isDebugNet){
				// t@Cݒ
				appendCommentFile = mkTemp(TMP_APPEND_EXT);
				// O
				if(CommentFile.exists()){
					backup = Path.fileCopy(CommentFile,appendCommentFile);
				}
			}
			File target = client.getComment(CommentFile, Status, back_comment, Time, StopFlag,
					Setting.getCommentIndex(), isAppendComment());
			if (stopFlagReturn()) {
				result = "52";
				return false;
			}
			if (target == null) {
				sendtext("Rg̃_E[hɎs " + client.getExtraError());
				if(backup)
					Path.move(appendCommentFile, CommentFile);
				result = "53";
				return false;
			}
			if(isAppendComment() || !isDebugNet){	// fobOłȂ΃Rgt@C
				// t@C_u𐮗
				backup = Path.fileCopy(CommentFile,appendCommentFile);
				filelist.add(CommentFile);
				sendtext("Rgt@C");
				if (!CombineXML.combineXML(filelist, CommentFile)){
					sendtext("Rgt@Co܂ł");
					if(backup)
						Path.move(appendCommentFile, CommentFile);	// sobNAbv߂
					result = "5A";
					return false;
				}
			}
			//Rgt@C̍ŏdate="integer"T dateUserFirst ɃZbg
			dateUserFirst = getDateUserFirst(CommentFile);
			sendtext("Rg̃_E[hI");
			optionalThreadID = client.getOptionalThreadID();
			sendtext("IvViXbh̕ۑ");
			if (optionalThreadID != null && !optionalThreadID.isEmpty() ){
				if (isCommentFixFileName()) {
					OptionalThreadFile = new File(folder, getVideoBaseName() + prefix + OPTIONAL_EXT);
				} else {
					OptionalThreadFile = getOptionalThreadFile(Setting.getCommentFile());
				}
				backup = false;
				if(isAppendComment() || !isDebugNet){
					appendOptionalFile = mkTemp(TMP_APPEND_OPTIONAL_EXT);
					// O
					if(OptionalThreadFile.exists()){
						backup = Path.fileCopy(OptionalThreadFile, appendOptionalFile);
					}
				}
				sendtext("IvViXbh̃_E[hJn");
				target = client.getOptionalThread(
					OptionalThreadFile, Status, optionalThreadID, back_comment, Time, StopFlag,
					Setting.getCommentIndex(),isAppendComment());
				if (stopFlagReturn()) {
					result = "54";
					return false;
				}
				if (target == null) {
					sendtext("IvViXbh̃_E[hɎs " + client.getExtraError());
					if(backup)
						Path.move(appendOptionalFile, OptionalThreadFile);
					result = "55";
					return false;
				}
				if(isAppendComment() || !isDebugNet){
					backup = Path.fileCopy(OptionalThreadFile, appendOptionalFile);
					filelist.clear();
					filelist.add(OptionalThreadFile);
					sendtext("IvViXbh");
					if (!CombineXML.combineXML(filelist, OptionalThreadFile)){
						sendtext("IvViXbho܂ł");
						if(backup)
							Path.move(appendOptionalFile, OptionalThreadFile);
						result = "5B";
						return false;
					}
				}
				if (dateUserFirst.isEmpty()) {
					//t@C̍ŏdate="integer"T dateUserFirst ɃZbg
					dateUserFirst = getDateUserFirst(OptionalThreadFile);
				}
				sendtext("IvViXbh̕ۑI");
			}
			resultBuffer.append("comment: "+CommentFile.getName()+"\n");
		}
		sendtext("Rg̕ۑI");
		return true;
	}

	private File getOptionalThreadFile(File file) {
		if (file == null || file.getPath() == null) {
			return mkTemp(OPTIONAL_EXT);
		}
		return getReplacedExtFile(file, OPTIONAL_EXT);
	}
	private String getDateUserFirst(File comfile){
		//Rgt@C̍ŏdate="integer"T dateUserFirst ɃZbg
		String text = Path.readAllText(comfile, "UTF-8");
		Pattern p = Pattern.compile("<chat [^>]+>");
		Matcher m = p.matcher(text);
		String chats = "";
		String ret = "";
		while(m.find()){
			chats = m.group() ;
			ret = getDateFromChat(chats);
			if(!ret.isEmpty())
				return ret;
		}
		return ret;
	}
	private static String getLastChat(File comfile){
		//Rgt@C̍Ō<chat thread="..." > ̕Ԃ
		String text = Path.readAllText(comfile, "UTF-8");
		Pattern p = Pattern.compile("<chat [^>]+>");
		Matcher m = p.matcher(text);
		String chats = "";
		while(m.find()){
			chats = m.group();
		}
		return chats;
	}
	private static String getRexpFromChats(String chats, String rexp, int i){
		Pattern p = Pattern.compile(rexp);
		Matcher m = p.matcher(chats);
		if(m.find()){
			return m.group(i);
		}
		return "";
	}
	private String getDateFromChat(String chat){
		return getRexpFromChats(chat,"date=\"([0-9]+)\"",1);
	}
	public static String getNoUserLastChat(File file) {
		return getRexpFromChats(getLastChat(file),"no=\"([0-9]+)\"", 1);
	}

	private boolean saveOwnerComment(NicoClient client){
		sendtext("e҃Rg̕ۑ");
		File folder = Setting.getCommentFixFileNameFolder();
		if (isSaveOwnerComment()) {
			if (isCommentFixFileName()) {
				if (folder.mkdir()) {
					log.println("Folder created: " + folder.getPath());
				}
				if (!folder.isDirectory()) {
					sendtext("e҃Rg̕ۑtH_쐬ł܂B");
					result = "60";
					return false;
				}
				OwnerCommentFile = new File(folder, getVideoBaseName() + OWNER_EXT);
			} else {
				OwnerCommentFile = Setting.getOwnerCommentFile();
			}
			sendtext("e҃Rg̃_E[hJn");
			if (client == null){
				sendtext("OCĂȂ̂ɓe҃Rg̕ۑɂȂ܂");
				result = "61";
				return false;
			}
			OwnerCommentFile = client.getOwnerComment(OwnerCommentFile, Status,
					StopFlag);
			if (stopFlagReturn()) {
				result = "62";
				return false;
			}
			if (OwnerCommentFile == null) {
				sendtext("e҃Rg̃_E[hɎs");
				log.println("e҃Rg̃_E[hɎs");
				//result = "63";
				return true;
			}
			if (optionalThreadID == null || optionalThreadID.isEmpty()) {
				optionalThreadID = client.getOptionalThreadID();
			}
		}
		sendtext("e҃Rg̕ۑI");
		return true;
	}

	private boolean saveThumbInfo0(NicoClient client,String vtag) {
		sendtext("̕ۑ");
		/*y[W̕ۑ*/
		String ext = Setting.isSaveThumbInfoAsText()? ".txt":".xml";
		File folder = Setting.getVideoFixFileNameFolder();
		if (isVideoFixFileName()) {
			if (folder.mkdir()) {
				log.println("Folder created: " + folder.getPath());
			}
			if (!folder.isDirectory()) {
				sendtext("̕ۑtH_쐬ł܂B");
				result = "A0";
				return false;
			}
			thumbInfoFile = new File(folder, getVideoBaseName() + ext);
		} else {
			thumbInfoFile = getThumbInfoFileFrom(Setting.getVideoFile(), ext);
		}
		if(thumbInfoFile==null){
			sendtext("t@Cnullł");
			result = "A1";
			return false;
		}
		sendtext("̕ۑ");
		if (client == null){
			sendtext("OCĂȂ̂ɓ̕ۑɂȂ܂");
			result = "A2";
			return false;
		}
		thumbInfo = client.getThumbInfoFile(vtag);
		if (stopFlagReturn()) {
			result = "A3";
			return false;
		}
		if (thumbInfo == null) {
			sendtext("̎擾Ɏs" + client.getExtraError());
			result = "A4";
			return false;
		}
		log.println("reading:" + thumbInfo);
		boolean isOK = true;
		if(!saveThumbUser(thumbInfo, client)){
			sendtext("eҏ̎擾Ɏs");
			log.println("eҏ̎擾Ɏs");
			isOK = false;
		}
		if(!saveThumbnailJpg(thumbInfo, client)){
			sendtext("TlC摜̎擾Ɏs");
			log.println("TlC摜̎擾Ɏs");
			isOK = false;
		}
		if(Path.fileCopy(thumbInfo, thumbInfoFile)){
			if(thumbInfo.delete()){
				log.println("Deleted:" + thumbInfo);
			}
		}
		else
			isOK = false;
		if(isOK)
			sendtext("̕ۑI");
		return isOK;
	}

	private boolean saveThumbInfo(NicoClient client, String vtag) {
		if(!Setting.isSaveThumbInfo())
			return true;
		if(saveThumbInfo0(client, vtag))
			return true;
		// R~jeBthumbinfoȂ̂smIDg
		if(alternativeTag.isEmpty())
			alternativeTag = client.getAlternativeTag();
		if(alternativeTag.isEmpty() || alternativeTag.equals(Tag))
			return false;
		return saveThumbInfo0(client, alternativeTag);
	}

	private boolean saveThumbUser(Path infoFile, NicoClient client) {
		if(Setting.isSaveThumbUser()){
			sendtext("eҏ̕ۑ");
			Path userThumbFile = null;
			boolean isUser = true;
			String ownerName = null;
			String infoXml = Path.readAllText(infoFile.getPath(), "UTF-8");
			String userID = NicoClient.getXmlElement(infoXml, "user_id");
			String user_nickname = NicoClient.getXmlElement(infoXml, "user_nickname");
			if(userID==null || userID.isEmpty()){
				isUser = false;
				userID = NicoClient.getXmlElement(infoXml, "ch_id");
				ownerName = NicoClient.getXmlElement(infoXml, "ch_name");
				if(userID!=null && !userID.isEmpty())
					userID = "ch"+userID;
				else
					isUser = true;
			}
			if(userID==null || userID.isEmpty() || userID.equals("none")){
				sendtext("e҂̏񂪂܂");
				result = "A5";
				return false;
			}
			log.println("e:"+userID);
			File userFolder = new File(Setting.getUserFolder());
			if (userFolder.mkdirs()){
				log.println("Folder created: " + userFolder.getPath());
			}
			if(!userFolder.isDirectory()){
				sendtext("[U[tH_쐬ł܂");
				result = "A6";
				return false;
			}
			userThumbFile = new Path(userFolder, userID + ".htm");
			String html = null;
			if(isUser){
				if(!userThumbFile.canRead()){
					userThumbFile = client.getThumbUserFile(userID, userFolder);
				}
				if(userThumbFile != null && userThumbFile.canRead()){
					html = Path.readAllText(userThumbFile.getPath(), "UTF-8");
					ownerName = NicoClient.getXmlElement(html, "title");
				}
				if(ownerName == null || ownerName.contains("JvtB[")){
					ownerName = null;
					userThumbFile = client.getUserInfoFile(userID, userFolder);
					if(userThumbFile != null && userThumbFile.canRead()){
						html = Path.readAllText(userThumbFile.getPath(), "UTF-8");
						ownerName = NicoClient.getXmlElement(html, "title");
					}
					if(ownerName==null){
						sendtext("e҂̏̓Ɏs");
						result = "A7";
						if(ownerName==null || ownerName.isEmpty())
							ownerName = user_nickname;
						if(ownerName==null || ownerName.isEmpty())
							ownerName = "e҂̏̓Ɏs";
					//	return false;
					}
				}
				int index = ownerName.lastIndexOf("̃vtB[]");
				if(index > 0){
					ownerName = ownerName.substring(0,index);
				}
				index = ownerName.lastIndexOf("̃[U[y[W ]");
				if(index > 0){
					ownerName = ownerName.substring(0,index) + "(jR|J)";
				}
				if(user_nickname==null || user_nickname.isEmpty())
					infoXml = infoXml.replace("</user_id>",
						"</user_id>\n<user>" + ownerName + "</user>");
			}
			try {
				PrintWriter pw = new PrintWriter(infoFile, "UTF-8");
				pw.write(infoXml);
				pw.flush();
				pw.close();
			} catch (IOException e) {
				log.printStackTrace(e);
				return false;
			}
			sendtext("eҏ̕ۑI");
		}
		return true;
	}

	private boolean setThumbnailJpg() {
		if (isVideoFixFileName()) {
			File folder = Setting.getVideoFixFileNameFolder();
			if (folder.mkdir()) {
				log.println("Folder created: " + folder.getPath());
			}
			if (!folder.isDirectory()) {
				sendtext("TlC摜̕ۑtH_쐬ł܂B");
				result = "A9";
				return false;
			}
			thumbnailJpg = new File(folder, getVideoBaseName() + ".jpg");
		} else {
			File file = Setting.getVideoFile();
			if (file == null || !file.isFile() || file.getPath() == null) {
				thumbnailJpg = mkTemp(Tag + "_thumnail.jpg");
			}else{
				thumbnailJpg = getReplacedExtFile(file, ".jpg");
			}
		}
		return true;
	}

	private boolean saveThumbnailJpg(Path infoFile, NicoClient client) {
		if(Setting.isSaveThumbnailJpg()){
			sendtext("TlC摜̕ۑ");
			thumbnailJpg = null;
			String infoXml = Path.readAllText(infoFile.getPath(), "UTF-8");
			String url = NicoClient.getXmlElement(infoXml, "thumbnail_url");
			if(url==null || url.isEmpty() || !url.startsWith("http")){
				sendtext("TlC摜̏񂪂܂");
				result = "A8";
				return false;
			}
			if(!setThumbnailJpg())
				return false;
			sendtext("TlC摜̕ۑ");
			if (!client.getThumbnailJpg(url+".L", thumbnailJpg)
				&& !client.getThumbnailJpg(url, thumbnailJpg)) {
				sendtext("TlC摜̎擾Ɏs" + client.getExtraError());
				result = "AA";
				return false;
			}
			sendtext("TlC摜̕ۑI");
		}
		return true;
	}

	private File getThumbInfoFileFrom(File file, String ext) {
		if (file == null || file.getPath() == null) {
			return mkTemp(THUMB_INFO + ext);
		}
		return getReplacedExtFile(file, THUMB_INFO + ext);
	}

	private boolean makeNGPattern() {
		sendtext("NGp^[쐬");
		try{
			String all_regex = "/((docomo|iPhone|softbank|device:3DS) (white )?)?.* 18[46]|18[46]( (iPhone|device:3DS))? .*/";
			String def_regex = "/((docomo|iPhone|softbank|device:3DS) (white )?)?18[46]|18[46]( (iPhone|device:3DS))?/";
			String ngWord = Setting.getNG_Word().replaceFirst("^all", all_regex).replace(" all", all_regex);
			ngWord = ngWord.replaceFirst("^default", def_regex).replace(" default", def_regex);
			ngWordPat = NicoXMLReader.makePattern(ngWord, log);
			ngIDPat = NicoXMLReader.makePattern(Setting.getNG_ID(), log);
			ngCmd = new CommandReplace(Setting.getNGCommand(), Setting.getReplaceCommand());
		}catch (Exception e) {
			sendtext("NGp^[쐬ɎsB炭K\̊ԈႢH");
			result = "70";
			return false;
		}
		sendtext("NGp^[쐬I");
		return true;
	}

	private Path mkTemp(String uniq){
		return Path.mkTemp(Tag + uniq);
	}

	private String getRemovedExtName(String path) {
		int index = path.lastIndexOf(".");
		if (index > path.lastIndexOf(File.separator)) {
			path = path.substring(0, index);		// gq폜
		}
		return path;
	}

	private String getReplacedExtName(String path, String ext) {
		return getRemovedExtName(path) + ext;
	}

	private File getReplacedExtFile(File file, String ext){
		return new File(getReplacedExtName(file.getPath(),ext));
	}

	private boolean convertComment(){
		sendtext("Rg̒ԃt@Cւ̕ϊ");
		File folder = Setting.getCommentFixFileNameFolder();
		ArrayList<File> filelist = new ArrayList<File>();
		if (isConvertWithComment()) {
			if (Setting.isAddTimeStamp() && isCommentFixFileName() && !isAppendComment()) {
				// ̃Rgt@CiߋOj邩
				ArrayList<String> pathlist = detectFilelistFromComment(folder);
				if (pathlist == null || pathlist.isEmpty()){
					sendtext(Tag + ": Rgt@CEߋO݂܂B");
					result = "71";
					return false;
				}
				// VideoTitle ͌B
				if (pathlist.size() > 0) {			// 0 1.22r3e8, for NP4 comment ver 2009
					for (String path: pathlist){
						filelist.add(new File(folder, path));
					}
					CommentFile = mkTemp(TMP_COMBINED_XML);
					sendtext("Rgt@C");
					if (!CombineXML.combineXML(filelist, CommentFile)){
						sendtext("Rgt@Co܂łioOHj");
						result = "72";
						return false;
					}
					if (dateUserFirst.isEmpty()) {
						//Rgt@C̍ŏdate="integer"T dateUserFirst ɃZbg
						dateUserFirst = getDateUserFirst(CommentFile);
					}
					listOfCommentFile = filelist;
				} else {
					// Rgt@C͂ЂƂ
					// ɂ͗Ȃ 1.22r3e8, for NP4 comment ver 2009
				}
			}
			if (!isSaveComment()) {
				if (isCommentFixFileName()) {
					if (!Setting.isAddTimeStamp()){
						// Rgt@C͂ЂƂ
						String commentfilename = detectTitleFromComment(folder);
						if(commentfilename == null){
							sendtext("Rgt@CtH_ɑ݂܂B");
							result = "73";
							return false;
						}
						// VideoTitle ͌B
						CommentFile = new File(folder, commentfilename);
						if (!CommentFile.canRead()) {
							sendtext("Rgt@Cǂݍ߂܂B");
							result = "74";
							return false;
						}
						if (dateUserFirst.isEmpty()) {
							//Rgt@C̍ŏdate="integer"T dateUserFirst ɃZbg
							dateUserFirst = getDateUserFirst(CommentFile);
						}
					} else {
						// ς
					}
				} else {
					CommentFile = Setting.getCommentFile();
					if (!CommentFile.exists()) {
						sendtext("Rgt@C݂܂B");
						result = "75";
						return false;
					}
					if (dateUserFirst.isEmpty()) {
						//Rgt@C̍ŏdate="integer"T dateUserFirst ɃZbg
						dateUserFirst = getDateUserFirst(CommentFile);
					}
				}
			}
			//alternativeVideoID擾
			if(alternativeTag.isEmpty()){
				alternativeTag = getViewCounterVideoTag(CommentFile);
			}
			//combine t@C_u폜
			filelist.clear();
			filelist.add(CommentFile);
			CombinedCommentFile = mkTemp(TMP_COMBINED_XML3);
			sendtext("Rgt@C}[W");
			if (!CombineXML.combineXML(filelist, CombinedCommentFile)){
				sendtext("Rgt@C}[Wo܂ł");
				result = "72";
				return false;
			}
			CommentMiddleFile = mkTemp(TMP_COMMENT);
			if(!convertToCommentMiddle(CombinedCommentFile, CommentMiddleFile)){
				sendtext("RgϊɎs");
				CommentMiddleFile = null;
				result = "76";
				return false;
			}
			if(!CommentMiddleFile.canRead()){
				CommentMiddleFile = null;
				// But OK!
			}
		}
		return true;
	}

	private String getViewCounterVideoTag(File comfile) {
		//Rgt@C̍ŏ<view_counter id="..." > ̕Ԃ
		String text = Path.readAllText(comfile, "UTF-8");
		Pattern p = Pattern.compile("<view_counter [^>]+>");
		Matcher m = p.matcher(text);
		String view_counter = "";
		String ret = "";
		while(m.find()){
			view_counter  = m.group() ;
			ret = getRexpFromChats(view_counter, "id=\"([a-zA-Z]+[0-9]+)\"", 1);
			if(!ret.isEmpty())
				return ret;
		}
		return ret;
	}

	private boolean convertOprionalThread(){
		sendtext("IvViXbh̒ԃt@Cւ̕ϊ");
		File folder = Setting.getCommentFixFileNameFolder();
		ArrayList<File> filelist = new ArrayList<File>();
		if (isConvertWithComment()) {
			if (isCommentFixFileName()) {
				if (Setting.isAddTimeStamp() && !isAppendComment()) {
					// tH_w莞ÃIvViXbhiߋOj邩
					ArrayList<String> pathlist = detectFilelistFromOptionalThread(folder);
					if (pathlist == null || pathlist.isEmpty()){
						sendtext(Tag + ": IvViXbhEߋO݂܂B");
						log.println("No optional thread.");
						OptionalThreadFile = null;
						return true;
					}
					// VideoTitle ͌B
					for (String path: pathlist){
						filelist.add(new File(folder, path));
					}
					OptionalThreadFile = mkTemp(TMP_COMBINED_XML2);
					sendtext("IvViXbh");
					if (!CombineXML.combineXML(filelist, OptionalThreadFile)){
						sendtext("IvViXbho܂łioOHj");
						result = "77";
						return false;
					}
					if (dateUserFirst.isEmpty()) {
						//Rgt@C̍ŏdate="integer"T dateUserFirst ɃZbg
						dateUserFirst = getDateUserFirst(OptionalThreadFile);
					}
					listOfCommentFile.addAll(filelist);
				} else {
					// tH_w莞AIvViXbh͂P
					String filename = detectTitleFromOptionalThread(folder);
					if (filename == null || filename.isEmpty()){
						sendtext(Tag + ": IvViXbhtH_ɑ݂܂B");
						log.println("No optional thread.");
						OptionalThreadFile = null;
						return true;
					}
					OptionalThreadFile = new File(folder, filename);
					if (dateUserFirst.isEmpty()) {
						//Rgt@C̍ŏdate="integer"T dateUserFirst ɃZbg
						dateUserFirst = getDateUserFirst(OptionalThreadFile);
					}
				}
			} else {
				// t@Cw̎
				OptionalThreadFile = getOptionalThreadFile(Setting.getCommentFile());
				if (!OptionalThreadFile.exists()){
					sendtext("IvViXbh݂܂B");
					log.println("No optional thread.");
					OptionalThreadFile = null;
					return true;
				}
				if (dateUserFirst.isEmpty()) {
					//Rgt@C̍ŏdate="integer"T dateUserFirst ɃZbg
					dateUserFirst = getDateUserFirst(OptionalThreadFile);
				}
			}
			//combine t@C_u폜
			filelist.clear();
			filelist.add(OptionalThreadFile);
			CombinedOptionalFile = mkTemp(TMP_COMBINED_XML4);
			sendtext("IvViXbh}[W");
			if (!CombineXML.combineXML(filelist, CombinedOptionalFile)){
				sendtext("IvViXbh}[Wo܂ł");
				result = "77";
				return false;
			}
			OptionalMiddleFile = mkTemp(TMP_OPTIONALTHREAD);
			if(!convertToCommentMiddle(CombinedOptionalFile, OptionalMiddleFile)){
				sendtext("IvViXbhϊɎs");
				OptionalMiddleFile = null;
				result = "78";
				return false;
			}
			//Rg
			if(!OptionalMiddleFile.canRead()){
				OptionalMiddleFile = null;
				// But OK!
			}
		}
		return true;
	}

	private boolean convertOwnerComment(){
		sendtext("e҃Rg̒ԃt@Cւ̕ϊ");
		File folder = Setting.getCommentFixFileNameFolder();
		if (isConvertWithOwnerComment()){
			if (!isSaveOwnerComment()) {
				if (isCommentFixFileName()) {
					String ownerfilename = detectTitleFromOwnerComment(folder);
					if(ownerfilename == null){
						sendtext("e҃Rgt@CtH_ɑ݂܂B");
					//	retValue = "80";
					//	return false;
						log.println("e҃Rgt@CtH_ɑ݂܂B");
						OwnerCommentFile = null;
						return true;
					}
					// VideoTitle ͌B
					OwnerCommentFile = new File(folder, ownerfilename);
					if (!OwnerCommentFile.canRead()) {
						sendtext("e҃Rgt@Cǂݍ߂܂B");
						result = "81";
						return false;
					}
				} else {
					OwnerCommentFile = Setting.getOwnerCommentFile();
					if (!OwnerCommentFile.exists()) {
						sendtext("e҃Rgt@C݂܂B");
					//	retValue = "82";
					//	return false;
						log.println("e҃Rgt@C݂܂B");
						OwnerCommentFile = null;
						return true;
					}
				}
			}
			//alternativeVideoID擾
			if(alternativeTag.isEmpty()){
				alternativeTag = getViewCounterVideoTag(OwnerCommentFile);
			}
			OwnerMiddleFile = mkTemp(TMP_OWNERCOMMENT);
			// commentReplace
			if (!convertToCommentMiddle(OwnerCommentFile, OwnerMiddleFile)){
				sendtext("e҃RgϊɎs");
				OwnerMiddleFile = null;
				result = "83";
				return false;
			}
			//Rg
			if(!OwnerMiddleFile.canRead()){
				OwnerMiddleFile = null;
				ownerCommentNum = 0;
				// But OK!
			} else {
				try{
					FileInputStream fos = new FileInputStream(OwnerMiddleFile);
					ownerCommentNum = Util.readInt(fos);
					fos.close();
				} catch (IOException e) {
					log.printStackTrace(e);
					OwnerMiddleFile = null;
					result = "84";
					return false;
				}
			}
		}
		return true;
	}

	private void deleteCommentFile(){
		if (CommentFile != null && CommentFile.delete()) {
			log.println("Deleted: " + CommentFile.getPath());
		}
		if (OptionalThreadFile != null && OptionalThreadFile.delete()){
			log.println("Deleted: " + OptionalThreadFile.getPath());
		}
		deleteList(listOfCommentFile);
		if (OwnerCommentFile != null && OwnerCommentFile.delete()) {
			log.println("Deleted: " + OwnerCommentFile.getPath());
		}
	}

	private boolean convertToCommentMiddle(File commentfile, File middlefile) {
		String duration = "";
		if(Setting.changedLiveOperationDuration())
			duration = Setting.getLiveOperationDuration();
		if(!ConvertToVideoHook.convert(
				commentfile, middlefile, CommentReplaceList,
				ngIDPat, ngWordPat, ngCmd, Setting.getScoreLimit(),
				Setting.isLiveOperationConversion(), Setting.isPremiumColorCheck(),
				duration, log)){
			return false;
		}
		//Rg0̎폜
		try{
			FileInputStream fis = new FileInputStream(middlefile);
			int comment_num = Util.readInt(fis);
			fis.close();
			if(comment_num == 0){
				if(middlefile.delete()){
					log.println("Deleted 0 comment-file: " + middlefile.getPath());
				}
			}
		} catch (IOException e) {
			log.printStackTrace(e);
			return false;
		}
		return true;
	}

	private boolean convertVideo() throws IOException {
		sendtext("̕ϊJn");
		stopwatch.start();
		if(!VideoFile.canRead()){
			sendtext("悪ǂݍ߂܂");
			result = "90";
			return false;
		}
		/*rfI̊m*/
		File folder = Setting.getConvFixFileNameFolder();
		if (!chekAspectVhookOption(VideoFile, wayOfVhook)){
			result = "91";
			return false;
		}
		if (Setting.isConvFixFileName()) {
			if (folder.mkdir()) {
				log.println("Created folder: " + folder.getPath());
			}
			if (!folder.isDirectory()) {
				sendtext("ϊ̕ۑtH_쐬ł܂B");
				result = "92";
				return false;
			}
			String conv_name = VideoTitle;
			if (conv_name == null){
				conv_name = "null";
			}
			if (!Setting.isNotAddVideoID_Conv()||conv_name.isEmpty()) {//tȂ
				conv_name = Setting.isChangeTitleId()?
						VideoTitle + VideoID : VideoID + VideoTitle;
			}
			if (conv_name.isEmpty()) {
				sendtext("ϊ̃^Cg܂(rfIt@Cmł܂)B");
				result = "93";
				return false;
			}

			if (Setting.isAddOption_ConvVideoFile()){
				byte[] dirName = new File(folder, conv_name)
					.getAbsolutePath().getBytes("Shift_JIS");
				// tH_ꍇ
				if (dirName.length > (255-12)){
					conv_name = VideoID;
				}
				conv_name = conv_name.trim();	// In Windows API, cant make dir as " ABC" nor "ABC "
				folder = new File(folder, conv_name);
				if (folder.mkdir()) {
					log.println("Created folder: " + folder.getPath());
				}
				if (!folder.isDirectory()) {
					sendtext("(FFmpegݒ薼)t@C̕ۑtH_쐬ł܂B");
					result = "94";
					return false;
				}
				conv_name = MainOption + InOption + OutOption;
				if (!getFFmpegVfOption().isEmpty()){
					conv_name = vfilter_flag + " " + getFFmpegVfOption() + conv_name;
				}
				conv_name = getFFmpegOptionName() + safeAsciiFileName(conv_name);
				dirName = new File(folder, conv_name).getAbsolutePath().getBytes("Shift_JIS");
				// t@Cꍇ
				if (dirName.length > (255 - 3)){
					int len = conv_name.length() - (dirName.length - (255 - 3));
					if (len < 1){
						sendtext("쐬rfIt@C܂B");
						result = "95";
						return false;
					}
					conv_name = conv_name.substring(0, len);
				}
				conv_name = conv_name.trim();
			}
			conv_name = safeAsciiFileName(conv_name);
			ConvertedVideoFile = new File(folder, conv_name + ExtOption);
		} else {
			String filename = Setting.getConvertedVideoFile().getPath();
			if (!filename.endsWith(ExtOption)) {
				filename = filename.substring(0, filename.lastIndexOf('.'))
						+ ExtOption;
				ConvertedVideoFile = new File(filename);
			} else {
				ConvertedVideoFile = Setting.getConvertedVideoFile();
			}
		}
		if (ConvertedVideoFile.getAbsolutePath().equals(VideoFile.getAbsolutePath())){
			sendtext("ϊ̃t@CϊOƓł");
			result = "96";
			return false;
		}
		if(ConvertedVideoFile.isFile() && ConvertedVideoFile.canRead()){
			sendtext("ϊ̃t@C͊ɑ݂܂");
			log.println("ϊ̃t@C͊ɑ݂܂");
			String otherFilename = "1"+ ConvertedVideoFile.getName();
			if(ConvertedVideoFile.renameTo(new File(ConvertedVideoFile.getParentFile(),otherFilename))){
				sendtext("̃t@Cl[܂");
				log.println("̃t@Cl[܂"+otherFilename);
			}else{
				sendtext("̃t@Cl[o܂łB㏑܂");
				log.println("̃t@Cl[o܂łB㏑܂");
			}
		}
		int code = converting_video();
		stopwatch.stop();
		//vhext(nicovideoO)Rs[
		File log_vhext = new File(".","[log]vhext.txt");
		File video_vhext = Path.mkTemp(Tag+"[log]vhext.txt");
		if(video_vhext.exists()){
			if(log_vhext.delete()){
			}
			Path.fileCopy(video_vhext, log_vhext);
		}else{
			log.println(Tag+"[log]vhext.txt L܂.");
		}
		if (code == 0) {
			sendtext("ϊɏI܂B");
			log.println(lastFrame);
			return true;
		} else if (code == CODE_CONVERTING_ABORTED) { /*f*/
			result = "97";
		} else {
			if(errorLog==null||errorLog.isEmpty())
				if(ffmpeg!=null)
					errorLog = ffmpeg.getLastError().toString();
			sendtext("ϊG[F(" + code + ") "+ getLastError());
			result = ""+code;
		}
		return false;
	}

	private static String safeAsciiFileName(String str) {
		//Windowst@CVXeňAscii
		str = str.replace('/', '_')
			.replace('\\', '_')
			.replace('?', '_')
			.replace('*', '_')
			.replace(':', ';')		//	:(colon) to ;(semi colon)
			.replace('|', '_')
			.replace('\"', '\'')
			.replace('<', '(')
			.replace('>', ')')
//			.replace('.', 'D')		// .(dot) is let there
			.replaceAll(" +", " ")
			.trim();
		return str;
	}

	private boolean canRetry(NicoClient client, Gate gate){
		//Q[gȂȂ烊gC\
		String ecode;
		if(client==null) return false;
		ecode = client.getExtraError();
		if(ecode==null) {
			// illegal error code, cannnot retry
			return false;
		}
		if((ecode.contains("503") || ecode.contains("504"))){
			//	HTTP_UNAVAILABLE  HTTP_GATEWAY_TIMEOUT
			//  T[rXꎞIɉߕ Q[gEFC^CAEg
			// retry count check
			sendtext("gC҂");
			if(gate.notExceedLimiterGate()){
				// can retry
				client.setExtraError("retry,");
				return true;
			}
			sendtext("gCs");
		}
		// not error or other error,cannnot retry
		return false;
	}

	public void abortByCancel(){
		StopFlag.finish();
		StopFlag.setButtonEnabled(false);
		result = "FF";
		sendtext("[FF]Converter cancelled.");
		log.println("LastStatus:[FF]Converter cancelled.");
		sbRet.append("RESULT=[FF]\n");
		errorControl.setError(result,Tag+WatchInfo);
	}

	@Override
	protected String doInBackground() throws Exception {
		log = new Logger(null);
		synchronized (StopFlag) {
			while(StopFlag.isPending()){
				StopFlag.wait();
			}
			if(stopFlagReturn()){
				abortByCancel();
				manager.reqDone(result, StopFlag);
				return "FF";
			}
			StopFlag.start();
		}
	/*
		if(!watchvideo){
			//not watch video get try mylist
			sendtext("oO URLU蕪s");
			log.println("oO URLU蕪s");
			result = "-1";
			return result;
		}
	*/
		log = new Logger(Tag, tid, TMP_LOG_FRONTEND);
		gate = Gate.open(tid,log);
		stopwatch.clear();
		stopwatch.start();
		manager.sendTimeInfo();
		try {
			if(parent!= null){
				Setting = parent.getSetting();
			}
			if (!checkOK()) {
				return result;
			}
			boolean success = false;
			NicoClient client = null;
			if (isSaveVideo() || isSaveComment() || isSaveOwnerComment()
					|| Setting.isSaveThumbInfo()) {
				do{
					client = ConvertManager.getManagerClient(this);
				}while (!stopFlagReturn() && canRetry(client, gate));
			}

			if (client != null){
				if (!client.isLoggedIn()){
					result = "-2";
					return result;
				}
			//	Gate.resetLimit();
				do{
					success = client.getVideoInfo(Tag, WatchInfo, Time, Setting.isSaveWatchPage());
				}while (!success && canRetry(client, gate));
				if (!success) {
					if(Tag==null || Tag.isEmpty()){
						sendtext("URL/ID̎w肪܂ " + client.getExtraError());
					}else if(!client.loginCheck()){
						sendtext("OCs " + BrowserKind.getName() + " " + client.getExtraError());
					}else{
						sendtext(Tag + "̏̎擾Ɏs " + client.getExtraError());
					}
					result = "-3";
					return result;
				}
				if (stopFlagReturn()) {
					return "97";
				}
				VideoTitle = client.getVideoTitle();
				VideoBaseName = Setting.isChangeTitleId()?
					VideoTitle + VideoID : VideoID + VideoTitle;
				sendtext(Tag + "̏̎擾ɐ");
				if(alternativeTag.isEmpty()){
					alternativeTag = client.getAlternativeTag();
				}
			}

			stopwatch.show();
			success = false;
			do{
				success = saveVideo(client);
			}while (!stopFlagReturn() && !success && canRetry(client, gate));
			if(!success) return result;

			stopwatch.show();
			success = false;
			do{
				success = saveComment(client);
			}while (!stopFlagReturn() && !success && canRetry(client, gate));
			if(!success) return result;

			stopwatch.show();
			success = false;
			do{
				success = saveOwnerComment(client);
			}while (!stopFlagReturn() && !success && canRetry(client, gate));
			if(!success) return result;

			stopwatch.show();
			if(!saveThumbInfo(client, Tag)){
				if(isSaveConverted())
					log.println("ǉ̎擾Ɏs܂s܂B");
				else {
					String tstr = gettext();
					if(isSaveComment()) {
						tstr = "Rg擾@" + tstr;
					}
					if(isSaveVideo()) {
						tstr = "擾@" + tstr;
					}
					tstr = "[x]" + tstr;
					sendtext(tstr);
					log.println(tstr);
					return result;
				}
			}
			if(stopFlagReturn()){
				return result;
			}

			stopwatch.show();
			log.println("ϊOԁ@" + stopwatch.formatElapsedTime());

			gate.exit(result);
			manager.sendTimeInfo();
			if (!isSaveConverted()) {
				sendtext("ERgۑAϊ͍s܂łB");
				result = "0";
				return result;
			}

			if(!isConverting){
				manager.incNumConvert();
				isConverting = true;
			}
			stopwatch.show();
			if(!makeNGPattern() || stopFlagReturn()){
				return result;
			}

			stopwatch.show();
			if (!convertOwnerComment() || stopFlagReturn()){
				return result;
			}

			stopwatch.show();
			if (!convertComment() || stopFlagReturn()) {
				return result;
			}

			stopwatch.show();
			if (!convertOprionalThread() || stopFlagReturn()) {
				return result;
			}

			stopwatch.show();
			if (convertVideo()) {
				// ϊ
				result = "0";
				autoPlay.offer(ConvertedVideoFile);
				if (isDeleteCommentAfterConverting())
					deleteCommentFile();
				if (isDeleteVideoAfterConverting())
					deleteFile(VideoFile);
				deleteFile(CommentMiddleFile);
				deleteFile(OwnerMiddleFile);
				deleteFile(OptionalMiddleFile);
				deleteFile(CombinedCommentFile);
				deleteFile(CombinedOptionalFile);
				return result;
			}
		} catch (IOException ex) {
			log.printStackTrace(ex);
			if("0".equals(result))
				result = "EX";
		} finally {
			sbRet.append("RESULT=" + result + "\n");
			if(!dateUserFirst.isEmpty()){
				sbRet.append("DATEUF=" + dateUserFirst + "\n");
			}
			if(!result.equals("0"))
				errorControl.setError(result,Tag+WatchInfo);
			else {
				autoPlay.playAuto();
			}
			synchronized(StopFlag){
				StopFlag.finish();
				StopFlag.setButtonEnabled(false);
			}
			stopwatch.show();
			stopwatch.stop();
			log.println("ϊԁ@" + stopwatch.formatLatency());
			log.println("LastStatus:[" + result + "]" + gettext());
			log.println("VideoInfo: " + MovieInfo.getText());
			log.println("LastFrame: "+ lastFrame);

			SwingUtilities.invokeLater(new Runnable() {
				@Override
				public void run() {
					gate.exit(result);
					if(isConverting){
						manager.decNumConvert();
						isConverting = false;
					}
				}
			});

			//end alarm
			File wav = new File("end.wav");
			if(wav.exists()){
				if(!AudioPlay.playWav(wav)){
					sendtext("wav error");
				};
			}
//			File exe = new File("end.exe");
//			File bat = new File("end.bat");
//			if(bat.exists()){
//				// batch file s
//				CmdExec cmdexec = new CmdExec(bat,ConvertedVideoFile.getAbsolutePath());
//				cmdexec.start();
//			}else if (exe.exists()){
//				// exe file s
//				CmdExec cmdexec = new CmdExec(exe,ConvertedVideoFile.getAbsolutePath());
//				cmdexec.start();
//			}
		}
		return result;
	}

	public void done(){
		if("FF".equals(result)){
			return;
		}
		String retStr = null;
		try {
			retStr = get();
		} catch (InterruptedException | ExecutionException e) {
			log.printStackTrace(e);
		}
		manager.reqDone(result, StopFlag);
		manager.sendTimeInfo();
		if(retStr == null)
			log.println("ConvertWorker#done.ret==null. ConvertWorker might had Exception!");
		else {
			System.out.println("["+retStr+"]Converter.done! "+Tag);
			if(result.equals("0") && !isDebugNet)
				log.deleteLog();
		}
	}

	private void deleteList(ArrayList<File> list){
		if (list== null || list.isEmpty())
			return;
		log.print("Deleted: ");
		for (File file : list){
			if(file.delete())
				log.print(file.getName()+" ");
		}
		log.println("done.");
	}
	private void deleteFile(File file){
		if (file != null && file.canWrite()
		 && file.delete())
			log.println("Deleted: " + file.getPath());
	}

	/**
	 * CWSȂFWSɕϊ<br/>
	 * ̌AAXyNg𔻒肵VhookIAIvVǂݍݐݒ肷
	 * @param video : File
	 * @param way : int  1 or 2
	 * Output videoAspect : Aspect
	 * Output VideoFile : File
	 * Output selectedVhook : File  vhook.exe
	 * OUTPUT ExtOption, MainOption, InOption, OutOption
	 */
	private boolean chekAspectVhookOption(File video, int way){
		fwsFile = null;
		try {
			fwsFile = Cws2Fws.createFws(video);
		} catch (Exception e) {
			log.printStackTrace(e);
		}
		if (fwsFile != null){
//			VideoFile = fwsFile;
			video = fwsFile;
		}else{
			if (Cws2Fws.isCws(video)){
				sendtext("SWFFWSϊɎs܂");
				//return false;
			}
		}
		VideofileInfo info = new VideofileInfo(video, ffmpeg, Status, StopFlag, stopwatch, log);
		videoAspect = info.getAspect();
		if(videoLength <= 0){
			videoLength = info.getDuration();
		}
		frameRate = info.getFrameRate();
		checkFps = Setting.enableCheckFps();
		fpsUp = Setting.getFpsUp();
		fpsMin = Setting.getFpsMin();
		log.println("frameRate:"+frameRate+",fpsUp:"+fpsUp+",fpsMin:"+fpsMin);
		String str;
		if (videoAspect == null || videoAspect == Aspect.ERROR){
			str = "Analize Error   ";
			videoAspect = Aspect.NORMAL;
		} else {
			str = videoAspect.explain() + "  ";
		}
		isPlayerWide = videoAspect.isWide();
		if (Setting.isZqPlayer()){
			//
		} else {
			if (way == 1){
				if (VhookNormal == null){
					if (!isPlayerWide){
						str = "" + str;
					}
					isPlayerWide = true;
				} else {
					if (isPlayerWide){
						str = "" + str;
					}
					isPlayerWide = false;
				}
			}
		}
		String auto = "";
		if (way==3){
			auto = "";
		}
		if (way==2) {
			auto = "I ";
		}
		if (Setting.isZqPlayer()){
			selectedVhook = VhookQ;
			MovieInfo.setText(auto + "gVhook Q " + str);
		} else if (isPlayerWide){
			selectedVhook = VhookWide;
			MovieInfo.setText(auto + "gVhook Ch " + str);
		} else {
			selectedVhook = VhookNormal;
			MovieInfo.setText(auto + "gVhook ] " + str);
		}
		if (!detectOption(isPlayerWide,Setting.isZqPlayer())){
			sendtext("ϊIvVt@C̓ǂݍ݂Ɏs܂B");
			return false;
		}
		if(!addAdditionalOption(isPlayerWide,Setting.isZqPlayer())){
			sendtext("ǉIvV̐ݒɎs܂B");
			return false;
		}

		//replace`FbN
		if(Setting.getReplaceOptions()!=null){
			replace3option(Setting.getReplaceOptions());
		}
		ffmpegVfOption = getvfOption();

		//AAC copy if -aacp set
		if(getAacCopyFlag()){
			if(info.isAudioContainsAac()){
				String[] ac;
				LinkedHashMap<String,String> optmap = outputOptionMap;
				if(getAudioCodecKV(optmap)==null){
					optmap = mainOptionMap;
				}
				if(((ac = getAudioCodecKV(optmap))!=null) && (ac[1].contains("aac"))){
					replaceOption(optmap,ac[0],"copy");
					log.println("Changed: "+ac[0]+" "+ac[1]+" -> copy");
				}
			}
		}
		//AAC-LC copy if -alcp set
		if(getAacLcCopyFlag()){
			if(info.isAudioContainsAacLc()){
				String[] ac;
				LinkedHashMap<String,String> optmap = outputOptionMap;
				if(getAudioCodecKV(optmap)==null){
					optmap = mainOptionMap;
				}
				if(((ac = getAudioCodecKV(optmap))!=null) && (ac[1].contains("aac")) && !ac[1].contains("he")){
					replaceOption(optmap,ac[0],"copy");
					log.println("Changed: "+ac[0]+" "+ac[1]+" -> copy");
				}
			}
		}

		inSize = videoAspect.getSize();
		setSize = getSetSize();	//videoSetSize="width"x"height"
		padOption = getPadOption();		//padOption=width:height:x:y
		outSize = getOutSize();
		outAspect = videoAspect;
		if (setSize != null){
			//setSize=width:height in -s WIDTHxHEIGHT
			outAspect = toAspect(setSize,outAspect);
		}
		if (outSize != null){
			//outSize=width:height in -vf outs=w:h
			outAspect = toAspect(outSize, outAspect);
			setSize = outSize;
			printOutputSize(setSize,outAspect);
			outputOptionMap.put("-s", setSize.replace(':', 'x'));
			return true;
		}
		if (getSameAspectMaxFlag()){
			//Outoption contains "-samx"
			//check and set outAspect & setSize to be same as input video
			if(!outAspect.equals(videoAspect)){
				double out_aspect = outAspect.getValue();
				int outw = outAspect.getWidth();
				int outh = outAspect.getHeight();
				double video_aspect = videoAspect.getValue();
				if(out_aspect < video_aspect){
					// ow / oh < w / h -> oh ύX
					outh = toMod4(outw / video_aspect);
				}else if(out_aspect > video_aspect){
					// ow / oh > w / h -> ow ύX
					outw = toMod2(outh * video_aspect);
				}
				outAspect = new Aspect(outw, outh);
				setSize = outAspect.getSize();
				printOutputSize(setSize,outAspect);
				outputOptionMap.put("-s", setSize.replace(':', 'x'));
				return true;
			}
		}
		if (padOption != null){
			//padOption=width:height:videox:videoy in -vf pad=w:h:x:y
			printOutputSize(padOption,outAspect);
			printOutputSize(inSize,outAspect);
		}else
		if (setSize != null){
			//setSize=width:height in -s WIDTHxHEIGHT
			printOutputSize(setSize,outAspect);
		} else {
			//inSize=width:height
			printOutputSize(inSize,outAspect);
		}
		// ropt
		String ropt = getRopt();
		if(!ropt.isEmpty()){
			log.println(" framerate="+ropt);
		}
		return true;
	}

	void printOutputSize(String sizestr, Aspect aspect){
		int commentWidth = 640;		//h
		int commentHeight = 384;	//h
		if(Setting.isZqPlayer()){
			commentWidth = 800;		//Qwatch
			commentHeight = 480;
		}
		aspect = toAspect(sizestr, aspect);
		int width = aspect.getWidth();
		int height = aspect.getHeight();
		log.println("Output Video Area " + width + ":" + height);
		//width height͏ȏ͓傫(outsw莞͂̃TCY)
		log.println("Video "+aspect.getSize());
		double rate;
		if (Setting.isZqPlayer()){
			if(aspect.isQWide()){
				rate = (double)width / commentWidth;
				height = toMod4(commentHeight * rate);
			}else{
				rate = (double)height / commentHeight;
				width = toMod2(commentWidth * rate);
			}
		} else {
			if(isPlayerWide){
				rate = (double)width / commentWidth;
				height = toMod4(commentHeight * rate);
			}else{
				rate = (double)height / commentHeight;
				width = toMod2(commentWidth * rate);
			}
		}
		log.println("Output Commetnt Area " + width + ":" + height + " Wide? " + isPlayerWide);
		//width height͏o̓Rg̑傫i͂ݏoȂj
		return;
	}

	private int toMod4(double d){
		return ((int)(d / 4.0 + 0.5)) * 4;
	}

	private int toMod2(double d){
		return ((int)(d / 2.0 + 0.5)) * 2;
	}

	private Aspect toAspect(String str,Aspect defaultAspect){
		String[] list = str.split(":");
		int width = defaultAspect.getWidth();
		if(list.length>=1 && !list[0].equals("0")){
			try {
				width = Integer.parseInt(list[0]);
			} catch (NumberFormatException e){
				log.printStackTrace(e);
			}
		}
		int height = defaultAspect.getHeight();
		if(list.length>=2 && !list[1].equals("0")){
			try {
				height = Integer.parseInt(list[1]);
			} catch(NumberFormatException e){
				log.printStackTrace(e);
			}
		}
		return new Aspect(width, height);
	}
	private String getSetSize(){
		String size = outputOptionMap.get("-s");
		if(size!=null && size.contains("x"))
			return size.replace('x', ':');
		return null;
	}
	private String getPadOption() {
		return getFromVfOpotion("pad=");
	}

	private String getOutSize(){
		//outSize=width:height in -vf outs=w:h
		String outs = getFromVfOpotion("outs=");
		String outs_str = "outs=" + outs;
		if(outs != null){
			if((outs_str).equals(getFFmpegVfOption())){
				setFfmpegVfOption("");
			} else if(getvfOption().startsWith(outs_str)){
				setFfmpegVfOption(getFFmpegVfOption().replace(outs_str + ",", ""));
			} else {
				setFfmpegVfOption(getFFmpegVfOption().replace("," + outs_str, ""));
			}
		}
		return outs;
	}
	private boolean getSameAspectMaxFlag(){
		//-samx
		return outputOptionMap.remove("-samx") != null;
	}
	private boolean getAacCopyFlag(){
		//-aacp
		return outputOptionMap.remove("-aacp") != null;
	}
	private boolean getAacLcCopyFlag(){
		//-alcp
		return outputOptionMap.remove("-alcp") != null;
	}
	private String[] getAudioCodecKV(HashMap<String,String> map){
		String[] pair = new String[2];
		String value = "";
		String[] keys = {"-acodec","-codec:a","-c:a"};
		for (String key:keys){
			value = map.get(key);
			if(value!=null){
				pair[0] = key;
				pair[1] = value.toLowerCase();
				return pair;
			}
		}
		return null;
	}
	private boolean replaceOption(HashMap<String, String> map, String key, String value){
		if(map.containsKey(key)){
			map.put(key, value);
			return true;
		}
		return false;
	}
	private String getRopt(){
		//-r or -r:v
		String value = "-r";
		value = outputOptionMap.get("-r");
		if(value==null)
			value = mainOptionMap.get("-r");
		if(value==null)
			value = outputOptionMap.get("-r:v");
		if(value==null)
			value = mainOptionMap.get("-r:v");
		if(value==null)
			value = "";
		return value;
	}

	private String getFromVfOpotion(String prefix){
		for(String arg: getFFmpegVfOption().split(",")){
			if(arg.startsWith(prefix)){
				return arg.substring(prefix.length());
			}
		}
		return null;
	}

	boolean addAdditionalOption(boolean wide, boolean isQ) {
		addOption = "";
		if(isQ){
			addOption = Setting.getZqAddOption();
		} else if(wide){
			addOption = Setting.getWideAddOption();
		}else{
			addOption = Setting.getAddOption();
		}
		if(addOption.isEmpty()){
			return true;
		}
		setOptionMap(addOption, addOptionMap);
//		dlύX MainOpt InOpt͒uȂ
		for(String key : addOptionMap.keySet())
			outputOptionMap.put(key, addOptionMap.get(key));
		return true;
	}

	private static final int CODE_CONVERTING_ABORTED = 100;

	private void setOption1(File infile){
		ffmpeg.setCmd("-y ");
		ffmpeg.addMap(mainOptionMap);
		ffmpeg.addCmd(" ");
		ffmpeg.addMap(inputOptionMap);
		ffmpeg.addCmd(" -i ");
		ffmpeg.addFile(infile);
		ffmpeg.addCmd(" ");
	}

	private void setOption2(){
		ffmpeg.addCmd(" ");
		ffmpeg.addMap(outputOptionMap);
		ffmpeg.addCmd(" -metadata");
		ffmpeg.addCmd(" \"title="+VideoTitle+"\"");
		ffmpeg.addCmd(" -metadata");
		ffmpeg.addCmd(" \"comment="+"["+alternativeTag+"]"+"\"");
		ffmpeg.addCmd(" ");
	}

	private boolean setOption3(File outfile){
		if (!Setting.isVhookDisabled()) {
			if(!addVhookSetting(ffmpeg, selectedVhook, isPlayerWide)){
				return false;
			}
		} else {
			ffmpeg.addCmd(" "+vfilter_flag+" ");
			ffmpeg.addCmd(getFFmpegVfOption());
		}
		ffmpeg.addCmd(" ");
		ffmpeg.addFile(outfile);
		return true;
	}

	private int execOption(){
		int code;
		log.println("arg:" + ffmpeg.getCmd());
		code = ffmpeg.exec(Status, CODE_CONVERTING_ABORTED, StopFlag, stopwatch, log);
		errorLog = ffmpeg.getErrotLog().toString();
		lastFrame = ffmpeg.getLastFrame();
		return code;
	}

	private int convFLV(File videoin, File videoout){
		int code = -1;
		setOption1(videoin);
		setOption2();
		if(!setOption3(videoout))
			return code;
		code = execOption();
		return code;
	}

	private int conv_fpsUp(File videoin, File videoout){
		int code = -1;
		/*
		 * ffmpeg -r fpsUp
		 */
		setOption1(videoin);
		ffmpeg.addCmd(" -r " + fpsUp);
		String out_option_t = outputOptionMap.get("-t");
		if(out_option_t!=null)
			ffmpeg.addCmd(" -t "+out_option_t);
		String out_option_ss = outputOptionMap.get("-ss");
		if(out_option_ss!=null)
			ffmpeg.addCmd(" -ss "+out_option_ss);
		ffmpeg.addCmd(ConvertingSetting.getDefOptsFpsUp());
		// -acodec copy -vsync 1 -vcodec libx264 -qscale 1 -f mp4
		ffmpeg.addFile(videoout);

		code = execOption();
		if(code==0){
			// -itsoffset폜 sς
			inputOptionMap.remove("-itsoffset");
			mainOptionMap.remove("-itsoffset");
			// -ss폜  sς
			inputOptionMap.remove("-ss");
			mainOptionMap.remove("-ss");
			// out -ss ͂̂܂܎c
			out_option_ss = outputOptionMap.get("-ss");
			if(out_option_ss!=null){
				// o͂-itsoffset -ssɂ
				inputOptionMap.put("-itsoffset", out_option_ss);
			}
			// -t ͂̂܂܎cėǂ
		}
		return code;
	}

	private int convSWF_JPG(File videoin, File videoout){
		int code = -1;
		//o
		ffmpeg.setCmd("-y -i ");
		ffmpeg.addFile(videoin);
		ffmpeg.addCmd(ConvertingSetting.getDefOptsSwfJpeg());
		// -an -vcodec copy -r 1 -f image2
		ffmpeg.addFile(videoout);
		code = execOption();
		return code;
	}

	private int convJPG_MP4(File videoin, File videoout){
		int code = -1;
		//
		// frame check
		//
		// JPG֑ؑxw肷?
		String frames = ffmpeg.getLastFrame();
		int frame = 0;
		int index = frames.indexOf("frame=");
		if(index >=0){
			frames = frames.substring(index+6).trim();
			index = (frames+" ").indexOf(" ");
			frames = frames.substring(0, index);
			try{
				frame = Integer.decode(frames);
			}catch(NumberFormatException e){
				frame = 0;
			}
		}
		if(frame == 0)
			frame = 1;
		double rate = 1.0;
		if(videoLength > 0 && frame > 1){
			rate = (double)frame / (double)videoLength;
		}
		log.printf("Frame= %d, Rate= %.5f(fps)\n", frame, rate);
		String out_t = outputOptionMap.get("-t");
		double t0 = 0.0;
		if(out_t!=null){
			try{
				t0 = Double.parseDouble(out_t);
			}catch(NumberFormatException e){
				t0 = 0.0;
			}
		}
		double tl = (double)videoLength;
		if(tl == 0.0)
			tl = t0;
		else if(t0 != 0.0)
			tl = Math.min(t0, tl);
		// tl==0(Ȃ) ܂ tl͍ŏ
		double length_frame = 1.0 /rate;
		log.printf("Frame= %.2f(sec/frame), Rate= %.5f(fps)\n", length_frame, rate);
	//	if(tl != 0.0){
	//		tl += length_frame;
	//	}
		log.printf("Frame= %d, Rate= %.5f(fps)\n", frame, rate);

		//File outputAvi = new File(imgDir,"huffyuv.avi");
		ffmpeg.setCmd(" -loop 1 -r " + Double.toString(rate));
		ffmpeg.addCmd(" -itsoffset " + Double.toString(length_frame));
		ffmpeg.addCmd(" -y -i ");
		ffmpeg.addFile(videoin);
		ffmpeg.addCmd(" -shortest ");
		if(tl!=0.0)
			ffmpeg.addCmd(" -t " + tl);
		ffmpeg.addCmd(ConvertingSetting.getDefOptsJpegMp4());
		// -an -vcodec libx264 -qscale 1 -pix_fmt yuv420p -f mp4
		ffmpeg.addFile(videoout);
		code = execOption();
		return code;
	}

	private int convMix(File videoin, File audioin, File videoout){
		int code = -1;
		double fps = 25.0;
		if(checkFps && fps < fpsMin){
			fps = fpsUp;
		}
		/*
		 * 
		 * ffmpeg.exe -shortest -y -i fws_tmp.swf -itsoffset 1.0 -i avi4.avi
		 *  -vcodec libxvid -acodec libmp3lame -ab 128k -ar 44100 -ac 2 fwsmp4.avi
		 */
		ffmpeg.setCmd("-y -i ");
		ffmpeg.addFile(audioin);	// audio, must be FWS_SWF
		ffmpeg.addCmd(" -i ");
		ffmpeg.addFile(videoin);	// visual
		ffmpeg.addCmd(" -map 1:v -map 0:a ");
		String out_option_t = outputOptionMap.get("-t");
		if(out_option_t!=null)
			ffmpeg.addCmd(" -t "+out_option_t);
		ffmpeg.addCmd(" -r " + fps);
		ffmpeg.addCmd(ConvertingSetting.getDefOptsMix());
		// -acodec copy -vcodec libx264 -qscale 1 -pix_fmt yuv420p -f mp4
		ffmpeg.addFile(videoout);
		code = execOption();
		return code;
	}

	private int convFLV_audio(File input, File output){
		return convFLV_audio(input,output,".\\bin\\b32.jpg");
	}

	private int convFLV_audio(File input, File output, String thumbname) {
		int code = -1;
		File thumbfile;
		if(thumbname==null||thumbname.isEmpty()||thumbname.equals(MainFrame.THUMB_DEFALT_STRING)){
			//TlCI,
			thumbfile = new File(Setting.getVideoFixFileNameFolder(),getVideoBaseName()+".jpg");
			if(!thumbfile.isFile()){
				if(setThumbnailJpg()){
					if(thumbnailJpg!=null && thumbnailJpg.isFile()){
						thumbfile = thumbnailJpg;
					}else{
						thumbfile = new File(".\\bin\\b32.jpg");
					}
				}else {
					NicoClient client = ConvertManager.getManagerClient(this);
					if(thumbInfoFile==null || !thumbInfoFile.canRead())
						saveThumbInfo0(client, Tag);
					if(saveThumbnailJpg(thumbInfo, client)){
						thumbfile = thumbnailJpg;
					}
				}
			}
		}else{
			String currect_dir = System.getenv("CD");
			log.println("CD:"+currect_dir);
			thumbfile = new File(currect_dir, thumbname);
		}
		if(!thumbfile.canRead()){
			log.println("TlCǂ߂܂F"+thumbfile.getPath());
			sendtext("TlCǂ߂܂");
			thumbfile = new Path(".\\bin\\b32.jpg");
		}else{
			// TlCe|[ɃRs[ijava͓ǂ߂̂ɂȂffmpegǂ߂Ȃ̂Łj
			File tempthumb = Path.mkTemp("t.jpg");
			FileInputStream fis = null;
			FileOutputStream fos = null;
			boolean copyok = false;
			try{
				byte[] buf = new byte[4096];
				fis = new FileInputStream(thumbfile);
				fos = new FileOutputStream(tempthumb);
				int len = 0;
				while ((len = fis.read(buf, 0, buf.length)) > 0) {
					fos.write(buf, 0, len);
					stopwatch.show();
				}
				copyok = true;
			}catch(IOException e){
				log.printStackTrace(e);
			}finally{
				try{
					if(fis!=null){
						fis.close();
					}
					if(fos!=null){
						fos.flush();
						fos.close();
					}
				}catch(Exception e){
				}
			}
			if(copyok){
				thumbfile = tempthumb;
			}
		}
		if(!thumbfile.canRead()){
			//ǂĂǂ߂Ȃꍇ
			log.println("TlCǂ߂܂F"+thumbfile.getPath());
			sendtext("փTlCǂ߂܂");
			errorLog = "փTlCǂ߂܂";
			code = 198;
			return code;
		}
		code = convFLV_thumbaudio(thumbfile, input, output);
		return code;
	}

	private int convFLV_thumbaudio(File thumbin, File audioin, File videoout){
		int code = -1;
		// TlC̃AXyNg͖
		/*
		 * ffmpeg -y mainoption -loop 1 -shortest -i thmbnail_picture -i input
		 * outoption -map 0:0 -map 1:a [vhookOption]  output
		 */
		double fps = 25.0;
		if(checkFps && fps < fpsMin)
			fps = fpsUp;
		ffmpeg.setCmd("-y ");
		ffmpeg.addMap(mainOptionMap);
		ffmpeg.addCmd(" -loop 1 -i ");
		ffmpeg.addFile(thumbin);
		ffmpeg.addCmd(" ");
		ffmpeg.addMap(inputOptionMap);
		ffmpeg.addCmd(" -i ");
		ffmpeg.addFile(audioin);
		ffmpeg.addCmd(" -map 0:v -map 1:a ");
		ffmpeg.addCmd(" -r " + fpsUp);
		setOption2();
		if(!setOption3(videoout))
			return code;
		code = execOption();
		return code;
	}

	private int converting_video() {
		int code = -1;
		infoStack = new InfoStack(MovieInfo);
		File input = VideoFile;
		if(alternativeTag.isEmpty()){
			alternativeTag = Tag;
		}
		if(fwsFile!=null)
			input = fwsFile;
		if (!Cws2Fws.isFws(input) && !Cws2Fws.isCws(input)) {
			//ʏFLV
			// fps up check
			if(checkFps && frameRate < fpsMin){
				//FPSϊKv
				if(Setting.isUseFpsFilter()){
					//FPS FilterI
					log.println("FPS filter");
					String vfoptsave = getFFmpegVfOption();
					String vfopt = "fps=fps="+fpsUp
						+ ",scale="+outAspect.getSize();	// -s IvV -vf scale=w:h ƂĐɒǉ
					if(!vfoptsave.isEmpty()){
						vfopt += "," + vfoptsave;
					}
					setFfmpegVfOption(vfopt);
					/*
					 * ffmpeg.exe -y mainoption inoption -i infile outoptiont -vf fps=fps=fpsUP [vhookOption] outfile
					 */
					infoStack.pushText("Filter");
					code = convFLV(input, ConvertedVideoFile);
					infoStack.popText();
					setFfmpegVfOption(vfoptsave);
					if(code == CODE_CONVERTING_ABORTED){
						return code;
					}
					if (code == 0){
						//fpsfilterϊ
						return code;
					}
					log.println("("+code+")fps filterɎs ");
					errorLog += "\nfps filterɎs "+ getLastError();
					log.println("s\n");	//s[h
				}

				// 2pXFPSϊ
				File outputFps = Path.mkTemp("fpsUp"+ConvertedVideoFile.getName());
				log.println("FLV Up "+fpsUp+"fps");
				infoStack.pushText("FLV "+fpsUp);
				code = conv_fpsUp(input, outputFps);
				infoStack.popText();
				if(code == CODE_CONVERTING_ABORTED){
					return code;
				}
				if(code != 0){
					//error
					log.println("("+code+")fpsϊɎs ");
					errorLog += "\nfpsϊɎs "+ getLastError();
					if(Setting.canSoundOnly()){
						log.println("RgƉ܂");
						infoStack.pushText("SoundOnly");
						code = convFLV_audio(input, ConvertedVideoFile, Setting.getDefaultThumbnail());
						infoStack.popText();
					}
					return code;
				}
				if (code == 0){
					//fpsϊ
					input = outputFps;
				}
			}

			//FPSϊȂ
			/*
			 * ffmpeg.exe -y mainoption inoption -i infile outoptiont [vhookOption] outfile
			 */
			log.println("FLV ]ʂ");
			String vfoptsave = getFFmpegVfOption();
			if(checkFps && Setting.isUseFpsFilter()){
				String vfopt = "";
				String ropt = getRopt();
				if(ropt != null && !ropt.isEmpty()){
					vfopt = "fps=fps="+ropt
						+ ",scale="+outAspect.getSize();
					// -s IvV -vf scale=w:h ƂĐɒǉ
					log.println("FPS filter -r "+ropt);
					if(!vfoptsave.isEmpty()){
						vfopt += "," + vfoptsave;
					}
					setFfmpegVfOption(vfopt);
				}
			}
			code = convFLV(input, ConvertedVideoFile);
			infoStack.popText();
			setFfmpegVfOption(vfoptsave);
		}
		else {
			// nm FWS
			if(!Setting.isSwfTo3Path()){
				// nmΉȂ
				if(checkFps && frameRate < fpsMin){
					/*
					 * ffmpeg -r 25.0
					 */
					File outputFps = Path.mkTemp("fpsUp"+ConvertedVideoFile.getName());
					log.println("FWS fpsUp");
					infoStack.pushText("FWS fpsUp");
					code = conv_fpsUp(input, outputFps);
					infoStack.popText();
					if(code == CODE_CONVERTING_ABORTED){
						return code;
					}
					if (code != 0){
						log.println("("+code+")fpsϊɎs ");
						errorLog += "\nfpsϊɎs "+ getLastError();
						if(Setting.canSoundOnly()){
							log.println("RgƉ܂");
							infoStack.pushText("SoundOnly");
							code = convFLV_audio(input, ConvertedVideoFile, Setting.getDefaultThumbnail());
							infoStack.popText();
						}
						return code;
					}else{
						//fpsϊ
						input = outputFps;
					}
				}

				/*
				 * ffmpeg.exe -y mainoption inoption -i infile outoptiont [vhookOption] outfile
				 */
				log.println("FWS ]ʂ");
				infoStack.pushText("FWS");
				code = convFLV(input, ConvertedVideoFile);
				infoStack.popText();
				return code;
			} else {
				log.println("FWS 3path");
				// try 3 path
				/*
				 * SWFt@CJPEG`ɍ
				 * ffmpeg.exe -y -i fws_tmp.swf -an -vcodec copy -f image2 %03d.jpg
				 */
				//o͐
				imgDir = Path.mkTemp("IMG"+VideoID);
				if(imgDir.mkdir())
					log.println("Created folder - " + imgDir);
				File outputImg = new File(imgDir,"%03d.jpeg");
				log.println("outputImg="+outputImg);
				log.println("Tring SWF to .number.JPG");
				infoStack.pushText("SWF->JPG");
				code = convSWF_JPG(input, outputImg);
				infoStack.popText();
				if(code == CODE_CONVERTING_ABORTED){
					return code;
				}
				if(code!=0){
					if (Setting.canSoundOnly()){
						// jpegɕϊłȂꍇ͉݂̂ɂ
						code = convFLV_audio(input, ConvertedVideoFile);
					}
					return code;
				}
				/*
				 * JPEGt@CMP4`ɍ
				 * ffmpeg.exe -r 1/4 -y -i %03d.jpg -an -vcodec huffyuv -f avi huffjpg.avi
				 */
				//o
				File outputAvi = new File(imgDir,"huffyuv.mp4");
				log.println("outputImg="+outputImg);
				log.println("outputAvi="+outputAvi);
				log.println("Tring JPG to .MP4");
				infoStack.pushText("JPG->MP4");
				code = convJPG_MP4(outputImg, outputAvi);
				infoStack.popText();
				if(code == CODE_CONVERTING_ABORTED){
					return code;
				}
				if(code!=0){
					if (Setting.canSoundOnly()){
						// jpegmp4ɕϊłȂꍇ͉݂̂ɂ
						code = convFLV_audio(input, ConvertedVideoFile);
					}
					return code;
				}
				/*
				 * 
				 * ffmpeg.exe -y -i fws_tmp.swf -itsoffset 1.0 -i avi4.avi
				 *  -vcodec libxvid -acodec libmp3lame -ab 128k -ar 44100 -ac 2 fwsmp4.avi
				 */
				File outputMix = new File(imgDir,"mix.mp4");
				log.println("Tring MP4+sound to .MP4");
				infoStack.pushText("MP4 Mix");
				code = convMix(outputAvi, input, outputMix);
				infoStack.popText();
				if(code == CODE_CONVERTING_ABORTED){
					return code;
				}
				if(code!=0){
					if (Setting.canSoundOnly()){
						code = convFLV_audio(input, ConvertedVideoFile);
					}
					return code;
				}
				/*
				 * Rg
				 * ffmpeg.exe -y -i fws_tmp.swf -itsoffset 1.0 -i avi4.avi
				 *  -vcodec libxvid -acodec libmp3lame -ab 128k -ar 44100 -ac 2 fwsmp4.avi
				 */
				log.println("Tring MIX & comment to .mp4");
				infoStack.pushText("FWS comment");
				code = convFLV(outputMix,ConvertedVideoFile);
				infoStack.popText();
				if(code!=0){
					if (Setting.canSoundOnly()){
						code = convFLV_audio(input, ConvertedVideoFile);
					}
					return code;
				}
			}
			if (fwsFile != null){
				// fwsFile.delete();	// For DEBUG
			}
		}
		return code;
	}

	private boolean addVhookSetting(FFmpeg ffmpeg, File vhookExe, boolean isWide){
		FFmpeg ffmpeg1 = new FFmpeg("#");
		ffmpeg1.setCmd(" ");
		if(!addVhookSetting2014(ffmpeg1, vhookExe, isWide)){
			return false;
		}
		Iterator<String> it = ffmpeg1.getCmdArrayList().iterator();
		// ffmpeg1ɐݒ肳ꂽoiterator
		StringBuilder sb = new StringBuilder();
		String s = "";
		it.next();	//ŏ͓ǂݔ΂
		while(it.hasNext()){
			s = it.next();
			s = s.replaceAll(VFILTER_FLAG, VFILTER_FLAG2);
			if(s.equals(VFILTER_FLAG2)){
				sb.append(" "+vfilter_flag+" ");
				s = it.next();
				int index = s.indexOf("vhext=");
				if(index > 0){
					index += "vhext=".length();
					sb.append(s.substring(0, index));
					s = s.substring(index);
					s = vf_quote(s);	// vhext= ̃IvV video filterp quote
				}else{
					return false;
				}
			}
			sb.append(s);
			sb.append(' ');
		}
		s = sb.substring(0);
		ffmpeg.addCmd(s);
		return true;
	}

	/*
	 *  Character escape convention
	 *  1st File or path	'\'-> '/'			(Path.toUnixPath)
	 *  2nd String Encode	Unicode->ShiftJis	(URLEncoder)
	 *  3rd Filter Quote	,:;[\]				(See below)
	 */
	private String vf_quote(String s) {
		String r = s
				.replaceAll(",", "%2C")
				.replaceAll(":", "%3A")
				.replaceAll(";", "%3B")
				.replaceAll("=", "%3D")
				.replaceAll("\\[", "%5B")
				.replaceAll("\\\\", "%5C")
				.replaceAll("\\]", "%5D");
		return r;
	}

	private boolean addVhookSetting2014(FFmpeg ffmpeg, File vhookExe, boolean isWide) {
		try {
			String encoding = "Shift_JIS";
			ffmpeg.addCmd(" "+vfilter_flag+" \"");
			if (!getFFmpegVfOption().isEmpty()){
				ffmpeg.addCmd(getFFmpegVfOption());
				ffmpeg.addCmd(",");
			}else{
				// -s IvV -vf scale=w:h ƂĐɒǉ
				ffmpeg.addCmd("scale="+outAspect.getSize());
				ffmpeg.addCmd(",");
			}
			ffmpeg.addCmd("vhext=");
			ffmpeg.addFile(vhookExe);
			if(CommentMiddleFile!=null){
				ffmpeg.addCmd("|--data-user:");
				ffmpeg.addCmd(URLEncoder.encode(
					Path.toUnixPath(CommentMiddleFile), encoding));
				ffmpeg.addCmd("|--show-user:");
				ffmpeg.addCmd(Setting.getVideoShowNum());
			}
			if(OwnerMiddleFile!=null){
				ffmpeg.addCmd("|--data-owner:");
				ffmpeg.addCmd(URLEncoder.encode(
					Path.toUnixPath(OwnerMiddleFile), encoding));
				int usershowcomment = 0;
				try {
				usershowcomment = Integer.parseInt(Setting.getVideoShowNum());
				} catch (NumberFormatException e1){
					usershowcomment = 0;
				}
				int ownershowcomment = Integer.parseInt(NicoClient.STR_OWNER_COMMENT);
				if(ownershowcomment > ownerCommentNum){
					ownershowcomment = ownerCommentNum;
				}
				if(usershowcomment > 0 && usershowcomment < ownershowcomment){
					ownershowcomment = usershowcomment;
				}
				ffmpeg.addCmd("|--show-owner:" + ownershowcomment);
			}
			if (OptionalMiddleFile!=null){
				ffmpeg.addCmd("|--data-optional:");
				ffmpeg.addCmd(URLEncoder.encode(
					Path.toUnixPath(OptionalMiddleFile), encoding));
				ffmpeg.addCmd("|--show-optional:");
				ffmpeg.addCmd(Setting.getVideoShowNum());
				if (Setting.isOptionalTranslucent()) {
					ffmpeg.addCmd("|--optional-translucent");
				}
			}
			if(Setting.getFontPath()!=null){
				ffmpeg.addCmd("|--font:");
				ffmpeg.addCmd(URLEncoder.encode(
					Path.toUnixPath(Setting.getFontPath()), encoding));
			}
			ffmpeg.addCmd("|--font-index:");
			ffmpeg.addCmd(Setting.getFontIndex());
			ffmpeg.addCmd("|--shadow:" + Setting.getShadowIndex());
			if (Setting.isVhook_ShowConvertingVideo()) {
				ffmpeg.addCmd("|--enable-show-video");
			}
			if (Setting.isFixFontSize()) {
				ffmpeg.addCmd("|--enable-fix-font-size");
			}
			if (Setting.isOpaqueComment()) {
				ffmpeg.addCmd("|--enable-opaque-comment");
				ffmpeg.addCmd("|--opaque:" + Setting.getOpaqueRate());
			}
			if (Setting.isZqPlayer()){
				ffmpeg.addCmd("|--enable-Qwatch");
			}
			if (isWide){
				ffmpeg.addCmd("|--nico-width-wide");
			}
			ffmpeg.addCmd("|--input-size:" + inSize);
			if(setSize != null){
				ffmpeg.addCmd("|--set-size:" + setSize);
			}
			if(padOption != null){
				ffmpeg.addCmd("|--pad-option:" + padOption);
			}
			if(outSize!=null){
				ffmpeg.addCmd("|--out-size:" + outSize);
			}
			if (videoLength > 0){
				ffmpeg.addCmd("|--video-length:");
				ffmpeg.addCmd(Integer.toString(videoLength));
			}
			if (Setting.isFontHeightFix()){
				ffmpeg.addCmd("|--font-height-fix-ratio:"
						+ Setting.getFontHeightFixRaito());
			}
			String comment_speed = Setting.getCommentSpeed();
			if (Setting.isSetCommentSpeed() &&
				comment_speed != null && !comment_speed.isEmpty()){
				ffmpeg.addCmd("|--comment-speed:"
					+ URLEncoder.encode(comment_speed, encoding));
			}
			if(convertIsLive()){
				ffmpeg.addCmd("|--live");
			}
			String extra = Setting.getExtraMode();
			if(extra.contains("-April=")){
				int index = extra.indexOf("-April=");
				aprilFool = extra.substring(index + "-April=".length());
				index = (aprilFool + " ").indexOf(" ");
				aprilFool = aprilFool.substring(0, index).trim();
				extra = extra.replace("-April=" + aprilFool, "");
			}
			if(aprilFool!=null){
				ffmpeg.addCmd("|--april-fool:" + aprilFool);
			}
			if(extra.contains("-wakuiro=")){
				//gFwF@=甼pXy[X܂łƂ
				int index = extra.indexOf("-wakuiro=");
				wakuiro = extra.substring(index + "-wakuiro=".length());
				index = (wakuiro + " ").indexOf(" ");
				wakuiro = wakuiro.substring(0, index);
				extra = extra.replace("-wakuiro=" + wakuiro, "");
			}
			if(wakuiro!=null && !wakuiro.isEmpty()){
				wakuiro = Chat.makeWakuiro(wakuiro);
				ffmpeg.addCmd("|--wakuiro:" + wakuiro);
			}
			if(extra.contains("debug")){
				ffmpeg.addCmd("|--debug-print");
				extra = extra.replace("-debug", "").replace("debug", "");
			}
			if(!extra.isEmpty()){
				ffmpeg.addCmd("|--extra-mode:" + extra.replaceAll(" +", " ").trim().replace(' ', '+'));
			}
			if(!getRopt().isEmpty()){
				ffmpeg.addCmd("|--fr:" + getRopt());
			}
			if(Setting.isEnableCA()){
				ffmpeg.addCmd("|--enable-CA");
				ffmpeg.addCmd("|--font-dir:"
					+ URLEncoder.encode(Path.toUnixPath(fontDir) + "/", encoding));
				ffmpeg.addCmd("|--font-list:");
				ffmpeg.addCmd("0:1+");
				ffmpeg.addCmd(getFontUrl(gothicFont, encoding));
				ffmpeg.addCmd("+1:");
				ffmpeg.addCmd(getFontUrl(simsunFont, encoding));
				ffmpeg.addCmd("+2:");
				ffmpeg.addCmd(getFontUrl(gulimFont, encoding));
				ffmpeg.addCmd("+3:");
				ffmpeg.addCmd(getFontUrl(arialFont, encoding));
				ffmpeg.addCmd("+4:");
				ffmpeg.addCmd(getFontUrl(georgiaFont, encoding));
//				ffmpeg.addCmd(getFontUrl(msuigothicFont, encoding));
				ffmpeg.addCmd("+5:");
				ffmpeg.addCmd(getFontUrl(arialUnicodeFont, encoding));
				ffmpeg.addCmd("+6:");
				ffmpeg.addCmd(getFontUrl(devabagariFont, encoding));
				ffmpeg.addCmd("+7:");
				ffmpeg.addCmd(getFontUrl(tahomaFont, encoding));
				ffmpeg.addCmd("+8:");
				ffmpeg.addCmd(getFontUrl(mingliuFont, encoding));
				String newMinchoPath = getFontUrl(newMinchoFont, encoding);
				if(newMinchoFont.equals(simsunFont)){
					newMinchoPath = "1+" + newMinchoPath;	//NSIMSUN is index 1 of simsun.ttc
				}
				ffmpeg.addCmd("+9:");
				ffmpeg.addCmd(newMinchoPath);
				ffmpeg.addCmd("+10:");
				ffmpeg.addCmd(getFontUrl(estrangeloEdessaFont, encoding));
				ffmpeg.addCmd("+11:");
				ffmpeg.addCmd(getFontUrl(gujaratiFont, encoding));
				ffmpeg.addCmd("+12:");
				ffmpeg.addCmd(getFontUrl(bengalFont, encoding));
				ffmpeg.addCmd("+13:");
				ffmpeg.addCmd(getFontUrl(tamilFont, encoding));
				ffmpeg.addCmd("+14:");
				ffmpeg.addCmd(getFontUrl(laooFont, encoding));
				ffmpeg.addCmd("+15:");
				ffmpeg.addCmd(getFontUrl(gurmukhiFont, encoding));
				ffmpeg.addCmd("+16:");
				ffmpeg.addCmd(getFontUrl(kannadaFont, encoding));
				ffmpeg.addCmd("+17:");
				ffmpeg.addCmd(getFontUrl(thaanaFont, encoding));
				ffmpeg.addCmd("+18:");
				ffmpeg.addCmd(getFontUrl(malayalamFont, encoding));
				ffmpeg.addCmd("+19:");
				ffmpeg.addCmd(getFontUrl(teluguFont, encoding));
				if(Setting.isUseLineSkip()){
					ffmpeg.addCmd("|--use-lineskip-as-fontsize");
				}
				if(Setting.isUseExtraFont()){
					ffmpeg.addCmd("|--extra-font:");
					ffmpeg.addCmd(URLEncoder.encode(
						Setting.getExtraFontText(), encoding));
				}
			}
			if (Setting.isDisableOriginalResize()){
				ffmpeg.addCmd("|--disable-original-resize");
			}
			if (Setting.isFontWidthFix()){
				ffmpeg.addCmd("|--font-width-fix-ratio:"
					+ Setting.getFontWidthFixRaito());
			}
			ffmpeg.addCmd("|--end-of-argument\"");
			return true;
		} catch (UnsupportedEncodingException e) {
			log.printStackTrace(e);
			return false;
		}
	}

	private boolean convertIsLive() {
		if(Setting.isLive()){
			// [Jϊ
			if(Pattern.matches("sm[0-8]|(sm[0-8]_)?lv.*", Tag))		// Tag sm9菬ꍇ lv܂ޏꍇ
				isLive = true;
			if(Tag.length() <= 2 || !Character.isDigit(Tag.charAt(2)))	// 3ڂł͂Ȃꍇ
				isLive = true;
			if(Pattern.matches("[a-zA-Z][0-9].*", Tag))	// p1+̏ꍇ
				isLive = true;
		}
		else if(!MainFrame.idcheck(Tag))	// IDł͂Ȃݒ肳ꂽꍇ(G[ɂȂ?)
			isLive = true;
		return isLive;
	}

	private String getFontUrl(File fontfile,String enc) throws UnsupportedEncodingException {
		if(fontDir.isDirectory() && fontfile.getParentFile().equals(fontDir)){
			return URLEncoder.encode(fontfile.getName(), enc);
		}
		return URLEncoder.encode(Path.toUnixPath(fontfile), enc);
	}

	public boolean isFinished() {
		return StopFlag.isFinished();
	}

	private boolean stopFlagReturn() {
		if (StopFlag.needStop()) {
			sendtext("~܂B");
			result = "97";
			return true;
		}
		return false;
	}

	public ConvertStopFlag getStopFlag() {
		return this.StopFlag;
	}

	private String ExtOption;

	private String InOption;

	private String OutOption;

	private String MainOption;

	private String ffmpegOptionName;

	private String ffmpegVfOption = "";

	private LinkedHashMap<String, String> inputOptionMap = new LinkedHashMap<String, String>(16);

	private LinkedHashMap<String, String> outputOptionMap = new LinkedHashMap<String, String>(40);

	private LinkedHashMap<String, String> mainOptionMap = new LinkedHashMap<String, String>(16);

	private LinkedHashMap<String, String> addOptionMap = new LinkedHashMap<String, String>(16);
	private final String[] SINGLE_KEYWORD = {"-an","-vn","-y","-shortest","-loop_input","-samx","-help","-h",};

	private boolean isSingleKeyword(String keyword){
		for(String s:SINGLE_KEYWORD){
			//ÕL[[h
			if(keyword.equals(s))
				return true;
		}
		return false;
	}

	private boolean setOptionMap(String option, HashMap<String,String> optionMap){
		if (option==null || option.isEmpty()){
			return false;
		}
		Matcher m = Pattern.compile("[^ ]+").matcher(option);
		int start = 0;
		int end = 0;
		int flag = 0;
		// 0: for keyword, 1: for parameter, 2: for additional parameter or next keyword
		boolean processing_quote = false;
		String w = "";
		String keyword = null;
		String parameter = null;
		String non_keyword = "";
		int begin_quote = 0;
		int end_quote = 0;
		char c = 0;
		while(m.find()){
			start = m.start();
			end = m.end();
			w = option.substring(start, end);	//w is word
			c = w.charAt(0);
			if(processing_quote){
				// ""XLbv
				if(start < end_quote)
					continue;
				processing_quote = false;
				end_quote = 0;
			}
			if(c=='"'){
				//quote̍Ō܂ŎsăXLbv
				begin_quote = start;
				end_quote = option.indexOf("\" ", begin_quote+1);
				if(end_quote<0){
					end_quote = option.length();	//̏I܂
				}
				w = option.substring(begin_quote, end_quote);
				if(w.charAt(w.length()-1)!='"'){
					w += "\"";	//parameter""܂
				}
				processing_quote = true;
			}
			switch(flag){
			case 0:
				if(c!='-'){
					log.print("x@L[[hł͂܂:"+w);
					non_keyword += w + " ";
					continue;
				}
				keyword = w;
				parameter = "";
				flag = 1;
				continue;
			case 1:
				if(c=='-'){
					//ÕL[[h`FbN
					if(isSingleKeyword(keyword)){
						//ÕL[[h
						optionMap.put(keyword, "");
						keyword = w;
						parameter = "";
						flag = 1;
						continue;
					}
					log.print("x@'-'gĂ܂:"+w);
				}
				parameter = w + " ";
				flag = 2;
				continue;
			case 2:
				if(c=='-'){
					//̃L[[h?
					//Õp[^
					if(keyword.equals("-map"))
						optionMap.put(keyword+" "+parameter.trim(), "");
					else
						optionMap.put(keyword, parameter.trim());
					keyword = w;
					parameter = "";
					flag = 1;
					continue;
				}
				parameter += w + " ";
				flag = 2;
				continue;
			}
			log.println("oOĂ");
		}
		//parametercĂo^(o̓t@C?)
		if(parameter!=null){
			optionMap.put(keyword, parameter.trim());
		}
		if(!non_keyword.isEmpty()){
			optionMap.put(":non_keyord", non_keyword.trim());
		}
		return true;
	}

	boolean detectOption(boolean isWide, boolean isQ) {
		File option_file = null;
		ffmpegOptionName = "ړ";
		if(isQ){
			option_file = Setting.getZqOptionFile();
			if(option_file == null){
				ExtOption = Setting.getZqCmdLineOptionExt();
				InOption = Setting.getZqCmdLineOptionIn();
				OutOption = Setting.getZqCmdLineOptionOut();
				MainOption = Setting.getZqCmdLineOptionMain();
			}
		} else if (!isWide) {
			option_file = Setting.getOptionFile();
			if(option_file == null){
				ExtOption = Setting.getCmdLineOptionExt();
				InOption = Setting.getCmdLineOptionIn();
				OutOption = Setting.getCmdLineOptionOut();
				MainOption = Setting.getCmdLineOptionMain();
			}
		} else {
			option_file = Setting.getWideOptionFile();
			if(option_file == null){
				ExtOption = Setting.getWideCmdLineOptionExt();
				InOption = Setting.getWideCmdLineOptionIn();
				OutOption = Setting.getWideCmdLineOptionOut();
				MainOption = Setting.getWideCmdLineOptionMain();
			}
		}
		if (option_file != null) {
			try {
				Properties prop = new Properties();
				prop.loadFromXML(new FileInputStream(option_file));
				ExtOption = prop.getProperty("EXT");
				InOption = prop.getProperty("IN");
				OutOption = prop.getProperty("OUT");
				MainOption = prop.getProperty("MAIN");
				if (ExtOption == null || InOption == null || OutOption == null
						|| MainOption == null) {
					return false;
				}
				ffmpegOptionName = option_file.getName().replace(".xml", "");
			} catch (IOException ex) {
				log.printStackTrace(ex);
				return false;
			}
		}
		//IvVɊgq܂ł܂ꍇɂΉ
		if(ExtOption != null && !ExtOption.startsWith(".")){
			ExtOption = "."+ExtOption;
		}
		setOptionMap(InOption, inputOptionMap);
		setOptionMap(MainOption, mainOptionMap);
		setOptionMap(OutOption, outputOptionMap);
		return true;
	}
	private void replace3option(Map<String, String> map) {
		boolean replaced = false;
		for(Entry<String, String> pair : map.entrySet()){
			String key = pair.getKey();
			String value = pair.getValue();
			replaced = false;
			if(mainOptionMap.containsKey(key)){
				mainOptionMap.put(key, value);
				replaced = true;
			}
			if(inputOptionMap.containsKey(key)){
				inputOptionMap.put(key, value);
				replaced = true;
			}
			if(outputOptionMap.containsKey(key)){
				outputOptionMap.put(key, value);
				replaced = true;
			}
			if(!replaced){
				LinkedHashMap<String,String> newoptionmap = new LinkedHashMap<String, String>(40);
				// Vkey OuOption̐擪ɒǉ
				newoptionmap.put(key, value);
				newoptionmap.putAll(outputOptionMap);
				outputOptionMap.clear();
				outputOptionMap = newoptionmap;
			}
		}
	}

	/**
	 * @param option :String
	 * @param key
	 * @param value
	 * @return replaced :String
	 */
	private String getvfOption() {
		String vfIn, vfOut, vfMain, vfOpt;
		vfIn = getvfOption(inputOptionMap);
		deletevfOption(inputOptionMap);
		vfOut = getvfOption(outputOptionMap);
		deletevfOption(outputOptionMap);
		vfMain = getvfOption(mainOptionMap);
		deletevfOption(mainOptionMap);
		vfOpt = vfIn;
		if (vfOpt.isEmpty()){
			vfOpt = vfMain;
		} else if (!vfMain.isEmpty()){
			vfOpt += "," + vfMain;
		}
		if (vfOpt.isEmpty()){
			vfOpt = vfOut;
		} else if (!vfOut.isEmpty()){
			vfOpt += "," + vfOut;
		}
		return vfOpt;
	}

	private static final String VFILTER_FLAG = "-vfilters";
	private static final String VFILTER_FLAG2 = "-vf";
	private String vfilter_flag = VFILTER_FLAG2;
	private String getvfOption(Map<String,String> map){
		if(map==null)
			return "";
		String vfopt = null;
		vfopt = map.get(VFILTER_FLAG);
		if(vfopt==null){
			vfopt = map.get(VFILTER_FLAG2);
		}
		if(vfopt==null)
			return "";
		vfopt = vfopt.trim();
		if(vfopt.charAt(0)=='"')
			vfopt = vfopt.substring(1);
		if(vfopt.charAt(vfopt.length()-1)=='"')
			vfopt = vfopt.substring(0, vfopt.length()-1);
		return vfopt;
	}
	private void deletevfOption(Map<String, String> map) {
		if(map==null)
			return;
		map.remove(VFILTER_FLAG);
		map.remove(VFILTER_FLAG2);
	}
	public String getFFmpegOptionName() {
		return ffmpegOptionName;
	}
	public String getFFmpegVfOption() {
		return ffmpegVfOption;
	}
	public void setFfmpegVfOption(String vfOption) {
		ffmpegVfOption = vfOption;
	}
	/**
	 *
	 * @author orz
	 *
	 */
	private static class VideoIDFilter implements FilenameFilter {
		private final String VideoTag;
		public VideoIDFilter(String videoTag){
			VideoTag = videoTag;
		}
		@Override
		public boolean accept(File dir, String name) {
			if (name.indexOf(VideoTag) >= 0){
				return true;
			}
			return false;
		}
	}

	private void setVideoTitleIfNull(String path) {
		String videoTitle = VideoTitle;
		if (videoTitle == null){
			videoTitle = getTitleFromPath(path, VideoID);
			// ߋO폜
			String regex = "\\[" + WayBackDate.STR_FMT_REGEX + "\\]";
			videoTitle = videoTitle.replaceAll(regex, "");
		//	int index = videoTitle.lastIndexOf("[");
		//		//ߋO[YYYY/MM/DD_HH:MM:SS]Ōɕt
		//	if (index >= 0){
		//		videoTitle = videoTitle.substring(0, index);
		//	}
			log.println("Title<" + videoTitle + ">");
			VideoTitle = videoTitle;
		}
	}

	String detectTitleFromVideo(File dir){
		if (dir == null){ return null; }
		String list[] = dir.list(DefaultVideoIDFilter);
		if(list == null){ return null; }
		for (int i = 0; i < list.length; i++) {
			if (list[i].startsWith(VideoID)) {
				String path = list[i];
				if(path.endsWith(".flv") ||
				   path.endsWith(".mp4") && Setting.isChangeMp4Ext()){
					setVideoTitleIfNull(path);
					return path;
				}
				OtherVideo = path;
				continue;
			}
		}
		return null;
	}

	public String detectTitleFromConvertedVideo(File dir){
		if (dir == null){ return null; }
		String list[] = dir.list(DefaultVideoIDFilter);
		if(list == null){ return null; }
		for (int i = 0; i < list.length; i++) {
			if (list[i].startsWith(VideoID)) {
				String path = list[i];
				int index = path.lastIndexOf(".");
				if (index < 0) continue;
				String ext = path.substring(index).toLowerCase();
				if(ext.equals(".flv") || ext.equals(".mp4")  || ext.equals(".avi")  || ext.equals(".mpg") ){
					return path;
				}
			}
		}
		return null;
	}

	private String detectTitleFromComment(File dir){
		String list[] = dir.list(DefaultVideoIDFilter);
		if(list == null){ return null; }
		for (int i = 0; i < list.length; i++) {
			String path = list[i];
			if (!path.endsWith(".xml") || path.endsWith(OWNER_EXT)
					|| path.endsWith(OPTIONAL_EXT)){
				continue;
			}
			setVideoTitleIfNull(path);
			return path;
		}
		return null;
	}

	private static final String TCOMMENT_EXT =".txml";
	private String detectTitleFromOwnerComment(File dir){
		String list[] = dir.list(DefaultVideoIDFilter);
		if(list == null){ return null; }
		for (int i = 0; i < list.length; i++) {
			String path = list[i];
			String ext;
			if (path.endsWith(OWNER_EXT)){
				ext = OWNER_EXT;
			} else if (path.endsWith(TCOMMENT_EXT)) {
				ext = TCOMMENT_EXT;
			} else {
				continue;
			}
			setVideoTitleIfNull(path.replace(ext,""));
			return path;
		}
		return null;
	}

	private String detectTitleFromOptionalThread(File dir){
		String list[] = dir.list(DefaultVideoIDFilter);
		if(list == null){ return null; }
		for (int i = 0; i < list.length; i++) {
			String path = list[i];
			if (!path.endsWith(OPTIONAL_EXT)){
				continue;
			}
			setVideoTitleIfNull(path.replace(OPTIONAL_EXT, ""));
			return path;
		}
		return null;
	}

	private ArrayList<String> detectFilelistFromComment(File dir){
		String list[] = dir.list(DefaultVideoIDFilter);
		if (list == null) { return null; }
		ArrayList<String> filelist = new ArrayList<String>();
		for (String path : list){
			if (!path.endsWith(".xml") || path.endsWith(OWNER_EXT)
					|| path.endsWith(OPTIONAL_EXT)){
				continue;
			}
			setVideoTitleIfNull(path);
			filelist.add(path);
		}
		return filelist;
	}

	private ArrayList<String> detectFilelistFromOptionalThread(File dir){
		String list[] = dir.list(DefaultVideoIDFilter);
		if (list == null) { return null; }
		ArrayList<String> filelist = new ArrayList<String>();
		for (String path : list){
			if (!path.endsWith(OPTIONAL_EXT)){
				continue;
			}
			setVideoTitleIfNull(path.replace(OPTIONAL_EXT, ""));
			filelist.add(path);
		}
		return filelist;
	}

	/*
	 * 	e҃RgɊւt@C^OƊgq
	 * @@	@Ver.1.25ȍ~̂΂ AɈȉǉ
	 * 			IvViXbh VideoID + VideoTitile + "{Optional}.xml"
	 * 			̉ߋO VideoID + VideoTitile + "[YYYY^MM^DD_HHFmmFss]{Optional}.xml"
	 * 		Â΂
	 * 			[URg = VideoID + VideoTitle + ".xml"
	 * 			ߋO       = VideoID + VideoTitle + "[YYYY^MM^DD_HHFmmFss].xml"
	 * 			e҃Rg = VideoID + VideoTitle + "[Owner].xml"
	 * 		B NicoBrowserg1.4.4̏ꍇ
	 * 			[URg = VideiID + VideoTitle + ".xml"
	 * 			e҃Rg = VideoID + VideoTitle + ".txml"
	 * 		CNNDDȂ
	 * 			[URg = VideoTitle + VideoID + ".xml"
	 * 			e҃Rg = VideoTitle + VideoID + "[Owner].xml"
	 * 		CNicoPlayerȂ
	 * 			[URg = VideoTitle + "(" + Tag + ")" + ".xml"
	 * 			ߋO       = VideoTitie + "(" + Tag + ")[" + YYYYNMMDDHHMMSSb + "}.xml"
	 * 			e҃Rg = VideoTitle + "(" + Tag + "){Owner].xml"
	 *
	 *
	 */

	/*
	 * videoID̈ʒu͖֌Wɍ폜
	 * gq΂̑O܂
	 */
	private String getTitleFromPath(String path, String videoID){
		if (path.indexOf(videoID) >= 0){
			path = path.replace(videoID, "");	// videoID̈ʒu͖֌Wɍ폜
		}
		// gq΂̑O܂
		if (path.lastIndexOf(".") > path.lastIndexOf(File.separator)){
			path = path.substring(0, path.lastIndexOf("."));
		}
		return path;
	}

	public File getConvertedVideoFile() {
		return ConvertedVideoFile;
	}

	public int getId() {
		return tid;
	}
	public String getVid() {
		return Vid;
	}
	public StringBuffer getSbRet() {
		return sbRet;
	}

}
