#include <SDL/SDL.h>
#include "com_surface.h"
#include "surf_util.h"
#include "../mydef.h"

SDL_Surface* connectSurface(SDL_Surface* top,SDL_Surface* bottom){
	//not make nor use alpha channel
	//eather top or bottom may be NULL
	if(top==NULL||bottom==NULL)
		return NULL;
	SDL_Surface* ret = drawNullSurface(MAX(top->w,bottom->w), top->h+bottom->h);
/*
	SDL_Surface* ret = SDL_CreateRGBSurface( SDL_HWSURFACE | SDL_HWACCEL,
											MAX(top->w,bottom->w),
											top->h+bottom->h,
											32,
											#if SDL_BYTEORDER == SDL_BIG_ENDIAN
											    0xff000000,
											    0x00ff0000,
											    0x0000ff00,
											    0x000000ff
											#else
											    0x000000ff,
											    0x0000ff00,
											    0x00ff0000,
												0xff000000
											#endif
											);
*/
	SDL_SetAlpha(top,SDL_RLEACCEL,0xff);	//not use alpha
	SDL_SetAlpha(bottom,SDL_RLEACCEL,0xff);	//not use alpha

	SDL_BlitSurface(top,NULL,ret,NULL);

	SDL_Rect rect2 = {0,top->h,0,0};	//use only x y
	SDL_BlitSurface(bottom,NULL,ret,&rect2);
	SDL_FreeSurface(top);
	SDL_FreeSurface(bottom);
	return ret;
}

void setAlpha(SDL_Surface* surf,double alpha_t){
	int x,y;
	int h = surf->h;
	int w = surf->w;
	Uint32 mask,shift,bytesp,pitch,loss;
	Uint8 alpha;
	Uint8* pixels;
	Uint32* pix;
	SDL_PixelFormat* format = surf->format;
	/*ϐ̐ݒ*/
	mask = format->Amask;
	shift = format->Ashift;
	loss = format->Aloss;
	bytesp = format->BytesPerPixel;
	pitch = surf->pitch;
	pixels = surf->pixels;
	SDL_LockSurface(surf);//T[tFCXbN
	for(y=0;y<h;y++){
		for(x=0;x<w;x++){
			pix = (Uint32*)(&pixels[y*pitch + x*bytesp]);
			alpha = (Uint8)((((*pix) & mask) >> shift) << loss);
			alpha *= alpha_t;
			(*pix) &= ~((0xff >> loss) << shift);
			(*pix) |= (alpha >> loss) << shift;
		}
	}
	SDL_UnlockSurface(surf);//AbN
}

/**
 * src̕sx㏑Ă܂B
 * src̕sȂA㏑B
 */

void overrideAlpha(SDL_Surface *src, SDL_Rect *srcrect, SDL_Surface *dst, SDL_Rect *dstrect){
	SDL_LockSurface(src);//T[tFCXbN
	SDL_LockSurface(dst);//T[tFCXbN
	//͈͂̊m
	int sw = src->w;
	int sh = src->h;
	int sx = 0;
	int sy = 0;
	if(srcrect != NULL){
		sx = srcrect->x;
		sy = srcrect->y;
		if(sx >= sw || sy > sh){
			return;
		}
		sw = MIN(sw-sx,srcrect->w);
		sh = MIN(sh-sy,srcrect->h);
	}
	int dw = dst->w;
	int dh = dst->h;
	int dx = 0;
	int dy = 0;
	if(dstrect != NULL){
		dx = dstrect->x;
		dy = dstrect->y;
		if(dx >= dw || dy > dh){
			return;
		}
		dw = MIN(dw-dx,dstrect->w);
		dh = MIN(dh-dy,dstrect->h);
	}
	//قɂ킹
	if(dw > sw){
		dw = sw;
	}else{
		sw = dw;
	}
	if(dh > sh){
		dh = sh;
	}else{
		sh = dh;
	}
	//Ƃ`BB
	int sbytesp = src->format->BytesPerPixel;
	int dbytesp = dst->format->BytesPerPixel;
	int spitch = src->pitch;
	int dpitch = dst->pitch;
	int sAmask = src->format->Amask;
	int dAmask = dst->format->Amask;
	int sAshift = src->format->Ashift;
	int dAshift = dst->format->Ashift;
	int sAloss = src->format->Aloss;
	int dAloss = dst->format->Aloss;
	Uint8* spix = (Uint8*)src->pixels;
	Uint8* dpix = (Uint8*)dst->pixels;
	Uint32* spt;
	Uint32* dpt;
	Uint32 salpha;
	Uint32 dalpha;
	int x,y;
	for(y=0;y<sh;y++){
		for(x=0;x<sw;x++){
			spt = (Uint32*)(&spix[(sy+y)*spitch+(sx+x)*sbytesp]);
			dpt = (Uint32*)(&dpix[(dy+y)*dpitch+(dx+x)*dbytesp]);
			salpha = ((*spt & sAmask)>>sAshift)<<sAloss;
			dalpha = ((*dpt & dAmask)>>dAshift)<<dAloss;
			if(salpha > dalpha){
				*dpt &= ~dAmask;
				*dpt |= (salpha>>dAloss)<<dAshift;
			}
		}
	}
	SDL_UnlockSurface(dst);//AbN
	SDL_UnlockSurface(src);//AbN
}

void inline shadowBlitSurface(SDL_Surface *src, SDL_Rect *srcrect, SDL_Surface *dst, SDL_Rect *dstrect){
	SDL_BlitSurface(src,srcrect,dst,dstrect);
	overrideAlpha(src,srcrect,dst,dstrect);
}

void setRGB(SDL_Surface* surf,Uint32 color){
	int x,y;
	int h = surf->h;
	int w = surf->w;
	int bytesp = surf->format->BytesPerPixel;
	int pitch = surf->pitch;
	Uint32 Amask = surf->format->Amask;
	color &= surf->format->Rmask | surf->format->Gmask | surf->format->Bmask;
	Uint8* pix = (Uint8*)surf->pixels;
	Uint32* pt;
	SDL_LockSurface(surf);//T[tFCXbN
	for(y=0;y<h;y++){
		for(x=0;x<w;x++){
			pt = (Uint32*)(&pix[y*pitch + x*bytesp]);
			*pt &= Amask;
			*pt |= color;
		}
	}
	SDL_UnlockSurface(surf);//T[tFCXAbN
}

void getRGBA(SDL_Surface* surf,int x,int y,char* r,char* g,char* b,char* a){
	int pix_index = y * surf->pitch + x * surf->format->BytesPerPixel;
	char* pix = (char*)surf->pixels;
	SDL_GetRGBA(*(Uint32*)(&pix[pix_index]),surf->format,(Uint8*)r,(Uint8*)g,(Uint8*)b,(Uint8*)a);
}

int cmpSDLColor(SDL_Color col1, SDL_Color col2){
	return (col1.r == col2.r && col1.g == col2.g && col1.b == col2.b);
}

char* getColorName(char* buf, int color){
	if(color >= 0){
		return CMD_COLOR_NAME[(color & 15)];
	}
	sprintf(buf,"#%06x",(color & 0x00ffffff));
	return buf;
}
