/*
 * Decompiled with CFR 0.152.
 */
package saccubus.conv;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import saccubus.conv.ChatArray;
import saccubus.conv.MultiXMLHandler;

public class CombineXML {
    public static boolean combineXML(ArrayList<File> filelist, File output) {
        block9: {
            System.out.print("Starting Combining XML files. ");
            if (filelist != null && !filelist.isEmpty()) break block9;
            return false;
        }
        try {
            ChatArray chatArray = new ChatArray();
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser saxparser = spfactory.newSAXParser();
            MultiXMLHandler xmlhandler = new MultiXMLHandler(chatArray);
            for (File file : filelist) {
                String filename = file.getName();
                if (filename == null) break;
                int index = filename.lastIndexOf("[");
                if (index > 0) {
                    int index2 = filename.lastIndexOf("]");
                    if (index2 < index) {
                        index2 = filename.length();
                    }
                    filename = filename.substring(index + 1, index2);
                }
                System.out.print(String.valueOf(filename) + ". ");
                saxparser.parse(file, (DefaultHandler)xmlhandler);
            }
            chatArray.writeXML(output);
            System.out.println("\nCombining finished.");
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (PatternSyntaxException ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

