/*
 * Decompiled with CFR 0.152.
 */
package saccubus.conv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import saccubus.conv.CommentReplace;
import saccubus.util.Util;

public class Chat {
    private static final int CMD_LOC_DEF = 0;
    private static final int CMD_LOC_TOP = 1;
    private static final int CMD_LOC_BOTTOM = 2;
    private static final int CMD_LOC_NAKA = 3;
    private static final int CMD_LOC_FULL = 4;
    private static final int CMD_LOC_WAKU = 8;
    static final int CMD_LOC_SCRIPT = 16;
    private static final int CMD_LOC_PATISSIER = 32;
    private static final int CMD_LOC_INVISIBLE = 64;
    static final int CMD_LOC_IS_BUTTON = 128;
    static final int CMD_LOC_SCRIPT_FOR_OWNER = 256;
    static final int CMD_LOC_SCRIPT_FOR_USER = 512;
    private static final int CMD_LOC_ENDER = 1024;
    private static final int CMD_MAX_SECONDS = 65535;
    private static final int CMD_LOC_SECONDS_BITS = 16;
    private static final int CMD_LOC_SECONDS_MASK = -65536;
    private static final int CMD_SIZE_DEF = 0;
    private static final int CMD_SIZE_BIG = 1;
    private static final int CMD_SIZE_SMALL = 2;
    private static final int CMD_SIZE_MEDIUM = 3;
    private static final int[] COMMENT_FONT_SIZE = new int[]{24, 39, 15};
    private static final int CMD_COLOR_DEF = 0;
    private static final int CMD_COLOR_RED = 1;
    private static final int CMD_COLOR_ORANGE = 2;
    private static final int CMD_COLOR_YELLOW = 3;
    private static final int CMD_COLOR_PINK = 4;
    private static final int CMD_COLOR_BLUE = 5;
    private static final int CMD_COLOR_PURPLE = 6;
    private static final int CMD_COLOR_CYAN = 7;
    private static final int CMD_COLOR_GREEN = 8;
    private static final int CMD_COLOR_NICOWHITE = 9;
    private static final int CMD_COLOR_MARINEBLUE = 10;
    private static final int CMD_COLOR_MADYELLOW = 11;
    private static final int CMD_COLOR_PASSIONORANGE = 12;
    private static final int CMD_COLOR_NOBLEVIOLET = 13;
    private static final int CMD_COLOR_ELEMENTALGREEN = 14;
    private static final int CMD_COLOR_TRUERED = 15;
    private static final int CMD_COLOR_BLACK = 16;
    private static final int CMD_COLOR_WHITE = 17;
    private static final int CMD_COLOR_NONE = 99;
    private static final int CMD_COLOR_ERROR = 100;
    private int Color = 0;
    private boolean isColorAssigned = false;
    private int Size = 0;
    private boolean isSizeAssigned = false;
    private int Location = 0;
    private boolean isLocationAssigned = false;
    private int No = 0;
    private int Vpos = 0;
    private boolean IsOwner = false;
    private String Comment = "";
    String strsec = "";
    int sec = 0;

    public void setMail(String mail_str) {
        this.Color = 0;
        this.Size = 0;
        this.Location = 0;
        if (mail_str == null) {
            return;
        }
        String[] element = mail_str.split(" +");
        int i = 0;
        while (i < element.length) {
            String str = element[i].toLowerCase();
            if (str.equals("ue") && !this.isLocationAssigned) {
                this.Location |= 1;
                this.isLocationAssigned = true;
            } else if (str.equals("shita") && !this.isLocationAssigned) {
                this.Location |= 2;
                this.isLocationAssigned = true;
            } else if (str.equals("naka") && !this.isLocationAssigned) {
                this.Location |= 3;
                this.isLocationAssigned = true;
            } else if ((str.startsWith("@") || str.startsWith("\uff20")) && this.strsec.isEmpty()) {
                this.strsec = str.substring(1);
                if (!this.strsec.isEmpty()) {
                    try {
                        this.sec = Integer.parseInt(this.strsec) + 1;
                        this.Location |= (this.sec & 0xFFFF) << 16 & 0xFFFF0000;
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            } else if (str.equals("full")) {
                this.Location |= 4;
            } else if (str.equals("waku")) {
                this.Location |= 8;
            } else if (str.equals("patissier")) {
                this.Location |= 0x20;
            } else if (str.equals("invisible")) {
                this.Location |= 0x40;
            } else if (str.equals("is_button")) {
                this.Location |= 0x80;
            } else if (str.equals("ender")) {
                this.Location |= 0x400;
            } else if (str.equals("big") && !this.isSizeAssigned) {
                this.Size = 1;
                this.isSizeAssigned = true;
            } else if (str.equals("small") && !this.isSizeAssigned) {
                this.Size = 2;
                this.isSizeAssigned = true;
            } else if (str.equals("medium") && !this.isSizeAssigned) {
                this.Size = 3;
                this.isSizeAssigned = true;
            } else {
                int color = Chat.getColorNumber(str);
                if (color != 99) {
                    if (this.isColorAssigned) {
                        System.out.println("[Chat.java]COLOR twice=" + str + ",mail=" + mail_str);
                    } else if (color == 100) {
                        System.out.println("[Chat.java]COLOR warning str=" + str + ",mail=" + mail_str);
                        this.Color = 0;
                        this.isColorAssigned = true;
                    } else {
                        this.Color = color;
                        this.isColorAssigned = true;
                    }
                }
            }
            ++i;
        }
    }

    public void setNo(String no_str) {
        try {
            this.No = Integer.parseInt(no_str);
        }
        catch (Exception e) {
            this.No = -1;
        }
    }

    public void setNo(int n) {
        this.No = n;
    }

    public int getNo() {
        return this.No;
    }

    public void setVpos(String vpos_str) {
        try {
            this.Vpos = Integer.parseInt(vpos_str);
        }
        catch (Exception e) {
            this.Vpos = -1;
        }
    }

    public void setComment(String com_str) {
        this.Comment = String.valueOf(this.Comment) + com_str;
    }

    public void write(OutputStream os) throws IOException {
        byte[] a = new byte[2];
        try {
            a = (String.valueOf(this.Comment) + "\u0000").getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        Util.writeInt(os, this.No);
        Util.writeInt(os, this.Vpos);
        Util.writeInt(os, this.Location);
        Util.writeInt(os, this.Size);
        Util.writeInt(os, this.Color);
        Util.writeInt(os, a.length);
        try {
            os.write(a);
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
            throw new IOException("[Chat/write:2]Processing:" + this.No + "<" + this.Comment + ">");
        }
    }

    public void addCmd(int cmd) {
        this.Location |= cmd;
    }

    public static String makeWakuiro(String wakuiro) {
        String[] list;
        if (!wakuiro.replaceAll("[=:,;]+", "-").contains("-")) {
            int color = Chat.getColorNumber(wakuiro);
            if (color < 0) {
                return "0x" + Integer.toString(color -= Integer.MIN_VALUE, 16);
            }
            return Integer.toString(color);
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = list = wakuiro.split("[,;]+");
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String pairstr = stringArray[n2];
            String[] pair = pairstr.split("[=:]+");
            if (pair.length >= 2) {
                int color;
                if (Character.isDigit(pair[0].charAt(0))) {
                    sb.append(pair[0]);
                } else {
                    sb.append("_");
                    color = Chat.getColorNumber(pair[0]);
                    if (color < 0) {
                        sb.append("0x" + Integer.toString(color -= Integer.MIN_VALUE, 16));
                    } else if (color == 99 || color == 100) {
                        sb.append(Integer.toString(0));
                    } else {
                        sb.append(Integer.toString(color));
                    }
                }
                sb.append("_");
                color = Chat.getColorNumber(pair[1]);
                if (color < 0) {
                    sb.append("0x" + Integer.toString(color -= Integer.MIN_VALUE, 16));
                } else if (color == 99 || color == 100) {
                    sb.append(Integer.toString(3));
                } else {
                    sb.append(Integer.toString(color));
                }
                sb.append("/");
            }
            ++n2;
        }
        return sb.toString();
    }

    static int getColorNumber(String str) {
        int color;
        block23: {
            if (str.equals("def")) {
                return 0;
            }
            if (str.equals("red")) {
                return 1;
            }
            if (str.equals("orange")) {
                return 2;
            }
            if (str.equals("yellow")) {
                return 3;
            }
            if (str.equals("pink")) {
                return 4;
            }
            if (str.equals("blue")) {
                return 5;
            }
            if (str.equals("purple")) {
                return 6;
            }
            if (str.equals("cyan")) {
                return 7;
            }
            if (str.equals("green")) {
                return 8;
            }
            if (str.equals("niconicowhite") || str.equals("white2")) {
                return 9;
            }
            if (str.equals("arineblue") || str.equals("blue2")) {
                return 10;
            }
            if (str.equals("madyellow") || str.equals("yellow2")) {
                return 11;
            }
            if (str.equals("passionorange") || str.equals("orange2")) {
                return 12;
            }
            if (str.equals("nobleviolet") || str.equals("purple2")) {
                return 13;
            }
            if (str.equals("elementalgreen") || str.equals("green2")) {
                return 14;
            }
            if (str.equals("truered") || str.equals("red2")) {
                return 15;
            }
            if (str.equals("black")) {
                return 16;
            }
            if (str.equals("white")) {
                return 17;
            }
            if (!str.startsWith("#")) {
                return 99;
            }
            if (str.length() < 7) {
                return 100;
            }
            try {
                color = Integer.decode(str);
                if (color >= 0 && color <= 0xFFFFFF) break block23;
                return 100;
            }
            catch (NumberFormatException e) {
                return 100;
            }
        }
        return color + Integer.MIN_VALUE;
    }

    int getVpos() {
        return this.Vpos;
    }

    void process(CommentReplace cr) {
        this.Comment = cr.replace(this.Comment);
        Chat item = cr.getChat();
        if (item.Color != 0) {
            this.Color = item.Color;
        }
        if (item.Size != 0) {
            this.Size = item.Size;
        }
        if ((item.Location & 3) != 0) {
            this.Location = this.Location & 0xFFFFFFFC | item.Location & 3;
        }
    }

    boolean isScript() {
        return (this.Location & 0x10) != 0;
    }

    void setOwner(boolean is_owner) {
        this.IsOwner = is_owner;
    }

    boolean isOwner() {
        return this.IsOwner;
    }
}

