/*
 * Decompiled with CFR 0.152.
 */
package saccubus;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JLabel;
import saccubus.ConvertStopFlag;
import saccubus.FFmpeg;
import saccubus.util.BitReader;
import saccubus.util.Cws2Fws;
import saccubus.util.Stopwatch;

public class VideofileInfo {
    private final File videoFile;
    private FFmpeg ffmpeg;
    private final HashMap<String, LinkedList<String>> videoInfoMap = new HashMap(0);
    public static final String[] VIDEOINFO_KEYS = new String[]{"Duration:", "Video:", "Audio:"};
    private final StringBuffer output;
    private String src = null;
    private FFmpeg.Aspect aspect = null;
    private int duration = -1;
    private double frameRate = -1.0;
    private final JLabel status;
    private final ConvertStopFlag flag;
    private final Stopwatch watch;

    public VideofileInfo(File videofile, FFmpeg ffmpeg, JLabel status, ConvertStopFlag flag, Stopwatch watch) {
        this.videoFile = videofile;
        this.ffmpeg = ffmpeg;
        this.status = status;
        this.flag = flag;
        this.watch = watch;
        this.output = new StringBuffer();
        this.initInfoMap(VIDEOINFO_KEYS);
    }

    public void initInfoMap(String[] infokeys) {
        this.ffmpeg.setCmd("-y -i ");
        this.ffmpeg.addFile(this.videoFile);
        System.out.println("get Info:" + this.ffmpeg.getCmd());
        int abortedCode = 0;
        class InfoMapCallback
        implements FFmpeg.CallbackInterface {
            private final /* synthetic */ String[] val$infokeys;

            InfoMapCallback(String[] stringArray) {
                this.val$infokeys = stringArray;
            }

            @Override
            public void doEveryLoop(String e) {
                VideofileInfo.this.watch.show();
                String[] stringArray = this.val$infokeys;
                int n = this.val$infokeys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (e.contains(key)) {
                        System.out.println(" " + e.trim());
                        VideofileInfo.this.output.append(String.valueOf(e.trim()) + "\n");
                        e = e.replace(key, "").trim();
                        LinkedList<String> list = new LinkedList<String>();
                        String[] stringArray2 = e.split(",+");
                        int n3 = stringArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String v = stringArray2[n4];
                            if (!v.isEmpty()) {
                                list.add(v.trim());
                            }
                            ++n4;
                        }
                        VideofileInfo.this.videoInfoMap.put(key, list);
                    }
                    ++n2;
                }
            }

            @Override
            public boolean checkStop() {
                return VideofileInfo.this.flag.needStop();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAbort(String e) {
                JLabel jLabel = VideofileInfo.this.status;
                synchronized (jLabel) {
                    VideofileInfo.this.status.setText("ffmpeg\u306e\u5b9f\u884c\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f\u3002");
                }
            }
        }
        this.ffmpeg.exec(abortedCode, new InfoMapCallback(infokeys));
        this.src = this.output.toString();
    }

    public FFmpeg.Aspect getAspect() {
        if (this.aspect == null) {
            this.aspect = this.getAspect0();
        }
        return this.aspect;
    }

    private FFmpeg.Aspect getAspect0() {
        long height;
        long width;
        block20: {
            width = 0L;
            height = 0L;
            if (Cws2Fws.isFws(this.videoFile)) {
                FileInputStream fis = null;
                System.out.println("get aspect from FWS(swf)");
                try {
                    try {
                        fis = new FileInputStream(this.videoFile);
                        BitReader br = new BitReader(fis);
                        int bit = (int)br.readBit(32);
                        bit = (int)br.readBit(32);
                        bit = (int)br.readBit(5);
                        width = br.readBit(bit);
                        width = br.readBit(bit);
                        width /= 20L;
                        height = br.readBit(bit);
                        height = br.readBit(bit);
                        height /= 20L;
                        break block20;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        FFmpeg.Aspect aspect = FFmpeg.Aspect.ERROR;
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return aspect;
                    }
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            LinkedList<String> strs = this.videoInfoMap.get("Video:");
            if (strs == null) {
                return FFmpeg.Aspect.ERROR;
            }
            block13: for (String str : strs) {
                String[] list;
                if (!str.contains("x")) continue;
                str = str.replaceAll("[^0-9x]", "_");
                String[] stringArray = list = str.split("_+");
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (!s.isEmpty() && !(str = s).startsWith("0x") && (list = str.split("x")) != null && list.length == 2) {
                        try {
                            width = Long.parseLong(list[0]);
                            height = Long.parseLong(list[1]);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        if (width != 0L && height != 0L) continue block13;
                    }
                    ++n2;
                }
            }
        }
        FFmpeg.Aspect asp = new FFmpeg.Aspect((int)width, (int)height);
        System.out.println(asp.explain());
        return asp;
    }

    public int getDuration() {
        if (this.duration == -1) {
            this.duration = this.getDuration0();
        }
        return this.duration;
    }

    private int getDuration0() {
        String TEXT_DURATION = "Duration:";
        String duration = "";
        if (!this.src.contains(TEXT_DURATION)) {
            return 0;
        }
        int index = this.src.indexOf(TEXT_DURATION) + TEXT_DURATION.length();
        duration = this.src.substring(index, this.src.indexOf(",", index)).trim();
        String tms = "";
        int it = 0;
        try {
            index = duration.lastIndexOf(":");
            if (index < 0) {
                tms = duration;
                duration = "";
            } else {
                tms = duration.substring(index + 1);
                duration = duration.substring(0, index);
            }
            it = tms.contains(".") ? (int)Double.parseDouble(tms) : Integer.parseInt(tms);
            index = duration.lastIndexOf(":");
            if (index < 0) {
                tms = duration;
                duration = "";
            } else {
                tms = duration.substring(index + 1);
                duration = duration.substring(0, index);
            }
            it += Integer.parseInt(tms) * 60;
            if (!duration.isEmpty()) {
                it += Integer.parseInt(duration) * 3600;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return it;
    }

    public double getFrameRate() {
        if (this.frameRate == -1.0) {
            this.frameRate = this.getFramerate0();
        }
        return this.frameRate;
    }

    private double getFramerate0() {
        LinkedList<String> strs = this.videoInfoMap.get("Video:");
        double r = 0.0;
        if (strs == null) {
            return r;
        }
        System.out.println("getFramerate: videoInfoMap");
        try {
            for (String str : strs) {
                System.out.print(String.valueOf(str) + ",");
                if (!str.contains("tbr")) continue;
                str = str.replace("tbr", "").trim();
                r = Double.parseDouble(str);
                break;
            }
        }
        catch (NumberFormatException e) {
            r = 0.0;
        }
        catch (NullPointerException e) {
            r = 0.0;
        }
        return r;
    }
}

