'use strict';

var electron = require('electron');
function build(mainWin, cfg) {
    var template = [{
        label: 'Menu',
        id: 'menu',
        submenu: [{
            label: 'Reload',
            click: function click() {
                return mainWin.reload();
            }
        }, {
            label: 'Toggle DevTools',
            click: function click() {
                return mainWin.webContents.toggleDevTools();
            }
        }, {
            type: 'separator'
        }, {
            label: 'Quit',
            click: function click() {
                return mainWin.close();
            }
        }]
    }, {
        label: 'Thema',
        id: 'thema',
        submenu: [{
            label: 'Normal',
            id: 'thema-normal',
            type: 'checkbox',
            checked: cfg.thema == 'thema-normal',
            click: function click() {
                mainWin.webContents.executeJavaScript("changeThema('thema-normal')");
            }
        }, {
            label: 'Dark',
            id: 'thema-dark',
            type: 'checkbox',
            checked: cfg.thema == 'thema-dark',
            click: function click() {
                mainWin.webContents.executeJavaScript("changeThema('thema-dark')");
            }
        }]
    }];
    var menu = electron.Menu.buildFromTemplate(template);
    electron.Menu.setApplicationMenu(menu);
    return menu;
}
exports.build = build;
;