'use strict';

/// <reference path="../../typings/tsd.d.ts" />
var fs = require('fs');
var path = require('path');
var defaultConfig = {
    thema: 'thema-normal'
};
function readConfig(execPath) {
    try {
        var cfgPath = getConfigFilePath(execPath);
        return JSON.parse(fs.readFileSync(cfgPath, "utf8"));
    } catch (e) {
        console.log("can not read markcat.json");
        return defaultConfig;
    }
}
exports.readConfig = readConfig;
function writeConfig(execPath, cfg) {
    var cfgPath = getConfigFilePath(execPath);
    fs.writeFile(cfgPath, JSON.stringify(cfg, null, '  '));
}
exports.writeConfig = writeConfig;
function getConfigFilePath(execPath) {
    return path.dirname(execPath) + "/markcat.json";
}