'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var chokidar = require('chokidar');
var fs = require('fs');

var Watcher = function () {
    function Watcher(path, handleUpdate) {
        _classCallCheck(this, Watcher);

        this.currentPath = path;
        this.handleUpdate = handleUpdate;
        this.watcher = chokidar.watch(this.currentPath);
        this.watcher.on('add', this.onUpdate.bind(this));
        this.watcher.on('change', this.onUpdate.bind(this));
    }

    _createClass(Watcher, [{
        key: 'changeWatchPath',
        value: function changeWatchPath(path) {
            this.watcher.unwatch(this.currentPath);
            this.watcher.add(path);
            this.currentPath = path;
        }
    }, {
        key: 'onUpdate',
        value: function onUpdate(path, stats) {
            var _this = this;

            fs.readFile(path, 'utf8', function (err, content) {
                if (err) throw err;
                _this.handleUpdate(content);
            });
        }
    }]);

    return Watcher;
}();

exports.Watcher = Watcher;