'use strict';

var remote = require('remote');
function changeThema(themaId) {
    var cfg = remote.getGlobal('cfg');
    cfg.thema = themaId;
    remote.require('./services/config').writeConfig(remote.process.execPath, cfg);
    switch (themaId) {
        case 'thema-normal':
            changeThemaMenu(themaId);
            changeCssThemaFile('./css/thema-normal.css');
            break;
        case 'thema-dark':
            changeThemaMenu(themaId);
            changeCssThemaFile('./css/thema-dark.css');
            break;
    }
}
exports.changeThema = changeThema;
function changeThemaMenu(themaId) {
    var themaThemaMenu = remote.app.getApplicationMenu().items.find(function (item) {
        return item.id == 'thema';
    });
    var themaNormalItem = themaThemaMenu.submenu.items.find(function (item) {
        return item.id == 'thema-normal';
    });
    var themaDarkItem = themaThemaMenu.submenu.items.find(function (item) {
        return item.id == 'thema-dark';
    });
    switch (themaId) {
        case 'thema-normal':
            themaNormalItem.checked = true;
            themaDarkItem.checked = false;
            break;
        case 'thema-dark':
            themaNormalItem.checked = false;
            themaDarkItem.checked = true;
            break;
    }
}
function changeCssThemaFile(cssFilePath) {
    var linkEl = document.getElementById('css-thema');
    linkEl.href = cssFilePath;
}